<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');
class PGS_model extends CI_Model {
	function __construct(){
		parent:: __construct();
		$this->load->helper('hrms_helper'); // load healper
		$this->hrms_where =  pgsEmp_where('e');
		//$this->pgsEmp_where =  pgsEmp_where('e');
	}

	public function pgs_group($where="NULL",$order=""){
		if($where!="NULL"){
		$this->db->where($where); 
		}
		if($order!="NULL"){
		$this->db->order_by($order); 
		}
		
		$this->db->select('g.*, t.*'); 
		$this->db->join('tbl_pgs_template as t', 'g.pg_pt_id = t.pt_id','left');
		$this->db->from('tbl_pgs_group AS g');
		$this->db->order_by('g.pg_id ASC');
		return $this->db->get()->result_array(); 
	}
	//---- USE in activate phase all function, manager_tab, submit_form_development
	public function pgs_form_emp_list($where="NULL",$order="NULL"){
		//print_r($where);
		if($where!="NULL"){
		$this->db->where($where); 
		}
		if($order!="NULL"){
		$this->db->order_by($order); 
		}
		 
		$this->db->where($this->hrms_where);
		
		//$this->db->where('e.e_delete=0 AND e.e_working_status=1'); 

		$sel=$this->db->select('e.e_id,
		CONCAT(e.e_employee_id_pre,e.e_employee_id) AS employee_id,
		CONCAT(e.e_first_name," ",e.e_last_name) AS e_name,
		e.e_supervisor_employee_id,
		e.e_working_status,
		e.e_office_email_id,
		p.*,pa.pa_id,a.ap_approver_id
		',false);   
		 
		
		$this->db->join('tbl_pgs_form as p', 'p.pf_e_id = e.e_id','left');
		//$this->db->join('tbl_pgs_template_assign as pa', 'pa.pa_e_id = e.e_id AND pa.pa_id = (select max(pa_id) from tbl_pgs_template_assign as pa2 where pa2.pa_e_id = pa.pa_e_id)','left');
		$this->db->join('tbl_pgs_template_assign as pa', 'pa.pa_e_id = e.e_id AND pa.pa_id = p.pf_pa_id','left');
		$this->db->join('tbl_pgs_form_activation as pfa', 'pfa.pfa_id = p.pf_pfa_id','left');
		$this->db->join('tbl_approver as a', 'a.ap_e_id = e.e_id AND a.ap_module_id=4','left');
		$this->db->from('tbl_employee AS e');
		$this->db->order_by('e.e_employee_id ASC');
		$qry = $this->db->get()->result_array(); 
		//echo "<pre>"; print_r($sel); echo "</pre>"; die;
		return $qry; 
	}
	
	public function pgs_noapp_emp_list($where="NULL",$order="NULL"){ 
		if($where!="NULL"){
		$this->db->where($where); 
		}
		if($order!="NULL"){
		$this->db->order_by($order); 
		}

		$this->db->where($this->hrms_where); 
		$sel=$this->db->select('e.e_id,
		CONCAT(e.e_employee_id_pre,e.e_employee_id) AS employee_id,
		CONCAT(e.e_first_name," ",e.e_last_name) AS e_name,
		e.e_supervisor_employee_id, e.e_working_status,
		e.e_office_email_id,e.e_joinning_date,
		pa.*, t.pt_id, t.pt_name,
		a.ap_approver_id,
		e.e_working_status AS pf_e_working_status,
		"NOT STARTED" AS pf_phase,
		w.w_status,
		w.w_color
		',false);   
		 
		$this->db->join('tbl_pgs_template_assign as pa', 'pa.pa_e_id = e.e_id AND pa.pa_id = (select max(pa_id) from tbl_pgs_template_assign as pa2 where pa2.pa_e_id = pa.pa_e_id)','left');
		$this->db->join('tbl_pgs_template as t', 'pa.pa_pt_id = t.pt_id','left'); 
		$this->db->join('tbl_approver as a', 'a.ap_e_id = e.e_id AND a.ap_module_id=4','left');
		$this->db->join('tbl_working_status as w', 'w.w_id = e.e_working_status','left');
		
		$this->db->from('tbl_employee AS e');
		$this->db->order_by('e.e_employee_id ASC');
		$qry = $this->db->get()->result_array(); 
		//echo "<pre>"; print_r($sel); echo "</pre>"; die;
		return $qry; 
	}
	/*public function pgs_form_empinfo($where="NULL"){
		if($where!="NULL"){
		$this->db->where($where); 
		}
		
		$this->db->where($this->hrms_where);
		//$this->db->where('e.e_delete=0 AND e.e_working_status=1'); 

		$this->db->select('e.e_id,
		CONCAT(e.e_employee_id_pre,e.e_employee_id) AS employee_id,
		CONCAT(e.e_first_name," ",e.e_last_name) AS e_name,
		CONCAT(sup.e_employee_id_pre,sup.e_employee_id) AS e_supervisor_employee_id, 
		CONCAT(sup.e_first_name," ",sup.e_last_name) AS e_supervisor_employee_name, 
		d.d_designation AS e_designation,
		p.*,pa.pa_form AS pa_form
		'); 

		$this->db->join('tbl_employee as e', 'p.pf_e_id = e.e_id','left');
		$this->db->join('tbl_designation as d', 'd.d_id = e.e_designation','left');
		$this->db->join('tbl_employee as sup', 'sup.e_id = e.e_supervisor_employee_id','left');
		$this->db->join('tbl_pgs_template_assign as pa', 'pa.pa_e_id = e.e_id','left');
		$this->db->from('tbl_pgs_form AS p');
		$this->db->order_by('e.e_employee_id ASC');
		return $this->db->get()->result_array(); 
	}*/
	
	//--- USE IN manager- view_form, 
	public function pgs_form_empinfo($where="NULL",$order="NULL"){
		if($where!="NULL"){
		$this->db->where($where); 
		}
		if($order!="NULL"){
		$this->db->order_by($order); 
		}
		$this->db->where($this->hrms_where);
		//$this->db->where('e.e_delete=0 AND e.e_working_status=1'); 



		$sel=$this->db->select('e.e_id AS e_id,
		CONCAT(e.e_employee_id_pre,e.e_employee_id) AS employee_id,
		CONCAT(e.e_first_name," ",e.e_last_name) AS e_name,
		e.e_gender,e.e_contact_no_office,e.e_contact_no_mobile, e.e_office_email_id,
		CONCAT(sup.e_employee_id_pre,sup.e_employee_id) AS e_supervisor_employee_id,
		CONCAT(sup.e_first_name," ",sup.e_last_name) AS e_supervisor_employee_name, 
		d.d_designation AS e_designation,
		e.e_employee_type,e.e_joinning_date, e.e_working_status,
		p.*,pa.pa_form AS pa_form, 
		pa.pa_id,
		pa.pa_top AS pa_top,
		pa.pa_left AS pa_left,
		pa.pa_right AS pa_right,
		pa.pa_bottom AS pa_bottom,
		pa.pa_active_status,
		pa.pa_objective_category,
		pa.pa_measurement_criteria,
		pfa.* 
		
		');   
 
		$this->db->join('tbl_employee as e', 'p.pf_e_id = e.e_id','left');
		$this->db->join('tbl_designation as d', 'd.d_id = e.e_designation','left');
		$this->db->join('tbl_employee as sup', 'sup.e_id = e.e_supervisor_employee_id','left');
		//$this->db->join('tbl_pgs_template_assign as pa', 'pa.pa_e_id = e.e_id AND pa.pa_id = (select max(pa_id) from tbl_pgs_template_assign as pa2 where pa2.pa_e_id = pa.pa_e_id)','left');
		$this->db->join('tbl_pgs_template_assign as pa', 'pa.pa_e_id = e.e_id AND pa.pa_id = p.pf_pa_id','left');
		$this->db->join('tbl_pgs_form_activation as pfa', 'pfa.pfa_id = p.pf_pfa_id','left');
		$this->db->from('tbl_pgs_form AS p');
		$this->db->order_by('e.e_employee_id ASC');
		$qry = $this->db->get()->result_array(); 
		//echo "<pre>"; print_r($sel); die; 
		return $qry;
	}
	
	public function ckeckYear(){
		$current_date = date('Y-m-d');
		$whr = "( DATE_ADD(pfa_period_end_date, INTERVAL 1 DAY)  >= '$current_date' AND pfa_status=0)"; 
		$appDatas=$this->model->sortingWheredata("*","tbl_pgs_form_activation",$whr,'pfa_id DESC');
		if(count($appDatas) > 0){ return $appDatas[0]["pfa_id"]; }else{ return 0; }
	}
	 
	//------- CRON FUN ---------
		public function pgs_form_data($where="NULL",$lmt="NULL"){
		if($where!="NULL"){
		$this->db->where($where); 
		}
		if($lmt!="NULL"){
		$this->db->limit($lmt);
		}
		
		$this->db->where($this->hrms_where);
		//$this->db->where('e.e_delete=0 AND e.e_working_status=1'); 

		$sel=$this->db->select('pf_id, pf_e_id, pf_pa_id, pf_submit_obj, pf_agree_obj, pf_submit_mid_employee, pf_submit_mid_manager, pf_submit_end_employee, pf_submit_end_manager, pf_obj_phase_end_date, pf_mid_yr_phase_end_date,  pf_yr_end_phase_end_date,pf_email_send,pf_close_status, pf_obj_status, pf_mid_status, pf_end_status,
		e.e_id, CONCAT(e.e_employee_id_pre,e.e_employee_id) AS employee_id,
		CONCAT(e.e_first_name," ",e.e_last_name) AS e_name,
		e.e_office_email_id, e.e_working_status,
		CONCAT(sup.e_employee_id_pre,sup.e_employee_id) AS sup_employee_id, 
		CONCAT(sup.e_first_name," ",sup.e_last_name) AS sup_name, 
		sup.e_office_email_id AS sup_office_email_id,
		ae.e_id AS approver_id,
		CONCAT(ae.e_first_name," ",ae.e_last_name) AS approver_name,
		ae.e_office_email_id AS approver_email,
		e.e_supervisor_employee_id
		'); 

		$this->db->join('tbl_employee AS e', 'p.pf_e_id = e.e_id','left');
		$this->db->join('tbl_employee as sup', 'sup.e_id = e.e_supervisor_employee_id','left');
		$this->db->join('tbl_approver as a', 'a.ap_e_id = e.e_id AND a.ap_module_id=4','left');
		$this->db->join('tbl_employee as ae', 'ae.e_id = a.ap_approver_id','left');
		$this->db->from('tbl_pgs_form as p');
		return $this->db->get()->result_array(); 
		//echo "<pre>"; print_r($sel); die; 
	}
	
	
	public function pgs_form_data_cron($where="NULL",$lmt="NULL"){
		if($where!="NULL"){
		$this->db->where($where); 
		}
		if($lmt!="NULL"){
		$this->db->limit($lmt);
		}
		$whr=tamsEmp_where('e');
		$this->db->where($whr);
		//$this->db->where('e.e_delete=0 AND e.e_working_status=1'); 

		$sel=$this->db->select('pf_id, pf_e_id, pf_pa_id, pf_submit_obj, pf_agree_obj, pf_submit_mid_employee, pf_submit_mid_manager, pf_submit_end_employee, pf_submit_end_manager, pf_obj_phase_end_date, pf_mid_yr_phase_end_date,  pf_yr_end_phase_end_date,pf_email_send,pf_close_status, pf_obj_status, pf_mid_status, pf_end_status,
		e.e_id, CONCAT(e.e_employee_id_pre,e.e_employee_id) AS employee_id,
		CONCAT(e.e_first_name," ",e.e_last_name) AS e_name,
		e.e_office_email_id, e.e_working_status,
		CONCAT(sup.e_employee_id_pre,sup.e_employee_id) AS sup_employee_id, 
		CONCAT(sup.e_first_name," ",sup.e_last_name) AS sup_name, 
		sup.e_office_email_id AS sup_office_email_id,
		ae.e_id AS approver_id,
		CONCAT(ae.e_first_name," ",ae.e_last_name) AS approver_name,
		ae.e_office_email_id AS approver_email,
		e.e_supervisor_employee_id
		'); 

		$this->db->join('tbl_employee AS e', 'p.pf_e_id = e.e_id','left');
		$this->db->join('tbl_employee as sup', 'sup.e_id = e.e_supervisor_employee_id','left');
		$this->db->join('tbl_approver as a', 'a.ap_e_id = e.e_id AND a.ap_module_id=4','left');
		$this->db->join('tbl_employee as ae', 'ae.e_id = a.ap_approver_id','left');
		$this->db->from('tbl_pgs_form as p');
		return $this->db->get()->result_array(); 
		//echo "<pre>"; print_r($sel); die; 
	}
	
	/*public function pgs_view_previous_form($where="NULL",$order="NULL"){
		if($where!="NULL"){
		$this->db->where($where); 
		}
		if($order!="NULL"){
		$this->db->order_by($order); 
		}
		$this->db->where($this->hrms_where);
		//$this->db->where('e.e_delete=0 AND e.e_working_status=1'); 
		$sel=$this->db->select('e.e_id AS e_id,
		CONCAT(e.e_employee_id_pre,e.e_employee_id) AS employee_id,
		CONCAT(e.e_first_name," ",e.e_last_name) AS e_name,
		e.e_gender,e.e_contact_no_office,e.e_contact_no_mobile, e.e_office_email_id,
		CONCAT(sup.e_employee_id_pre,sup.e_employee_id) AS e_supervisor_employee_id,
		CONCAT(sup.e_first_name," ",sup.e_last_name) AS e_supervisor_employee_name, 
		d.d_designation AS e_designation,
		e.e_employee_type,e.e_joinning_date,
		p.*,pa.pa_form AS pa_form, 
		pa.pa_id,
		pa.pa_top AS pa_top,
		pa.pa_left AS pa_left,
		pa.pa_right AS pa_right,
		pa.pa_bottom AS pa_bottom,
		pfa.*
		');   
 
		$this->db->join('tbl_employee as e', 'p.pf_e_id = e.e_id','left');
		$this->db->join('tbl_designation as d', 'd.d_id = e.e_designation','left');
		$this->db->join('tbl_employee as sup', 'sup.e_id = e.e_supervisor_employee_id','left');
		$this->db->join('tbl_pgs_template_assign as pa', 'pa.pa_id = p.pf_pa_id','left');
		$this->db->join('tbl_pgs_form_activation as pfa', 'pfa.pfa_id = p.pf_pfa_id','left');
		$this->db->from('tbl_pgs_form AS p');
		$this->db->order_by('e.e_employee_id ASC');
		$qry = $this->db->get()->result_array(); 
		//echo "<pre>"; print_r($sel); die; 
		return $qry;
	}*/
	
	public function pgs_previous_form_ajax($params = array(),$post_data,$type="NULL",$where="NULL"){
		$session_data=$this->session->userdata('loginData');
		$u_e_id=$session_data['e_id'];
		$u_e_type=$session_data['type'];
		if(array_key_exists("start",$params) && array_key_exists("limit",$params)){
            $this->db->limit($params['limit'],$params['start']);
        }elseif(!array_key_exists("start",$params) && array_key_exists("limit",$params)){
            $this->db->limit($params['limit']);
        }
		
		$i=0;
		if($post_data!=""){
		foreach($post_data as $k=>$v){
			
			if($k!='page' && $v!=""){ $i++;
			if($k=='tab'){
				if($v=='MY'){
					$whr_Emp="(e.e_id = '$u_e_id')";
				}elseif($v=='TEAM'){
					//$whr_Emp="(a.ap_approver_id = '$u_e_id')";
					$whr_Emp="(p.pf_manager_id = '$u_e_id')";
				}else{
					$whr_Emp="e.e_id != 0";
				}
				$this->db->where($whr_Emp); 
			}else{
				$this->db->where("$k","$v"); 
			}
			}
		}
		}
		if($where!="NULL"){
		$this->db->where($where); 
		}else{
		if($i==0){ $this->db->where('p.pf_id','0'); }
		}
		$this->db->where('e.e_delete=0');
		//$this->db->where($this->hrms_where);
		$this->db->where('pfa.pfa_obj_phase_end_date!="0000-00-00"'); 
		$sel=$this->db->select('e.e_id AS e_id,
		CONCAT(e.e_employee_id_pre,e.e_employee_id) AS employee_id,
		CONCAT(e.e_first_name," ",e.e_last_name) AS e_name,
		e.e_gender,e.e_contact_no_office,e.e_contact_no_mobile, e.e_office_email_id,
		CONCAT(sup.e_employee_id_pre,sup.e_employee_id) AS e_supervisor_employee_id,
		CONCAT(sup.e_first_name," ",sup.e_last_name) AS e_supervisor_employee_name, 
		d.d_designation AS e_designation,
		e.e_employee_type,e.e_joinning_date,
		p.*,pa.pa_form AS pa_form, 
		pa.pa_id,
		pa.pa_top AS pa_top,
		pa.pa_left AS pa_left,
		pa.pa_right AS pa_right,
		pa.pa_bottom AS pa_bottom,
		pa.pa_active_status,
		pfa.*,
		(select w1.w_status from tbl_working_status as w1 where w1.w_id=p.pf_e_working_status) AS pf_w_status
		');     
 
		$this->db->join('tbl_employee as e', 'p.pf_e_id = e.e_id','left');
		$this->db->join('tbl_designation as d', 'd.d_id = e.e_designation','left');
		$this->db->join('tbl_employee as sup', 'sup.e_id = e.e_supervisor_employee_id','left');
		$this->db->join('tbl_pgs_template_assign as pa', 'pa.pa_id = p.pf_pa_id','left');
		$this->db->join('tbl_pgs_form_activation as pfa', 'pfa.pfa_id = p.pf_pfa_id','left');
		$this->db->from('tbl_pgs_form AS p');
		//$this->db->order_by('e.e_employee_id ASC');
		$this->db->order_by('p.pf_id ASC');
		$qrys = $this->db->get(); 
		if($type=='count'){ $qry = $qrys->num_rows(); }else{ $qry = $qrys->result_array(); }
		//echo "<pre>"; print_r($sel); die; 
		return $qry;
	}
	
	// USE IN assign_template_ajax()
	public function pgs_template_emp_list($where="NULL",$order=""){
		if($where!="NULL"){
		$this->db->where($where); 
		}
		if($order!="NULL"){
		$this->db->order_by($order); 
		}
		//$this->db->where('(e.e_delete=0 AND e.e_working_status=1)'); 
		$this->db->where($this->hrms_where);
		$sel=$this->db->select('e.e_id,
		CONCAT(e.e_employee_id_pre,e.e_employee_id) AS employee_id,
		CONCAT(e.e_first_name," ",e.e_last_name) AS e_name,
		e.e_supervisor_employee_id,
		e.e_office_email_id,
		pa.*
		',false);  
		 
		$this->db->join('tbl_pgs_template_assign as pa', 'pa.pa_e_id = e.e_id AND pa.pa_id = (select max(pa_id) from tbl_pgs_template_assign as pa2 where pa2.pa_e_id = pa.pa_e_id)','left');
		$this->db->from('tbl_employee AS e');
		$this->db->order_by('e.e_employee_id ASC');
		$qry = $this->db->get()->result_array(); 
		//echo "<pre>"; print_r($sel); echo "</pre>"; die;
		return $qry;
	}
	
	//--- use in tab_assign_template()
	public function pgs_template_emp_assign($where="NULL",$order=""){
		if($where!="NULL"){
		$this->db->where($where); 
		}
		if($order!="NULL"){
		$this->db->order_by($order); 
		}

		$this->db->where($this->hrms_where); 

		$sel=$this->db->select('e.e_id,
		CONCAT(e.e_employee_id_pre,e.e_employee_id) AS employee_id,
		CONCAT(e.e_first_name," ",e.e_last_name) AS e_name,
		e.e_supervisor_employee_id, e.e_working_status,
		e.e_office_email_id,e.e_joinning_date,
		pa.*, t.pt_id, t.pt_name,
		a.ap_approver_id
		',false);  
		
		$this->db->join('tbl_pgs_template_assign as pa', 'pa.pa_e_id = e.e_id AND pa.pa_id = (select max(pa_id) from tbl_pgs_template_assign as pa2 where pa2.pa_e_id = pa.pa_e_id)','left');
		$this->db->join('tbl_pgs_template as t', 'pa.pa_pt_id = t.pt_id','left'); 
		$this->db->join('tbl_approver as a', 'a.ap_e_id = e.e_id AND a.ap_module_id=4','left');
		//$this->db->join('tbl_employee as ae', 'ae.e_id = a.ap_approver_id','left');
		
		$this->db->from('tbl_employee AS e');
		$this->db->order_by('e.e_employee_id ASC');
		$qry = $this->db->get()->result_array(); 
		//echo "<pre>"; print_r($sel); echo "</pre>"; die;
		return $qry;
	}
	
	//----- NEW EMPLOYEE CREATE IN HRMS ----------
	public function new_employee_pgs($id){

	$current_date = date('Y-m-d');
	$whr = "( pfa_period_end_date >= '$current_date')";
	$appDatas=$this->model->sortingWheredata("*","tbl_pgs_form_activation",$whr,'pfa_id DESC');
	//echo "<pre>"; print_r($appDatas); echo "</pre>"; 
		if(count($appDatas) > 0){ 
		$pfa_id = $appDatas[0]["pfa_id"]; 
		//$pfa_obj_phase_end_date=$appDatas[0]['pfa_obj_phase_end_date'];
			if($pfa_id != 0 ){
				$tams_where = tamsEmp_where(); 
				$whr_emp = "e_id = $id AND $tams_where";
				$empData=$this->model->sortingWheredata("*,(SELECT a.ap_approver_id FROM tbl_approver as a WHERE a.ap_e_id=tbl_employee.e_id AND a.ap_module_id=4) AS mgr_id","tbl_employee",$whr_emp,'e_id ASC');
				if(count($empData) > 0){
					//if($empData[0]['e_working_status']==1 || $empData[0]['e_working_status']==6){
						$e_joinning_date = date('Y-m-d', strtotime($empData[0]['e_joinning_date']));
						$pfa_start_date = $appDatas[0]['pfa_start_date'];
						$last_day_reg= date('Y-m-t', strtotime("+6 months", strtotime($pfa_start_date)));
						if($e_joinning_date <= $last_day_reg){
						$pfa_obj_phase_end_date = $appDatas[0]['pfa_obj_phase_end_date'];
						if($e_joinning_date > $pfa_obj_phase_end_date){ $pfa_obj_phase_end_date = "0000-00-00"; }
						$pfa_mid_yr_phase_end_date = $appDatas[0]['pfa_mid_yr_phase_end_date'];
						if($e_joinning_date > $pfa_mid_yr_phase_end_date){ $pfa_mid_yr_phase_end_date = "0000-00-00"; }
						$pfa_yr_end_phase_end_date = $appDatas[0]['pfa_yr_end_phase_end_date'];
						if($e_joinning_date > $pfa_yr_end_phase_end_date){ $pfa_yr_end_phase_end_date = "0000-00-00"; }
						if($pfa_obj_phase_end_date < date('Y-m-d')){
							$pfa_obj_phase_end_date="0000-00-00";
						}							
						if($pfa_mid_yr_phase_end_date < date('Y-m-d')){
							$pfa_mid_yr_phase_end_date="0000-00-00";
						}							
						if($pfa_yr_end_phase_end_date < date('Y-m-d')){
							$pfa_yr_end_phase_end_date="0000-00-00";
						}							
						$insdata=array(
						'pf_pfa_id' => $pfa_id, 
						'pf_e_id'=> $id,
						'pf_phase'=>'Objective Setting',
						'pf_obj_phase_end_date'=> $pfa_obj_phase_end_date,
						'pf_mid_yr_phase_end_date'=> $pfa_mid_yr_phase_end_date,
						'pf_yr_end_phase_end_date'=> $pfa_yr_end_phase_end_date,
						'pf_manager_id'=>$empData[0]['mgr_id'], 
						'pf_e_working_status'=>$empData[0]['e_working_status'],
						);   
						$this->model->insertData("tbl_pgs_form",$insdata); 
						$e_name=$empData[0]['e_first_name']." ".$empData[0]['e_last_name']; 
						$e_office_email_id=$empData[0]['e_office_email_id'];
						if($e_office_email_id !=""){
							$email_msg ='';
							$email_msg .= "
							<p>Dear $e_name,</p>
							<p>It's time of the year when we set individual objectives for all, which we call as the Goal Setting Phase, followed by the Mid-Year Review & the Year End Review.</p>
							<p>Thus, our Performance Management System comprises of 3 Phases.</p>
							Phase 1 - Goal Setting <br/>
							Phase 2 - Mid Year Review <br/>
							Phase 3 - Year End Review <br/>
							<p>We are in the Phase 1, where you need to know the specific objectives set for you in this year.</p>";
							if($pfa_obj_phase_end_date != "0000-00-00"){
							$email_msg .="<p>The Deadline provided to accept the objective is <strong style='border-bottom: 1px dotted #0f548b;'> ".date('d-M-Y',strtotime($pfa_obj_phase_end_date))."</span>.</p>"; }
							 
							$email_msg .="<br/> 
							<p>Regards,<br/>
							PGS Team</p>
							";
							$subject='Appraisal cycle (Phase 1 - Objective Setting is started)'; 
							$this->model->emailSendFormat($e_office_email_id, $subject, $email_msg, 'NULL','NULL'); 
						}
						}
				//}
				}  
			}
		} 

	} // END :new_employee_pgs
	
	public function pgs_employee_details($where="NULL"){
		 	
		if($where!="NULL"){
		$this->db->where($where); 
		}
		
		$this->db->where($this->hrms_where);
		//$this->db->where('e.e_delete=0 AND e.e_working_status=1'); 
		$sel=$this->db->select('e.e_id AS e_id,
		CONCAT(e.e_employee_id_pre,e.e_employee_id) AS employee_id,
		CONCAT(e.e_first_name," ",e.e_last_name) AS e_name,
		e.e_gender,e.e_contact_no_office,e.e_contact_no_mobile, e.e_office_email_id,
		CONCAT(sup.e_employee_id_pre,sup.e_employee_id) AS e_supervisor_employee_id,
		CONCAT(sup.e_first_name," ",sup.e_last_name) AS e_supervisor_employee_name, 
		d.d_designation AS e_designation,
		e.e_employee_type,e.e_joinning_date,
		a.ap_approver_id
		');    
 
		
		$this->db->join('tbl_designation as d', 'd.d_id = e.e_designation','left');
		$this->db->join('tbl_employee as sup', 'sup.e_id = e.e_supervisor_employee_id','left');
		$this->db->join('tbl_approver as a', 'a.ap_e_id = e.e_id AND a.ap_module_id=4','left');
		$this->db->from('tbl_employee AS e');
		$this->db->order_by('e.e_employee_id ASC');
		$qry = $this->db->get()->result_array();; 
		//echo "<pre>"; print_r($sel); die; 
		return $qry;
	}
	
	//---- PGS : CRON EMAIL -----
	
	public function phase_start_email(){
		$current_year_id = $this->pgs->ckeckYear();
		$phaseData=$this->pgs->pgs_form_data(array('pf_pfa_id'=>$current_year_id,'pf_email_send !='=>''),'5');
		
		 
		foreach($phaseData As $k){
			$pf_id=$k['pf_id'];
			$e_id=$k['e_id'];
			$e_name=$k['e_name'];
			$e_office_email_id=$k['e_office_email_id'];
			$pf_email_send=$k['pf_email_send'];
			$pf_obj_phase_end_date= $k['pf_obj_phase_end_date']!='0000-00-00' ? date('d-M-Y',strtotime($k['pf_obj_phase_end_date'])) : '0000-00-00';
			$pf_mid_yr_phase_end_date=$k['pf_mid_yr_phase_end_date']!='0000-00-00' ? date('d-M-Y',strtotime($k['pf_mid_yr_phase_end_date'])) : '0000-00-00';
			$pf_yr_end_phase_end_date=$k['pf_yr_end_phase_end_date']!='0000-00-00' ? date('d-M-Y',strtotime($k['pf_yr_end_phase_end_date'])) : '0000-00-00';
			$link_email=base_url()."PGS/pgs_email_link";
			$title=""; $subject='Appraisal cycle deadline';
			$e_working_status=$k['e_working_status'];
			if($e_working_status!=7){
			//---- PHASE 1 --------
			if($pf_email_send=='NEW' AND $pf_obj_phase_end_date!="0000-00-00"){
				$subject='Appraisal cycle (Phase 1 - Objective Setting is started)';
				$title="<p>It's time of the year when we set individual objectives for all, which we call as the Goal Setting Phase, followed by the Mid-Year Review & the Year End Review.</p>
				<p>Thus, our Performance Management System comprises of 3 Phases.</p>
				Phase 1 - Goal Setting <br/>
				Phase 2 - Mid Year Review <br/>
				Phase 3 - Year End Review <br/>
				<p>We are in the Phase 1, where you need to know the specific objectives set for you in this year.</p>
				 
				<p>The Deadline provided to accept the objective is <strong style='border-bottom: 1px dotted #0f548b;'> $pf_obj_phase_end_date</span>.</p> ";
			}
			//---- DATE EXTENDED EMAIL ---
			if($pf_email_send=='P1' AND $pf_obj_phase_end_date!="0000-00-00"){
				/*$subject='Appraisal cycle (Phase 1 - Objective Setting is started)';
				$title="<p>It's time of the year when we set individual objectives for all, which we call as the Goal Setting Phase, followed by the Mid-Year Review & the Year End Review.</p>
				<p>Thus, our Performance Management System comprises of 3 Phases.</p>
				Phase 1 - Goal Setting <br/>
				Phase 2 - Mid Year Review <br/>
				Phase 3 - Year End Review <br/>
				<p>We are in the Phase 1, where you need to know the specific objectives set for you in this year.</p>
				<p>The Deadline provided to accept the objective is <strong style='border-bottom: 1px dotted #0f548b;'> $pf_obj_phase_end_date</span>.</p> ";*/ 
				$subject='Phase - 1 Objective Setting (Extended Deadline)';
				$title="<p>We have extended the deadline to $pf_obj_phase_end_date to accept the objective set for you.</p>
				<p>Please click on below link to goal review page.</p>
				<p><a href='$link_email/my_pgms/Self_Appraisal/$pf_id/$e_id'  style='background:#0f548b;padding:5px 8px;color:#fff;text-decoration:none' target='_blank'>Appraisal Form</a></p>
				<p>If you fail to complete the task within extended date, then it will be considered as accepted by default.</p>"; 
			}
			
			//---- PHASE 2 --------
			if($pf_email_send=='P2' AND $pf_mid_yr_phase_end_date!="0000-00-00"){
				$subject='Appraisal cycle (Phase 2 - Mid Year Review is started)';
				//$title="<p>Phase 2 : Mid-Year Review Deadline is <strong style='border-bottom: 1px dotted #0f548b;'> $pf_mid_yr_phase_end_date</span>.</p> ";
				$title="<p>We have completed Phase 1 - Goal Setting, now we are in Phase 2- Mid Year Review.</p>
				<p>This is to inform you that, we have enabled Appraisal Form for you to fill Self comments under Mid-Year Phase column.</p>
				<p>Kindly complete this task before <strong style='border-bottom: 1px dotted #0f548b;'> $pf_mid_yr_phase_end_date</span>.</p>
				<p>For any clarification, please feel free to drop you queries to us.</p>";
			}
			
			if($pf_email_send=='PE2' AND $pf_mid_yr_phase_end_date!="0000-00-00"){
				$subject='Phase - 2 Mid-Year Review (Extended Deadline)';
				//$title="<p>Phase 2 : Mid-Year Review Deadline is <strong style='border-bottom: 1px dotted #0f548b;'> $pf_mid_yr_phase_end_date</span>.</p> ";
				$title="<p>We have extended the deadline to $pf_mid_yr_phase_end_date for you to fill Self comments under Mid-Year Phase column.</p>
				<p>Kindly click on below link to put your valuable comments. </p>
				<p><a href='$link_email/my_pgms/Self_Appraisal/$pf_id/$e_id/page_2'  style='background:#0f548b;padding:5px 8px;color:#fff;text-decoration:none' target='_blank'>Appraisal Form</a></p>
				<p>If you fail to complete the task within extended date, then it will be considered as accepted by default.</p>
				";
			}
			
			//---- PHASE 3 --------
			if($pf_email_send=='P3' AND $pf_yr_end_phase_end_date!="0000-00-00"){
				//$title="<p>Phase 3 : Final-Year Review Deadline is <strong style='border-bottom: 1px dotted #0f548b;'> $pf_yr_end_phase_end_date</span>.</p> ";
				$subject='Appraisal cycle (Phase 3 - Year End Review is started)';
				$title = "<p>We are in the Phase 3 (last phase) which is the Final review of your performance for this Year.</p>
				<p>This is to inform you that, we have enabled Appraisal Form for you to fill Self comments under Final-Year Phase column.</p>
				<p>Kindly complete this task before <strong style='border-bottom: 1px dotted #0f548b;'> $pf_yr_end_phase_end_date</span>.</p>
				<p>For any clarification, please feel free to drop you queries to us.</p>";
			}
			if($pf_email_send=='PE3' AND $pf_yr_end_phase_end_date!="0000-00-00"){
				//$title="<p>Phase 3 : Final-Year Review Deadline is <strong style='border-bottom: 1px dotted #0f548b;'> $pf_yr_end_phase_end_date</span>.</p> ";
				$subject='Phase - 3 Final-Year Review (Extended Deadline)';
				$title = "<p>We have extended the deadline to $pf_yr_end_phase_end_date for you to fill Self comments under Final-Year Phase column.</p>
				<p>Kindly click on below link to put your valuable comments. </p>
				<p><a href='$link_email/my_pgms/Self_Appraisal/$pf_id/$e_id'  style='background:#0f548b;padding:5px 8px;color:#fff;text-decoration:none' target='_blank'>Appraisal Form</a></p>
				<p>If you fail to complete the task within extended date, then it will be considered as accepted by default.</p>"; 
			}
			if($title!=""){
			 $email_msg = "
			<p>Dear $e_name,</p>
			$title
			<br/>
			<p>Regards,<br/>
			PGS Team</p>
			";
			
			$this->model->emailSendFormat($e_office_email_id, $subject, $email_msg, 'NULL','NULL'); 
			$this->model->UpdateData("tbl_pgs_form",array('pf_email_send'=>''),array('pf_id'=>$pf_id)); 
			}
			}else{
				$this->model->UpdateData("tbl_pgs_form",array('pf_email_send'=>''),array('pf_id'=>$pf_id)); 
			}
		}
		
	} // END : phase_start_email
	
	
	public function pgs_template_form($where="NULL",$order=""){
		if($where!="NULL"){
		$this->db->where($where); 
		}
		if($order!="NULL"){
		$this->db->order_by($order); 
		}
		//$this->db->where('(e.e_delete=0 AND e.e_working_status=1)'); 
		$this->db->where($this->hrms_where);
		$sel=$this->db->select('e.e_id,
		CONCAT(e.e_employee_id_pre,e.e_employee_id) AS employee_id,
		CONCAT(e.e_first_name," ",e.e_last_name) AS e_name, 
		e.e_gender,e.e_contact_no_office,e.e_contact_no_mobile, e.e_office_email_id,
		CONCAT(sup.e_employee_id_pre,sup.e_employee_id) AS e_supervisor_employee_id,
		CONCAT(sup.e_first_name," ",sup.e_last_name) AS e_supervisor_employee_name, 
		d.d_designation AS e_designation,
		e.e_employee_type,e.e_joinning_date,
		pa.*
		',false);  
		 
		$this->db->join('tbl_pgs_template_assign as pa', 'pa.pa_e_id = e.e_id AND pa.pa_id = (select max(pa_id) from tbl_pgs_template_assign as pa2 where pa2.pa_e_id = pa.pa_e_id)','left');
		$this->db->join('tbl_designation as d', 'd.d_id = e.e_designation','left');
		$this->db->join('tbl_employee as sup', 'sup.e_id = e.e_supervisor_employee_id','left');
		$this->db->from('tbl_employee AS e');
		$this->db->order_by('e.e_employee_id ASC');
		$qry = $this->db->get()->result_array(); 
		//echo "<pre>"; print_r($sel); echo "</pre>"; die;
		return $qry;
	}
	
	public function check_manager($emp_id,$mgr_id){
		$current_year_id = $this->ckeckYear();
		$pgsData=$this->model->sortingWheredata("pf_id","tbl_pgs_form",array("pf_e_id"=>$emp_id,'pf_submit_end_manager!='=>'YES', 'pf_manager_id!='=>$mgr_id,'pf_pfa_id'=>$current_year_id)); 
		$ins_arr=""; 
		//echo "<pre>"; print_r($pgsData); echo "</pre>";
		if(count($pgsData) >0){
			$this->model->UpdateData("tbl_pgs_form",array('pf_manager_id'=>$mgr_id),array('pf_id'=>$pgsData[0]['pf_id'],'pf_pfa_id'=>$current_year_id)); //
			echo $aff_row =$this->db->affected_rows();
			if($aff_row > 0){
			$ins_arr="<br/>Manager has been changed in PGMS"; 
			}
		} 
		return $ins_arr; 
	}
   
	public function check_employee_status($emp_id,$status){

		$current_year_id = $this->ckeckYear();
		//echo $emp_id."---".$status; 
		$pgsData=$this->model->sortingWheredata("pf_id","tbl_pgs_form",array("pf_e_id"=>$emp_id,'pf_submit_end_manager!='=>'YES', 'pf_e_working_status!='=>$status,'pf_pfa_id'=>$current_year_id)); 
		$ins_arr=""; 
		//echo "<pre>"; print_r($pgsData); echo "</pre>"; die;
		if(count($pgsData) >0){ 
			$this->model->UpdateData("tbl_pgs_form",array('pf_e_working_status'=>$status),array('pf_id'=>$pgsData[0]['pf_id'],'pf_pfa_id'=>$current_year_id)); //,'pf_pfa_id'=>$current_year_id
			echo $aff_row =$this->db->affected_rows();
			if($aff_row > 0){
			$ins_arr="<br/>Working status has been changed in PGMS"; 
			}
		}  
		return $ins_arr; 
	}
	
	public function Add_app_form($pfa_id,$pfa_obj_phase_end_date,$last_day_reg){
		$hrms_emp_whr = tamsEmp_where('e');
		$ins_query= "INSERT INTO tbl_pgs_form
		(
			pf_pfa_id, pf_pa_id, pf_e_id, pf_obj_phase_end_date,pf_phase,pf_email_send,`pf_objective_category`,`pf_measurement_criteria`, pf_form_fields,pf_manager_id,pf_e_working_status
		) 
		(
			SELECT '$pfa_id',pa_id, e.e_id, '$pfa_obj_phase_end_date','Objective Setting','NEW',`pa_objective_category`,`pa_measurement_criteria`,pa_left,(SELECT a.ap_approver_id FROM tbl_approver as a WHERE a.ap_e_id=e.e_id AND a.ap_module_id=4),e.e_working_status
			FROM `tbl_employee` AS `e`
			LEFT JOIN `tbl_pgs_template_assign` as `pa` ON `pa`.`pa_e_id` = `e`.`e_id` AND `pa`.`pa_id` = (select max(pa_id) from tbl_pgs_template_assign as pa2 where pa2.pa_e_id = pa.pa_e_id)
			WHERE $hrms_emp_whr AND UPPER(e.e_employee_type)='PERMANENT' AND e.e_joinning_date <=  '$last_day_reg' AND (SELECT count(pf_id) from tbl_pgs_form where pf_e_id = e.e_id AND pf_pfa_id = $pfa_id LIMIT 1) = 0
			AND (pa.pa_active_status!='N' && pa.pa_active_status!='') ORDER BY `e`.`e_employee_id` ASC
		)";
		$this->db->query($ins_query);
	}
	
	public function pgs_emp_list($where="NULL",$order="NULL"){
		//print_r($where);
		if($where!="NULL"){
		$this->db->where($where); 
		}
		if($order!="NULL"){
		$this->db->order_by($order); 
		}
		 
		//$this->db->where($this->hrms_where);
		$this->db->where('(e.e_delete=0)'); 
		$sel=$this->db->select('e.e_id,
		CONCAT(e.e_employee_id_pre,e.e_employee_id) AS employee_id,
		CONCAT(e.e_first_name," ",e.e_last_name) AS e_name',false);   
		$this->db->join('tbl_pgs_form as p', 'p.pf_e_id = e.e_id','left');
		$this->db->from('tbl_employee AS e');
		$this->db->order_by('e.e_employee_id ASC');
		$this->db->group_by('e.e_id');
		$qry = $this->db->get()->result_array(); 
		//echo "<pre>"; print_r($sel); echo "</pre>"; die;
		return $qry; 
	}
	
	
	public function pgs_manager_list($where="NULL",$order="NULL"){ 
		//print_r($where);
		if($where!="NULL"){
		$this->db->where($where); 
		}
		if($order!="NULL"){
		$this->db->order_by($order); 
		}
		 
		//$this->db->where($this->hrms_where);
		$this->db->where('(e.e_delete=0)'); 
		$sel=$this->db->select('e.e_id,
		CONCAT(e.e_employee_id_pre,e.e_employee_id) AS employee_id,
		CONCAT(e.e_first_name," ",e.e_last_name) AS e_name, e.e_office_email_id',false);   
		$this->db->join('tbl_employee as e', 'p.pf_manager_id = e.e_id','left');
		$this->db->from('tbl_pgs_form AS p');
		$this->db->group_by('p.pf_manager_id');
		$qry = $this->db->get()->result_array(); 
		//echo "<pre>"; print_r($sel); echo "</pre>"; die;
		return $qry; 
	}
}
 