<?php ob_start();
defined("BASEPATH") OR exit("No direct script access allowed");
use PhpOffice\PhpSpreadsheet\Spreadsheet;
use PhpOffice\PhpSpreadsheet\Writer\Xlsx;
use PhpOffice\PhpSpreadsheet\Reader\Csv;
class Timesheet_report extends CI_Controller {
	function __construct(){
		parent:: __construct();
		$this->load->model("alldata","model");
		$this->load->model("hr_model","hr");
		$this->load->model("timesheet_model","ts");
		
		$this->load->helper('hrms_helper'); 
	}

	public function NonBillable_report(){
		$data["hcData"]=$this->model->DetailDatahc(array("h.hc_id"=>158));
		$this->session->unset_userdata('post_data');
		$whr="e.e_delete=0 AND e.e_id IN (SELECT t_e_id FROM tbl_timesheet)";
		$data["empallData"]=$this->hr->employee_details($whr);
		$data["view"]="report/timesheet/nonbillable_report";
		$this->load->view("layout",$data);
	}
	public function NonBillable_report_search($pg=''){
	//echo "<pre>"; print_r($_POST); echo "</pre>";
	$session_data=$this->session->userdata('loginData');
	if(isset($session_data) AND $session_data!=""){ 
		$data['post_data']=$_POST;
		$e_id = $this->input->post('e_id');
		$month = $this->input->post('month');
		$year = $this->input->post('year');
	

	$where='';
	$where.="td.td_type='Non-Billable' AND UPPER(ta.ta_name)!='WEEKLY OFF' AND td.td_working_hrs!='0.00' AND t.t_year='$year'";
	$rpt_file_name  = "";
	$rpt_file_name .="Non-Billable_Timesheet"; $month_div='';
	if($month!="" AND $month!="All"){ $month_div.='M';
		$rpt_file_name .="_".date('M-Y',strtotime("01-$month-$year"));
		$where.=" AND t.t_month='$month'";
	}
	if($e_id!=""){ $month_div.='E';
		$where.=" AND t.t_e_id='$e_id'";
		$empData=$this->model->LimitWheredata('CONCAT(e_first_name," ",e_last_name) AS e_name','tbl_employee',array('e_id'=>$e_id),'e_name ASC',1);
		$rpemp_nm=$empData[0]['e_name'];
		$rpt_file_name .="_".$empData[0]['e_name'];
	}
	$report_title=""; $report_title.="Non Billable Report For ";
	if($month_div=='E' || $month_div=='ME'){ $report_title.="$rpemp_nm"; }
	if($month_div=='M' || $month_div=='ME'){ if($month_div=='E' || $month_div=='ME'){ $report_title .=' ('; } $report_title .=date('F-Y',strtotime("01-$month-$year")); if($month_div=='E' || $month_div=='ME'){ $report_title .=')'; } }else{ $report_title.=" (Year-$year)";} 
	
	$tmData=$this->ts->non_billable_fun($where);
	foreach($tmData AS $i=>$k){
		$e_name = $k['employee_id']." - ".$k['e_name'];
		$t_month = $k['t_month'];
		$where_arr = array( 
		'ta_name'=> $k['ta_name'],
		'ttl_wrk'=> $k['ttl_wrk']
		);
		$reportData[$e_name][$t_month][]=$where_arr;
	}
	//echo "<pre>";print_r($reportData);echo "</pre>";die; 
	
	$result = ''; $array_excel=[];
	if(Count($tmData) <= 0){
		echo "NODATA";
		//$result =  '<div class="text-danger text-center font-600">No data available.</div>';
	}else{
		
		$result .= "<style>
		.table-sm td, .table-sm th {
    padding: 1px 5px;
    font-size: 12px;
    border-left: 1px solid #636060;
    border-right: 1px solid #636060;
    border-bottom: 1px solid #636060;
}
.table-sm{border: 1px solid #636060;}
tr .btm-brd{ border-bottom: none !important; }
.brd-top td, .brd-top th{border-top: 1px solid gray !important;}
</style>";
		if($pg =='email'){
		$result .= "<table class='table-sm' border='1'   cellspacing='0' style='min-width:50%'>";
		}else{
		$result .= "<table class='table-sm'    cellspacing='0' style='min-width:50%'>";	
		}
		$result .="<tr style='background-color: #90c2f9;'><th colspan='3' style='text-align:center;font-size: 15px;'>$report_title </th></tr>"; 
		$array_excel['title'][]=$report_title;
		$sum1=0;
		
		$clm="<td class='btm-brd'></td>";
					if($month_div=='ME'){
						$clm='';
					}

		$tbl_head=''; $tbl_head_arr=[]; 
		$tbl_head .="<tr style='background: #cee0f5;border-top: 1px solid gray;'>";
			if($month_div=='E'){ $tbl_head .="<th>Month</th>"; $tbl_head_arr[]="Month";
			}elseif($month_div=='M'){ $tbl_head .="<th>Employee</th>"; $tbl_head_arr[]="Employee";}
			$tbl_head .="<th>Non-Billable Activity</th><th>Hrs.</th></tr>";
			$tbl_head_arr[]="Non-Billable Activity"; $tbl_head_arr[]="Hrs.";
		$n=0;
		foreach($reportData as $emp=>$t_month){ $n++;
			/*if($month_div=='E'){ $result .="<tr style='background-color: #90c2f9;'><th colspan='3' style='text-align:center;font-size: 15px;'>Non Billable Report For $emp</th></tr>";
			$array_excel['title'][]="Non Billable Report For $emp";
			}*/
			if($n==1 && $month_div!='ME'){
				$result .=$tbl_head;
				$array_excel['tbl_head']=$tbl_head_arr;
			}
			if($month_div=='M'){ 
				 $result .="<tr style='background-color: #FFEEBA;' class='brd-top'><th style='text-align:left;'> $emp</th><th colspan='2'></th></tr>";
				 $array_excel[]=array($emp,"bg_color"=>"FFEEBA");
			}
			$sum2=0; $s=0;
			foreach($t_month as $month1=>$arr){
				if($month_div=='E'){ $result .="<tr style='background-color: #ffeeba;' class='brd-top'><th style='text-align:left;'>".date('F-Y',strtotime("01-$month1-$year"))."</th><th colspan='2'></th></tr>"; 
					$array_excel[]=array(date('F-Y',strtotime("01-$month1-$year")),"bg_color"=>"FFEEBA");
				}
				/*if($month_div=='ME'){ $result .="<tr style='background-color: #90c2f9;'><th colspan='2' style='text-align:center;font-size: 15px;'>Non Billable Report For $emp (".date('F-Y',strtotime("01-$month1-$year")).")</th></tr>"; 
				$array_excel['title'][]="Non Billable Report For $emp (".date('F-Y',strtotime("01-$month1-$year")).")";
				}*/
				$sum3=0;
				if($month_div=='ME'){ $result.= "<tr style='background: #cee0f5;' class='brd-top'>$clm<th>Non-Billable Activity</th><th>Hrs</th></tr>";
				$array_excel['tbl_head']=array("Non-Billable Activity",'Hrs');
				
				}
				foreach($arr AS $i3=>$k3){ $s++;
					if($month_div=='ME'){
					$array_excel[]=array($k3['ta_name'],$k3['ttl_wrk']);
					}else{
					$array_excel[]=array("",$k3['ta_name'],$k3['ttl_wrk']);
					}
					$result.= "<tr>$clm<td>".$k3['ta_name']."</td><td>".$k3['ttl_wrk']."</td></tr>";
					$sum3+=$k3['ttl_wrk']; $sum2+=$k3['ttl_wrk']; $sum1+=$k3['ttl_wrk'];
					}
					if(count($t_month) > 1 && count($arr) > 1){
					$result.= "<tr>$clm<th style='text-align:right;'>TOTAL</td><th>$sum3</th></tr>";
					
					if($month_div=='ME'){
					$array_excel[]=array('TOTAL',$sum3);
					}else{
					$array_excel[]=array("",'TOTAL',$sum3);
					}
					}
			}
			if($s >1){
				
				if($e_id!=""){ 
					if($month!="All" AND $month!=""){ 
						$result.= "<tr>$clm<th style='text-align:right;'>TOTAL"; 
						$ttl_1=array('TOTAL',$sum2);
					}else{ 
						$result.= "<tr style='background-color:#f5c6cb;' class='brd-top'>$clm<th style='text-align:right;'>GRAND TOTAL";
						$ttl_1=array('GRAND TOTAL',$sum2,'bg_color'=>'f5c6cb');						
					} 
				}else{
					$result.= "<tr>$clm<th style='text-align:right;'>TOTAL";  
					$ttl_1=array('TOTAL',$sum2);	
				}
				$result.= "</td><th>$sum2</th></tr>";
				if($month_div=='ME'){
					$array_excel[]=$ttl_1;
					}else{
					$array_excel[]=array_merge(array(""),$ttl_1);
					}
			//$result.= "<tr style='background-color:#d4e4f7;'><th>TOTAL</td><th>$sum2</th></tr>";
			}
		}
		if($sum2!=$sum1){
		$result.= "<tr style='background-color: #f5c6cb;' class='brd-top'>$clm<th style='text-align:right;'>GRAND TOTAL</td><th>$sum1</th></tr>";
		$array_excel[]=array("",'GRAND TOTAL',$sum1,'bg_color'=>'f5c6cb');	
		}
		$result .="</table><input type='hidden' name='rpt_file_name' value='$rpt_file_name'/>";		
	
	if($pg=="search"){
		 	 
		echo $result;
	} 
	$email_format=0;
	
	if($pg=='email'){
		$email_format = $this->input->post("email_format");
	  	$email_to = $this->input->post("email_to");
	  	$email_sub = $this->input->post("email_sub");
	  	$email_desc = $this->input->post("email_desc");
		
	  	if($email_format ==1){	 
   			$email_msg=$email_desc."<br/>".$result; 
   			$this->model->emailSendFormat($email_to, $email_sub, $email_msg);
   		} 
		
	}

	if($pg=='pdf' || ($pg=='email' AND $email_format ==2)){
		
		include_once APPPATH . '/third_party/vendor/autoload.php';
		$pdf = new \Mpdf\Mpdf();
		$pdf->AddPage('P','', '', '', '', 5,5,5,5,5,5);
		$pdf->WriteHTML($result);
		$folder_name = date("Y");
		if (!file_exists(FCPATH . "assets/report_pdf/".$folder_name)) {
		$pdfFilePath1 = mkdir(FCPATH . "assets/report_pdf/".$folder_name, 0755, true);
		}
		$PDFname=$rpt_file_name.date("_d_m_Y_h_i_s").".pdf";
		$path_pdf =  'assets/report_pdf/'.$folder_name.'/';
		$pdf->Output(FCPATH.$path_pdf.$PDFname,'F');
		if($pg=='email'){
			$attchmt_file = $PDFname;
			$attchmt_path = $path_pdf;
			$this->model->emailSendFormat($email_to, $email_sub, $email_desc,$regard='NULL',$topmenu='not',$from="NULL",$cc=array(),$attchmt_file,$attchmt_path);
		}else{
			echo ''.base_url().$path_pdf.$PDFname; 
		} 
	}
	if(($pg=='excel' || $pg=='csv') || ($pg=='email' AND ($email_format ==3 || $email_format ==4))){
		$file_name = $rpt_file_name; 
		$folder_name = date("Y");
		if (!file_exists(FCPATH . "assets/report_excel/".$folder_name)) {
		$pdfFilePath1 = mkdir(FCPATH . "assets/report_excel/".$folder_name, 0755, true);
		}
		$path_excel =  'assets/report_excel/'.$folder_name.'/';
		$attchmt_path = $path_excel;
		require 'vendor/autoload.php';
		$spreadsheet = new Spreadsheet();
		$sheet = $spreadsheet->getActiveSheet();
		$row_no=0; $cell_mrg=[];
		$sheet->getColumnDimension('A')->setAutoSize(true);
		$sheet->getColumnDimension('B')->setAutoSize(true);
		$sheet->getColumnDimension('C')->setAutoSize(true);
		
		
		
			foreach($array_excel AS $cell_hd=>$arr_cell){
				$row_no++; $cell_no=0;
				$endCell = $this->model->Arr_cell($row_no,(count($array_excel['tbl_head'])-1)); 
				$border_type=0;
				//echo "<br/>-----------------------------------------------------------<br/>";
				foreach($arr_cell AS $ex_head=>$cell_val){ 
				$cellName = $this->model->Arr_cell($row_no,$cell_no);
				//echo "$cellName | $cell_val";
				if($cell_val==='TOTAL' || $cell_val==='GRAND TOTAL'){ $border_type++;
					$spreadsheet->getActiveSheet()->getStyle("A$row_no:$endCell")->getFont()->setBold(true);
						//$spreadsheet->getActiveSheet()->getStyle("A$row_no:$endCell")->getBorders()->getBottom()->applyFromArray( array( 'borderStyle' => PhpOffice\PhpSpreadsheet\Style\Border::BORDER_THIN, 'color' => array( 'rgb' => '808080')));	
					if($cell_val==='GRAND TOTAL'){
						//$spreadsheet->getActiveSheet()->getStyle("A$row_no:$endCell")->getBorders()->getTop()->applyFromArray( array( 'borderStyle' => PhpOffice\PhpSpreadsheet\Style\Border::BORDER_THIN, 'color' => array( 'rgb' => '808080')));
					}
				}
				if($ex_head==='bg_color'){ $border_type++;
					$spreadsheet->getActiveSheet()->getStyle("A$row_no:$endCell")->getFill()->setFillType(\PhpOffice\PhpSpreadsheet\Style\Fill::FILL_SOLID)->getStartColor()->setARGB($cell_val);
					$spreadsheet->getActiveSheet()->getStyle("A$row_no:$endCell")->getFont()->setBold(true);
				}else{
					if($cell_val!=""){ $border_type++;
					$sheet->setCellValue($cellName, $cell_val);
					
					//$spreadsheet->getActiveSheet()->getStyle("$cellName")->getBorders()->getLeft()->applyFromArray( array( 'borderStyle' => PhpOffice\PhpSpreadsheet\Style\Border::BORDER_THIN, 'color' => array( 'rgb' => '808080'))); 
						//$spreadsheet->getActiveSheet()->getStyle("$cellName")->getBorders()->getRight()->applyFromArray( array( 'borderStyle' => PhpOffice\PhpSpreadsheet\Style\Border::BORDER_THIN, 'color' => array( 'rgb' => '808080'))); 
					//$spreadsheet->getActiveSheet()->getStyle("$cellName")->getBorders()->getTop()->applyFromArray( array( 'borderStyle' => PhpOffice\PhpSpreadsheet\Style\Border::BORDER_THIN, 'color' => array( 'rgb' => '808080')));
					//$spreadsheet->getActiveSheet()->getStyle("$cellName")->getBorders()->getBottom()->applyFromArray( array( 'borderStyle' => PhpOffice\PhpSpreadsheet\Style\Border::BORDER_THIN, 'color' => array( 'rgb' => '808080')));	
										
					}
				}
				if($cell_hd==="title"){ $border_type++;
					$spreadsheet->getActiveSheet()->getStyle("$cellName:$endCell")->getFill()->setFillType(\PhpOffice\PhpSpreadsheet\Style\Fill::FILL_SOLID)->getStartColor()->setARGB('90C2F9');
					$spreadsheet->setActiveSheetIndex(0)->mergeCells("$cellName:$endCell");	
					$spreadsheet->getActiveSheet()->getStyle("$cellName:$endCell")->getFont()->setBold(true);$spreadsheet->getActiveSheet()->getStyle("$cellName:$endCell")->getFont()->setSize(12);
					$sheet->getStyle($cellName)->getAlignment()->setHorizontal('center');	
					$spreadsheet->getActiveSheet()->getRowDimension(1)->setRowHeight(24); // CELL HEIGHT					
				}
				if($cell_hd==="tbl_head"){
					$border_type++;
					$spreadsheet->getActiveSheet()->getStyle("$cellName:$endCell")->getFill()->setFillType(\PhpOffice\PhpSpreadsheet\Style\Fill::FILL_SOLID)->getStartColor()->setARGB('CEE0F5');
					$spreadsheet->getActiveSheet()->getStyle("$cellName:$endCell")->getFont()->setBold(true);
					//$spreadsheet->getActiveSheet()->getStyle("$cellName:$endCell")->getBorders()->getTop()->applyFromArray( array( 'borderStyle' => PhpOffice\PhpSpreadsheet\Style\Border::BORDER_THIN, 'color' => array( 'rgb' => '808080'))); 
						  				
				}
				
			if($border_type>=1){
					
					$spreadsheet->getActiveSheet()->getStyle($cellName)->getBorders()->applyFromArray( [ 'allBorders' => [ 'borderStyle' => PhpOffice\PhpSpreadsheet\Style\Border::BORDER_THIN, 'color' => [ 'rgb' => 'a8bcd6' ] ] ] );
			}
				$cell_no++;				
				} 
				//$spreadsheet->getActiveSheet()->getStyle("$endCell")->getBorders()->getRight()->applyFromArray( array( 'borderStyle' => PhpOffice\PhpSpreadsheet\Style\Border::BORDER_THIN, 'color' => array( 'rgb' => '808080'))); 
			}
			 $spreadsheet->getActiveSheet()->getStyle("A$row_no:$endCell")->getBorders()->applyFromArray( [ 'allBorders' => [ 'borderStyle' => PhpOffice\PhpSpreadsheet\Style\Border::BORDER_THIN, 'color' => [ 'rgb' => 'a8bcd6' ] ] ] );

		$savefilepath='';	
		if($pg=='excel' || $email_format ==3){
		$attchmt_file = "$file_name".date("_d_m_Y_h_i_s").".xlsx";
		$writer = new Xlsx($spreadsheet);
		$writer->save($path_excel.$attchmt_file);
		$savefilepath= base_url().$path_excel.$attchmt_file;
		}
		//----- CSV CODE -------
		if($pg =='csv' ||  $email_format ==4){
		$attchmt_file = "$file_name".date("_d_m_Y_h_i_s").".csv";
		$writer = new \PhpOffice\PhpSpreadsheet\Writer\Csv($spreadsheet);
		$writer->save($path_excel.$attchmt_file);
		$savefilepath= base_url().$path_excel.$attchmt_file;
		}
		if($pg=='email'){
			$this->model->emailSendFormat($email_to, $email_sub, $email_desc,$regard='NULL',$topmenu='not',$from="NULL",$cc=array(),$attchmt_file,$path_excel);
		}else{
			echo $savefilepath; 
		}
		
			
	}
	}
 
	}else{
		echo "<h4 class='text-danger font-18 text-center mt-5'>Your Session has been expired. Click here to login again.<br/>
		<a href='".base_url()."welcome/login' class='btn btn-sm btn-primary mt-2'> Login </a>
		</h4>";  
	}

	}

	//=========== BILLABLE REPORT ========
	public function Billable_report(){
		$data["hcData"]=$this->model->DetailDatahc(array("h.hc_id"=>159));
		$this->session->unset_userdata('post_data');
		$whr="e.e_delete=0 AND e.e_id IN (SELECT t_e_id FROM tbl_timesheet)";
		$data["empallData"]=$this->hr->employee_details($whr);
		$data['clientData']=$this->model->sortingWheredata('*','tbl_prj_clients',$where='NULL','clnt_name ASC');
		$data['projData']=$this->model->sortingWheredata('*','tbl_prj_projects',$where='NULL','prj_nm ASC'); 
		$data["view"]="report/timesheet/billable_report";
		$this->load->view("layout",$data);
	}
	/*public function Billable_report_search_1($pg=''){
	//echo "<pre>"; print_r($_POST); echo "</pre>";
	$session_data=$this->session->userdata('loginData');
	if(isset($session_data) AND $session_data!=""){
	$data['post_data']=$_POST;
	$e_id = $this->input->post('e_id');
	$month = $this->input->post('month');
	$year = $this->input->post('year');
	$clnt_id = $this->input->post('clnt_id');
	
	$where='';
	$where.="td.td_type='Billable' AND t.t_year='$year'";
	$rpt_file_name  = "";
	$rpt_file_name .="Billable_Timesheet"; $month_div='';
	if($month!="" AND $month!="All"){ $month_div.='M';
		$rpt_file_name .="_".date('M-Y',strtotime("01-$month-$year"));
		$where.=" AND t.t_month='$month'";
	}
	if($e_id!="" AND $e_id!="All"){ $month_div.='E';
		$where.=" AND t.t_e_id='$e_id'";
		$empData=$this->model->LimitWheredata('CONCAT(e_first_name," ",e_last_name) AS e_name','tbl_employee',array('e_id'=>$e_id),'e_name ASC',1);
		$rpt_file_name .="_".$empData[0]['e_name'];
	}
	if($clnt_id!=""){ $month_div.='C';
		$clientData=$this->model->LimitWheredata('clnt_name','tbl_prj_clients',array('clnt_id'=>$clnt_id),'clnt_name ASC',1);
		$clnt_nm =explode(' ',trim($clientData[0]['clnt_name']));
		$rpt_file_name.="(".$clnt_nm[0].")";
		$where.=" AND c.clnt_id='$clnt_id'";
	}
		
	$tmData=$this->ts->billable_fun($where);
	
	foreach($tmData AS $i=>$k){
		$e_name = $k['employee_id']." - ".$k['e_name'];
		$t_month = $k['t_month'];
		$where_arr = array( 
			't.t_id'=>$k['t_id'], 
			'c.clnt_id'=> $k['clnt_id'],
			't.t_month'=> $k['t_month'],
		);
		$reportData[$e_name][$t_month]=$where_arr;
	}
	
	$result = '';
	if(Count($tmData) <= 0){
		echo "NODATA";
		//$result =  '<div class="text-danger text-center font-600">No data available.</div>';
	}else{
	$result .= "<style>.table-sm tr .bt-none{border-top: none !important;}
	.table-sm{ border: 1px solid #3c3838; }
	.table-sm td, .table-sm th {
    padding: 0px 5px;
    font-size: 12px;
    border-top: 1px solid #3c3838;
    border-left: 1px solid #3c3838;
    border-right: 1px solid #3c3838;
	}
	.text-blue{    color: #003aaf !important;}

		.table-sm td, .table-sm th {padding: 2px 5px;font-size: 12px;}
		.table-sm .th_head th {background: #cee0f5;}
		</style>
		<input type='hidden' name='rpt_file_name' value='$rpt_file_name'/>
		<table id='example' class=' table-sm'   cellspacing='0' style='min-width:50%'>";
		

		
		$sum1=0;
		$clm="<th class='bt-none'></th>";
		$tbl_head='';
		$tbl_head .='<tr class="th_head" style="background: #ebf0f7;">';
		if($month_div=='M'  || $month_div=='MC'){
			$tbl_head .='<th>Employee</th>';
		}elseif($month_div=='E' || $month_div=='EC'){
			$tbl_head .='<th>Month</th>';
		}elseif($month_div=='C'){
			$clm="<th class='bt-none'></th><th class='bt-none'></th>";
			$tbl_head .='<th>Month</th>';
			$tbl_head .='<th>Employee</th>';
		}elseif($month_div=='ME' || $month_div=='MEC'){
			$clm="";
		}
		
		$tbl_head .='<th style="width:90px">Date</th>
				<th style="width:90px">Project Charge Code</th>
				<th style="min-width:150px">Project Name</th>
				<th>Activity</th>
				<th style="width:80px;white-space: nowrap;">Working Hrs</th>
				</tr>';
		$n=0;
		foreach($reportData as $emp=>$t_month){ $n++;
			if($n==1){
				if($month_div=='M'){   
					$result .="<tr style='background-color: #90c2f9;'><th colspan='6' style='font-size: 15px;text-align:center;'> Billable Timesheet Report for ".date('F-Y',strtotime("01-$month-$year"))."</th></tr>"; 
				}
				if($month_div=='C'){   
					$result .="<tr style='background-color: #90c2f9;'><th colspan='7' style='font-size: 15px;text-align:center;'> Billable Timesheet for ".$clientData[0]['clnt_name']." FY $year</th></tr>"; 
				}
				if($month_div=='E'){   
					$result .="<tr style='background-color: #90c2f9;'><th colspan='6' style='font-size: 15px;text-align:center;'> Yearly Billable Timesheet $year <span class='text-blue'>&nbsp;&nbsp;&nbsp;&nbsp;Employee : $emp</span></th></tr>"; 
				}
				if($month_div=='EC'){   
					$result .="<tr style='background-color: #90c2f9;'><th colspan='7' style='font-size: 15px;text-align:center;'> Billable Timesheet for ".$clientData[0]['clnt_name']." FY $year |  <span class='text-blue'>Employee : $emp</span></th></tr>"; 
				}
				if($month_div=='MC'){   
					$result .="<tr style='background-color: #90c2f9;'><th colspan='7' style='font-size: 15px;text-align:center;'> Billable Timesheet for ".$clientData[0]['clnt_name']." ".date('F-Y',strtotime("01-$month-$year"))."</th></tr>"; 
				}
				if($month_div=='ME'){   
					$result .="<tr style='background-color: #90c2f9;'><th colspan='7' style='font-size: 15px;text-align:center;'> Billable Timesheet for $emp ".date('F-Y',strtotime("01-$month-$year"))."</th></tr>"; 
				}
				if($month_div=='MEC'){   
					$result .="<tr style='background-color: #90c2f9;'><th colspan='7' style='font-size: 15px;text-align:center;'> Billable Timesheet for ".$clientData[0]['clnt_name']." FY ".date('F-Y',strtotime("01-$month-$year"))." |  <span class='text-blue'>Employee : $emp</span></th></tr>"; 
				}

				$result .=$tbl_head;
			}
		
			if($month_div=='M'  || $month_div=='MC'){
				$result .="<tr style='background-color: #ffeeba;border-bottom:1px solid #3c3838'><th style='white-space: nowrap;'>$emp</th><td colspan='5'></td></tr>";
			}
			$sum2=0;
			foreach($t_month as $month=>$arr){
				if($month_div=='E' || $month_div=='EC'){ $result .="<tr style='background-color: #ffeeba;border-bottom:1px solid #3c3838'><th style='text-align:left;font-size: 13px;'>".date('F-Y',strtotime("01-$month-$year"))."</th><td colspan='5'></td></tr>"; 
					}elseif($month_div=='C'){
					$result .="<tr style='background-color: #ffeeba;border-bottom:1px solid #3c3838'><th style='white-space: nowrap;'>".date('F-Y',strtotime("01-$month-$year"))."</th><th style='white-space: nowrap;'>$emp</th><td colspan='5'></td></tr>";
					}
				
				$sum3=0;
				$proj_tmData=$this->ts->tm_data_list($arr);
				//echo "<pre>";print_r($proj_tmData);echo "</pre>";
				
				$arr = [];
				foreach($proj_tmData AS $i3=>$k3){ 
					
					$tr_cls =''; $td_cls ='';
					if(in_array($k3['td_date'],$arr)){
						$tr_cls ='bt-none';
						$td_cls ='display_none';
						$td_date="";
					}else{
						$td_date=date('d-M-Y',strtotime($k3['td_date']));
						//$tr_cls ='border-top: none;';
						$arr[] =$k3['td_date'];
					} 
					$result .="<tr>
					$clm
					<td class='$tr_cls' style='$tr_cls'>$td_date</td>
					<td>".$k3['project_code']."</td>
					<td>".$k3['project_name']."</td>
					<td>".htmlspecialchars($k3['td_activity'])."</td>
					<td>".$k3['td_working_hrs']."</td> 
					</tr>";
					
					$sum3+=$k3['td_working_hrs']; $sum2+=$k3['td_working_hrs']; $sum1+=$k3['td_working_hrs'];
					}
					//echo "<pre>";print_r($arr);echo "</pre>";
					if(count($arr) > 1){
					$result.= "<tr>$clm<th colspan='4' style='text-align:right;'>TOTAL</td><th>$sum3</th></tr>";
					}
			}
			//if(count($t_month) > 1){

			//$result.= "<tr style='background-color:#d4e4f7;'>$clm<th colspan='4'  style='text-align:right;'>TOTAL</td><th>$sum2</th></tr>";
			//}
		}
		if($sum3!=$sum1){ //$sum2!=$sum1 ||  
		$result.= "<tr style='background-color: #f5c6cb;border-top:1px solid #3c3838'>$clm<th colspan='4' style='text-align:right;'>GRAND TOTAL</td><th>$sum1</th></tr>";
		}
		$result .="</table>";		
	

	//------- REPORT DOWNLOAD FORMAT -----
	if($pg=="search"){
		echo $result;
	}
	$email_format=0;
	if($pg=='email'){
		$email_format = $this->input->post("email_format");
	  	$email_to = $this->input->post("email_to");
	  	$email_sub = $this->input->post("email_sub");
	  	$email_desc = $this->input->post("email_desc");
		
	  	if($email_format ==1){	 
   			$email_msg=$email_desc."<br/>".$result; 
   			$this->model->emailSendFormat($email_to, $email_sub, $email_msg);
   		} 
		
	}

	if($pg=='pdf' || ($pg=='email' AND $email_format ==2)){
		
		include_once APPPATH . '/third_party/vendor/autoload.php';
		$pdf = new \Mpdf\Mpdf();
		$pdf->AddPage('P','', '', '', '', 5,5,5,5,5,5);
		$pdf->WriteHTML($result);
		$folder_name = date("Y");
		if (!file_exists(FCPATH . "assets/report_pdf/".$folder_name)) {
		$pdfFilePath1 = mkdir(FCPATH . "assets/report_pdf/".$folder_name, 0755, true);
		}
		$PDFname=$rpt_file_name.date("_d_m_Y_h_i_s").".pdf";
		$path_pdf =  'assets/report_pdf/'.$folder_name.'/';
		$pdf->Output(FCPATH.$path_pdf.$PDFname,'F');
		if($pg=='email'){
			$attchmt_file = $PDFname;
			$attchmt_path = $path_pdf;
			$this->model->emailSendFormat($email_to, $email_sub, $email_desc,$regard='NULL',$topmenu='not',$from="NULL",$cc=array(),$attchmt_file,$attchmt_path);
		}else{
			echo ''.base_url().$path_pdf.$PDFname; 
		} 
	}
	if(($pg=='excel' || $pg=='csv') || ($pg=='email' AND ($email_format ==3 || $email_format ==4))){
		$file_name = $rpt_file_name; 
		$folder_name = date("Y");
		if (!file_exists(FCPATH . "assets/report_excel/".$folder_name)) {
		$pdfFilePath1 = mkdir(FCPATH . "assets/report_excel/".$folder_name, 0755, true);
		}
		$path_excel =  'assets/report_excel/'.$folder_name.'/';
		$attchmt_path = $path_excel;
		require 'vendor/autoload.php';
		$spreadsheet = new Spreadsheet();
		$sheet = $spreadsheet->getActiveSheet();
		$row_no=0; $cell_mrg=[];
		$sheet->getColumnDimension('A')->setAutoSize(true);
		$sheet->getColumnDimension('B')->setAutoSize(true);
		$sheet->getColumnDimension('C')->setAutoSize(true);
		$sheet->getColumnDimension('D')->setAutoSize(true);
		
		
			foreach($array_excel AS $cell_hd=>$arr_cell){
				$row_no++; $cell_no=0;
				$endCell = $this->model->Arr_cell($row_no,(count($array_excel['tbl_head'])-1)); 
				
				//echo "<br/>-----------------------------------------------------------<br/>";
				foreach($arr_cell AS $ex_head=>$cell_val){ 
				$cellName = $this->model->Arr_cell($row_no,$cell_no);
				//echo "$cellName | $cell_val";
				if($cell_val==='TOTAL' || $cell_val==='GRAND TOTAL'){
					$spreadsheet->getActiveSheet()->getStyle("A$row_no:$endCell")->getFont()->setBold(true);
						$spreadsheet->getActiveSheet()->getStyle("A$row_no:$endCell")->getBorders()->getBottom()->applyFromArray( array( 'borderStyle' => PhpOffice\PhpSpreadsheet\Style\Border::BORDER_THIN, 'color' => array( 'rgb' => '808080')));	
					if($cell_val==='GRAND TOTAL'){
						$spreadsheet->getActiveSheet()->getStyle("A$row_no:$endCell")->getBorders()->getTop()->applyFromArray( array( 'borderStyle' => PhpOffice\PhpSpreadsheet\Style\Border::BORDER_THIN, 'color' => array( 'rgb' => '808080')));
					}
				}
				if($ex_head==='bg_color'){
					$spreadsheet->getActiveSheet()->getStyle("A$row_no:$endCell")->getFill()->setFillType(\PhpOffice\PhpSpreadsheet\Style\Fill::FILL_SOLID)->getStartColor()->setARGB($cell_val);
					$spreadsheet->getActiveSheet()->getStyle("A$row_no:$endCell")->getFont()->setBold(true);
				}else{
					if($cell_val!=""){
					$sheet->setCellValue($cellName, $cell_val);
					$spreadsheet->getActiveSheet()->getStyle("$cellName")->getBorders()->getLeft()->applyFromArray( array( 'borderStyle' => PhpOffice\PhpSpreadsheet\Style\Border::BORDER_THIN, 'color' => array( 'rgb' => '808080'))); 
					$spreadsheet->getActiveSheet()->getStyle("$cellName")->getBorders()->getRight()->applyFromArray( array( 'borderStyle' => PhpOffice\PhpSpreadsheet\Style\Border::BORDER_THIN, 'color' => array( 'rgb' => '808080'))); 
					$spreadsheet->getActiveSheet()->getStyle("$cellName")->getBorders()->getTop()->applyFromArray( array( 'borderStyle' => PhpOffice\PhpSpreadsheet\Style\Border::BORDER_THIN, 'color' => array( 'rgb' => '808080')));
					$spreadsheet->getActiveSheet()->getStyle("$cellName")->getBorders()->getBottom()->applyFromArray( array( 'borderStyle' => PhpOffice\PhpSpreadsheet\Style\Border::BORDER_THIN, 'color' => array( 'rgb' => '808080')));					
					}
				}
				if($cell_hd==="title"){
					$spreadsheet->getActiveSheet()->getStyle("$cellName:$endCell")->getFill()->setFillType(\PhpOffice\PhpSpreadsheet\Style\Fill::FILL_SOLID)->getStartColor()->setARGB('90C2F9');
					$spreadsheet->setActiveSheetIndex(0)->mergeCells("$cellName:$endCell");	
					$spreadsheet->getActiveSheet()->getStyle("$cellName:$endCell")->getFont()->setBold(true);$spreadsheet->getActiveSheet()->getStyle("$cellName:$endCell")->getFont()->setSize(12);
					$sheet->getStyle($cellName)->getAlignment()->setHorizontal('center');	
					$spreadsheet->getActiveSheet()->getRowDimension(1)->setRowHeight(24); // CELL HEIGHT					
				}
				if($cell_hd==="tbl_head"){
					
					$spreadsheet->getActiveSheet()->getStyle("$cellName:$endCell")->getFill()->setFillType(\PhpOffice\PhpSpreadsheet\Style\Fill::FILL_SOLID)->getStartColor()->setARGB('CEE0F5');
					$spreadsheet->getActiveSheet()->getStyle("$cellName:$endCell")->getFont()->setBold(true);
					$spreadsheet->getActiveSheet()->getStyle("$cellName:$endCell")->getBorders()->getTop()->applyFromArray( array( 'borderStyle' => PhpOffice\PhpSpreadsheet\Style\Border::BORDER_THIN, 'color' => array( 'rgb' => '808080'))); 
						  				
				}
				
				$cell_no++;				
				} 
				$spreadsheet->getActiveSheet()->getStyle("$endCell")->getBorders()->getRight()->applyFromArray( array( 'borderStyle' => PhpOffice\PhpSpreadsheet\Style\Border::BORDER_THIN, 'color' => array( 'rgb' => '808080'))); 
			}
			
		$savefilepath='';	
		if($pg=='excel' || $email_format ==3){
		$attchmt_file = "$file_name".date("_d_m_Y_h_i_s").".xlsx";
		$writer = new Xlsx($spreadsheet);
		$writer->save($path_excel.$attchmt_file);
		$savefilepath= base_url().$path_excel.$attchmt_file;
		}
		//----- CSV CODE -------
		if($pg =='csv' ||  $email_format ==4){
		$attchmt_file = "$file_name".date("_d_m_Y_h_i_s").".csv";
		$writer = new \PhpOffice\PhpSpreadsheet\Writer\Csv($spreadsheet);
		$writer->save($path_excel.$attchmt_file);
		$savefilepath= base_url().$path_excel.$attchmt_file;
		}
		if($pg=='email'){
			$this->model->emailSendFormat($email_to, $email_sub, $email_desc,$regard='NULL',$topmenu='not',$from="NULL",$cc=array(),$attchmt_file,$path_excel);
		}else{
			echo $savefilepath; 
		}
		
			
	} //EXCEL
	//------- REPORT DOWNLOAD FORMAT -----
	}
	}else{
		echo "<h4 class='text-danger font-18 text-center mt-5'>Your Session has been expired. Click here to login again.<br/>
		<a href='".base_url()."welcome/login' class='btn btn-sm btn-primary mt-2'> Login </a>
		</h4>";
	}

	}*/



	public function Billable_report_search_17_3($pg=''){
	//echo "<pre>"; print_r($_POST); echo "</pre>";
	$session_data=$this->session->userdata('loginData');
	if(isset($session_data) AND $session_data!=""){
	
		$data['post_data']=$_POST;
		$e_id = $this->input->post('e_id');
		$month = $this->input->post('month');
		$year = $this->input->post('year');
		$clnt_id = $this->input->post('clnt_id');
	

	$where='';
	$where.="td.td_type='Billable' AND t.t_year='$year'";
	$rpt_file_name  = "";
	$rpt_file_name .="Billable_Timesheet"; $srcArr =[];
	if($month!="" AND $month!="All"){ $srcArr[]='M';
		$rpt_file_name .="_".date('M-Y',strtotime("01-$month-$year"));
		$where.=" AND t.t_month='$month'";
	}
	if($e_id!="" AND $e_id!="All"){  $srcArr[]='E';
		$where.=" AND t.t_e_id='$e_id'";
		$empData=$this->model->LimitWheredata('CONCAT(e_first_name," ",e_last_name) AS e_name','tbl_employee',array('e_id'=>$e_id),'e_name ASC',1);
		$rpt_file_name .="_".$empData[0]['e_name'];

	}
	if($clnt_id!=""){  $srcArr[]='C';
		$clientData=$this->model->LimitWheredata('clnt_name','tbl_prj_clients',array('clnt_id'=>$clnt_id),'clnt_name ASC',1);
		$clnt_nm =explode(' ',trim($clientData[0]['clnt_name']));
		$rpt_file_name.="(".$clnt_nm[0].")";
		$where.=" AND c.clnt_id='$clnt_id'";
	}
	
	$tmData=$this->ts->billable_fun($where);
	//echo "<pre>";print_r($tmData);echo "</pre>";die;
	//echo "month_div:$month_div";
	foreach($tmData AS $i=>$k){
		$e_name = $k['employee_id']." - ".$k['e_name'];
		$t_month = $k['t_month'];
		$clnt_name = $k['clnt_name'];
		$prj_nm = $k['prj_nm'];
		$where_arr = array( 
			't.t_id'=>$k['t_id'], 
			'c.clnt_id'=> $k['clnt_id'],
			'pr.prj_id'=> $k['prj_id'],
			't.t_month'=> $k['t_month'],
		);
		$reportData[$clnt_name][$t_month][$e_name][$prj_nm]=$where_arr;
	}
	//echo "<pre>";print_r($reportData);echo "</pre>";
	$result = ''; $array_excel=[];
	if(Count($tmData) <= 0){
		$result =  '<div class="text-danger text-center font-600">No data available.</div>';
	}else{
		$result .= "<style>.table-sm tr .bt-none{border-top: none !important;}
		.hd_brd{border-bottom: 1px solid #3c3838;}
		.table-sm{ border: 1px solid #3c3838; }
		.table-sm td, .table-sm th {
		padding: 0px 5px;
		font-size: 12px;
		border-top: 1px solid #3c3838;
		border-left: 1px solid #3c3838;
		border-right: 1px solid #3c3838;
		}
		.text-blue{color: #003aaf !important;}
		.table-sm td, .table-sm th {padding: 2px 5px;font-size: 12px;}
		.table-sm .th_head th {background: #cee0f5;}
		
		/*.hd2{ background:#8798ab;}
		.hd3{ background:#b9bfc5;}
		.hd4{ background:#e0e1e2;}*/
		</style>
		<input type='hidden' name='rpt_file_name' value='$rpt_file_name'/>";
		if($pg =='email'){
		$result .= "<table id='example' class='table-sm' border='1'   cellspacing='0' >";
		}else{
		$result .= "<table id='example' class='table-sm'    cellspacing='0' >";	
		}
		
		
		$clm="<th class='bt-none'></th>";
		$tbl_head=''; $tbl_head_arr=[];
		$tbl_head .='<tr class="th_head" style="background: #ebf0f7;">';
		$cell_arr=[];
		if(!in_array('C', $srcArr)){
			$tbl_head .='<th>Client</th>';
			$tbl_head_arr[]='Client';
			
		}
		if(!in_array('M', $srcArr)){
			$tbl_head .='<th>Month</th>';
			$tbl_head_arr[]='Month';
			
			
		}
		if(!in_array('E', $srcArr)){
			$tbl_head .='<th>Employee</th>';
			$tbl_head_arr[]='Employee';
			
		}
		

		
	
		$rpt_head="";
		if(in_array('C', $srcArr)){
			$rpt_head .= ' Client : '.$clientData[0]['clnt_name'];
			
		}
		if(in_array('M', $srcArr)){
			$rpt_head .= ' Month-Year : '.date('M-Y',strtotime("01-$month-$year"));
			
		}
		if(in_array('E', $srcArr)){
			$rpt_head .= ' Employee : '.$empData[0]['e_name'];
			
		}
		
	
		
		$colspan=6;
		if(count($srcArr)==1){
			$colspan=6;
		}
		if(count($srcArr)==2){
			$colspan=5;
		}
		if(count($srcArr)==3){
			$colspan=4;
		}
		$tbl_head .='<th style="min-width:150px">Project Name</th>
		<th style="width:85px">Date</th>
		<th>Activity</th>
		<th style="width:80px;white-space: nowrap;">Working Hrs</th>
		</tr>';
		$tbl_head_arr[]='Project Name';
		$tbl_head_arr[]='Date';
		$tbl_head_arr[]='Activity';
		$tbl_head_arr[]='Working Hrs';
		$tbl_head_arr["bg_color"]='D2E7FF';
		
		$n=0; $sum1=0;
		foreach($reportData as $client=>$arr1){ $n++;
			if($n==1){ // HEADING
				$result .="<tr style='background-color: #90c2f9;'><th colspan='$colspan' style='font-size: 14px;text-align:center;'> <span style='font-size:18px;'>Billable Timesheet Report</span> <br/> $rpt_head</th></tr>"; 
				$result .= $tbl_head;
				$array_excel['title'][]='Billable Timesheet Report';
				$array_excel['sub_title'][]=$rpt_head;
				$array_excel['tbl_head']=$tbl_head_arr;
			}
			 $tr_c=''; 
			if(!in_array('C', $srcArr)){ 
			 	$tr_c="<th class='bt-none'></th>";
				$result .="<tr style='background: #FFEEBA; border-top:2px solid;'><th class='hd_brd' style='white-space: nowrap;'>$client</th>";
				
				if(count($srcArr)==1){
				$result .="<td></td><td></td>";
				$array_excel[]=array($client,"","","",""); //,"bg_color"=>"FFEEBA"
				}
				if(count($srcArr)==2){
				$result .="<td></td>";
				$array_excel[]=array($client,"","",""); //,"bg_color"=>"FFEEBA"
				}
				$result .="<td></td><td></td><td></td></tr>";
				
			}
			$sum2=0;
			foreach($arr1 as $months=>$arr2){ 
				$tr_m=''; 
				if(!in_array('M', $srcArr)){
				$tr_m="<th class='bt-none'></th>"; 
				$result .="<tr>$tr_c<th class='hd_brd hd2' style='white-space: nowrap;'>".date('F-Y',strtotime("01-$months-$year"))."</th> ";
				
				$array_excel[]=array_filter(array($tr_c,date('F-Y',strtotime("01-$months-$year")),"","","")); //,"bg_color"=>"8798ab"
				
				
				if(count($srcArr)==1){
					if(in_array('C', $srcArr)){
					$result .="<td class='hd2'></td><td class='hd2'></td>";
					//$array_excel[]=array("","");
					}else{
					$result .="<td class='hd2'></td>";	
					//$array_excel[]="";
					}
				}
				if(count($srcArr)==2){
					$result .="<td class='hd2'></td>";	
					//$array_excel[]="";
				}
				
				$result .="<td class='hd2'></td><td class='hd2'></td><td class='hd2'></td></tr>";
				//$array_excel[]=array("","","");
				}
				$sum3=0;
				foreach($arr2 as $emp=>$arr3){ 
					$tr_e='';
					if(!in_array('E', $srcArr)){
					$tr_e="<th class='bt-none'></th>"; 
					$result .="<tr>$tr_c $tr_m<th class='hd_brd hd3' style='white-space: nowrap;'>$emp</th><td class='hd3'></td><td class='hd3'></td><td class='hd3'></td><td class='hd3'></td></tr>";
					$array_excel[]=array_filter(array($tr_c, $tr_m,$emp)); //,"bg_color"=>"b9bfc5"
					}
					$sum4=0;
					foreach($arr3 as $prj=>$arr4){ 
					$tr_p='';
						if(!in_array('P', $srcArr)){ 
						$tr_p="<th class='bt-none'></th>";
						$result .="<tr>$tr_c $tr_m $tr_e<th class='hd_brd hd4' style='white-space: nowrap;'>$prj</th><td class='hd4'></td><td class='hd4'></td><td class='hd4'></td></tr>";
						//$array_excel[]=array($prj);
						$array_excel[]=array_filter(array($tr_c, $tr_m, $tr_e,$prj)); //,"bg_color"=>"e0e1e2"
						}
						//foreach($arr4 as $t=>$arr5){ 
							$arr = [];
							$sum5=0;
							$proj_tmData=$this->ts->tm_data_list($arr4);
							//echo "<pre>";print_r($t);echo "</pre>";
							foreach($proj_tmData AS $k1=>$k){ 
								$tr_cls ='';
								if(in_array($k['td_date'],$arr)){
									$tr_cls ='bt-none';
									$td_cls ='display_none';
									$td_date="";
								}else{
									$td_date=date('d-M-Y',strtotime($k['td_date']));
									//$tr_cls ='border-top: none;';
									$arr[] =$k['td_date'];
								} 
								$result .="<tr>
								$tr_c $tr_m $tr_e $tr_p
								<td class='$tr_cls' style='white-space:nowrap'>$td_date</td>
								
								<td>".htmlspecialchars($k['td_activity'])."</td>
								<td>".$k['td_working_hrs']."</td> 
								</tr>";
								
									
								$array_excel[]=array_merge(array_filter(array($tr_c, $tr_m, $tr_e, $tr_p)),array($td_date,htmlspecialchars($k['td_activity']),$k['td_working_hrs']));
								
								 
								$working_hrs=$k['td_working_hrs'];
								$sum1 +=$working_hrs;
								$sum2 +=$working_hrs;
								$sum3 +=$working_hrs;
								$sum4 +=$working_hrs;
								$sum5 +=$working_hrs;
							} 
							if(count($proj_tmData) > 1 && $sum5!=0){
							$result.= "<tr>$tr_c $tr_m $tr_e $tr_p<th colspan='2' style='text-align:right;'>TOTAL</td><th>$sum5</th></tr>";
							$array_excel[]=array($tr_c, $tr_m, $tr_e, $tr_p, "TOTAL", $sum5);
							}
						/*$tr_p='';
						if(!in_array('E', $srcArr)){
						$tr_p='<th></th>';
						$result .="<tr>$tr_c $tr_m $tr_e<th style='white-space: nowrap;'>$prj</th><td colspan='5'></td></tr>";
						}*/
						//} // $arr4
					} // $arr3 
					//$tr_cell=[]; 
					if(count($arr3) > 1 && $sum4!=0 && $sum5 !=$sum4){
					$result.= "<tr class='hd_brd'>$tr_c $tr_m $tr_e $tr_p <th colspan='2' style='text-align:right;'> TOTAL</td><th>$sum4</th></tr>";
					$array_excel[]=array($tr_c, $tr_m, $tr_e, $tr_p, "TOTAL", $sum4);
					}
				} // $arr2
				//$tr_cell=[]; 
				if(count($arr2) > 1 && $sum3!=0 && $sum4 !=$sum2){
				//$result.= "<tr class='table-info hd_brd'>$tr_c $tr_m $tr_e $tr_p <th colspan='2' style='text-align:right;'>Month TOTAL</td><th>$sum3</th></tr>";
				}

			} // $arr1
			
			if(count($arr1) > 1 && $sum2!=0 && $sum3 !=$sum2){
				if(count($reportData) <= 1){
				$result.= "<tr style='background-color: #f5c6cb;border-top:1px solid #3c3838'>$tr_c $tr_m $tr_e $tr_p 
				<th colspan='2' style='text-align:right;'>GRAND TOTAL </td>
				<th>$sum2</th></tr>";
				$array_excel[]=array($tr_c, $tr_m, $tr_e, $tr_p, "GRAND TOTAL", $sum2,'bg_color'=>'f5c6cb');
				}else{
				$result.= "<tr class='hd_brd'>$tr_c $tr_m $tr_e $tr_p 
				<th colspan='2' style='text-align:right;'>TOTAL </td>
				<th>$sum2</th></tr>";
				$array_excel[]=array($tr_c, $tr_m, $tr_e, $tr_p, "TOTAL", $sum2);
				}
				
				}
			

		} // $reportData
		if(count($reportData) > 1 && $sum1!=0 && $sum1 !=$sum2){
		$result.= "<tr style='background-color: #f5c6cb;border-top:1px solid #3c3838'>$tr_c $tr_m $tr_e $tr_p<th colspan='2' style='text-align:right;'>GRAND TOTAL</td><th>$sum1</th></tr>";
		$array_excel[]=array($tr_c, $tr_m, $tr_e, $tr_p, "GRAND TOTAL", $sum1,'bg_color'=>'f5c6cb');
		}

		$result .= "</table>";

	} // Count($tmData)
	
	//echo "<pre>"; print_r($array_excel); echo "</pre>"; 
	//--------
	if($pg=="search"){
		 	 
		echo $result;
	} 
	$email_format=0;
	if($pg=='email'){
		$email_format = $this->input->post("email_format");
	  	$email_to = $this->input->post("email_to");
	  	$email_sub = $this->input->post("email_sub");
	  	$email_desc = $this->input->post("email_desc");
		
	  	if($email_format ==1){	 
   			$email_msg=$email_desc."<br/>".$result; 
   			$this->model->emailSendFormat($email_to, $email_sub, $email_msg);
   		} 
		
	}

	if($pg=='pdf' || ($pg=='email' AND $email_format ==2)){
		
		include_once APPPATH . '/third_party/vendor/autoload.php';
		$pdf = new \Mpdf\Mpdf();
		$pdf->AddPage('P','', '', '', '', 5,5,5,5,5,5);
		$pdf->WriteHTML($result);
		$folder_name = date("Y");
		if (!file_exists(FCPATH . "assets/report_pdf/".$folder_name)) {
		$pdfFilePath1 = mkdir(FCPATH . "assets/report_pdf/".$folder_name, 0755, true);
		}
		$PDFname=$rpt_file_name.date("_d_m_Y_h_i_s").".pdf";
		$path_pdf =  'assets/report_pdf/'.$folder_name.'/';
		$pdf->Output(FCPATH.$path_pdf.$PDFname,'F');
		if($pg=='email'){
			$attchmt_file = $PDFname;
			$attchmt_path = $path_pdf;
			$this->model->emailSendFormat($email_to, $email_sub, $email_desc,$regard='NULL',$topmenu='not',$from="NULL",$cc=array(),$attchmt_file,$attchmt_path);
		}else{
			echo ''.base_url().$path_pdf.$PDFname; 
		} 
	}
	if(($pg=='excel' || $pg=='csv') || ($pg=='email' AND ($email_format ==3 || $email_format ==4))){
		$file_name = $rpt_file_name; 
		$folder_name = date("Y");
		if (!file_exists(FCPATH . "assets/report_excel/".$folder_name)) {
		$pdfFilePath1 = mkdir(FCPATH . "assets/report_excel/".$folder_name, 0755, true);
		}
		$path_excel =  'assets/report_excel/'.$folder_name.'/';
		$attchmt_path = $path_excel;
		require 'vendor/autoload.php';
		$spreadsheet = new Spreadsheet();
		$sheet = $spreadsheet->getActiveSheet();
		$row_no=0; $cell_mrg=[];
		$clarr=array('A','B','C','D','E','F','G','H');
		for($cl=0;$cl<=(count($array_excel['tbl_head'])-2);$cl++){
			//echo "<br/>".$clarr[$cl]."--".$cl."==>".$array_excel['tbl_head'][$cl];
			if($array_excel['tbl_head'][$cl]==='Activity'){
				//echo "call";
				$spreadsheet->getActiveSheet()->getStyle($clarr[$cl].'1:'.$clarr[$cl].$spreadsheet->getActiveSheet()->getHighestRow())->getAlignment()->setWrapText(true);
				$spreadsheet->getActiveSheet()->getColumnDimension($clarr[$cl])->setWidth(60);
			}else{
				$sheet->getColumnDimension($clarr[$cl])->setAutoSize(true);
			}
		}
		//die;
		//$sheet->getColumnDimension('B')->setAutoSize(true);
		//$sheet->getColumnDimension('C')->setAutoSize(true);
		//$sheet->getColumnDimension('D')->setAutoSize(true);
		
		
			foreach($array_excel AS $cell_hd=>$arr_cell){
				$row_no++; $cell_no=0;
				$endCell = $this->model->Arr_cell($row_no,(count($array_excel['tbl_head'])-2)); 
				
				//echo "<br/>-----------------------------------------------------------<br/>";
				foreach($arr_cell AS $ex_head=>$cell_val){ 
				$cellName = $this->model->Arr_cell($row_no,$cell_no);
				//$spreadsheet->getActiveSheet()->getStyle("$cellName")->getBorders()->applyFromArray( [ 'allBorders' => [ 'borderStyle' => PhpOffice\PhpSpreadsheet\Style\Border::BORDER_THIN, 'color' => [ 'rgb' => '808080' ] ] ] );
				//echo "$cellName | $cell_val";
				if($cell_val==='TOTAL' || $cell_val==='GRAND TOTAL'){
					$spreadsheet->getActiveSheet()->getStyle("A$row_no:$endCell")->getFont()->setBold(true);
					$sheet->getStyle("A$row_no:$endCell")->getAlignment()->setHorizontal('right');	
				}
				if($ex_head==='bg_color'){
					$spreadsheet->getActiveSheet()->getStyle("A$row_no:$endCell")->getFill()->setFillType(\PhpOffice\PhpSpreadsheet\Style\Fill::FILL_SOLID)->getStartColor()->setARGB($cell_val);
					$spreadsheet->getActiveSheet()->getStyle("A$row_no:$endCell")->getFont()->setBold(true);
					
				}else{
					if($cell_val!=""){ 
						if($cell_val==="<th class='bt-none'></th>"){ $cell_val=""; }
					$sheet->setCellValue($cellName, html_entity_decode($cell_val));
					//$spreadsheet->getActiveSheet()->getStyle("$cellName")->getBorders()->getLeft()->applyFromArray( array( 'borderStyle' => PhpOffice\PhpSpreadsheet\Style\Border::BORDER_THIN, 'color' => array( 'rgb' => '808080'))); 
						//$spreadsheet->getActiveSheet()->getStyle("$cellName")->getBorders()->getRight()->applyFromArray( array( 'borderStyle' => PhpOffice\PhpSpreadsheet\Style\Border::BORDER_THIN, 'color' => array( 'rgb' => '808080'))); 
					//$spreadsheet->getActiveSheet()->getStyle("$cellName")->getBorders()->getTop()->applyFromArray( array( 'borderStyle' => PhpOffice\PhpSpreadsheet\Style\Border::BORDER_THIN, 'color' => array( 'rgb' => '808080')));
					//$spreadsheet->getActiveSheet()->getStyle("$cellName")->getBorders()->getBottom()->applyFromArray( array( 'borderStyle' => PhpOffice\PhpSpreadsheet\Style\Border::BORDER_THIN, 'color' => array( 'rgb' => '808080')));					
					}
				}
				if($cell_hd==="title"){
					$spreadsheet->getActiveSheet()->getStyle("A$row_no:$endCell")->getFill()->setFillType(\PhpOffice\PhpSpreadsheet\Style\Fill::FILL_SOLID)->getStartColor()->setARGB('90C2F9');
					$spreadsheet->setActiveSheetIndex(0)->mergeCells("$cellName:$endCell");	
					$spreadsheet->getActiveSheet()->getStyle("$cellName:$endCell")->getFont()->setBold(true);$spreadsheet->getActiveSheet()->getStyle("$cellName:$endCell")->getFont()->setSize(16);
					$sheet->getStyle($cellName)->getAlignment()->setHorizontal('center');	
					$spreadsheet->getActiveSheet()->getRowDimension(1)->setRowHeight(24); // CELL HEIGHT					
				}
				if($cell_hd==="sub_title"){
					$spreadsheet->getActiveSheet()->getStyle("$cellName:$endCell")->getFill()->setFillType(\PhpOffice\PhpSpreadsheet\Style\Fill::FILL_SOLID)->getStartColor()->setARGB('90C2F9');
					$spreadsheet->setActiveSheetIndex(0)->mergeCells("$cellName:$endCell");	
					$spreadsheet->getActiveSheet()->getStyle("$cellName:$endCell")->getFont()->setBold(true);$spreadsheet->getActiveSheet()->getStyle("$cellName:$endCell")->getFont()->setSize(11);
					$sheet->getStyle($cellName)->getAlignment()->setHorizontal('center');	
					 			
				}
				
				if($cell_hd==="tbl_head"){
					$spreadsheet->getActiveSheet()->getStyle("A$row_no:$endCell")->getBorders()->applyFromArray( [ 'allBorders' => [ 'borderStyle' => PhpOffice\PhpSpreadsheet\Style\Border::BORDER_THIN, 'color' => [ 'rgb' => 'A8BCD6' ] ] ] );  
				}
				
				$cell_no++;				
				} 
					
				//$spreadsheet->getActiveSheet()->getStyle("$endCell")->getBorders()->getRight()->applyFromArray( array( 'borderStyle' => PhpOffice\PhpSpreadsheet\Style\Border::BORDER_THIN, 'color' => array( 'rgb' => '808080'))); 
				
			}
			
			
		$savefilepath='';	
		if($pg=='excel' || $email_format ==3){
		//$attchmt_file = "HRMS.xlsx";
		$attchmt_file = "$file_name".date("_d_m_Y_h_i_s").".xlsx";
		$writer = new Xlsx($spreadsheet);
		$writer->save($path_excel.$attchmt_file);
		$savefilepath= base_url().$path_excel.$attchmt_file;
		}
		//----- CSV CODE -------
		if($pg =='csv' ||  $email_format ==4){
		$attchmt_file = "$file_name".date("_d_m_Y_h_i_s").".csv";
		$writer = new \PhpOffice\PhpSpreadsheet\Writer\Csv($spreadsheet);
		$writer->save($path_excel.$attchmt_file);
		$savefilepath= base_url().$path_excel.$attchmt_file;
		}
		if($pg=='email'){
			$this->model->emailSendFormat($email_to, $email_sub, $email_desc,$regard='NULL',$topmenu='not',$from="NULL",$cc=array(),$attchmt_file,$path_excel);
		}else{
			echo $savefilepath; 
		}
		
			
	}

	}else{
		echo "<h4 class='text-danger font-18 text-center mt-5'>Your Session has been expired. Click here to login again.<br/>
		<a href='".base_url()."welcome/login' class='btn btn-sm btn-primary mt-2'> Login </a>
		</h4>";
	}

	}



	public function timebook_project_report(){
		$data["hcData"]=$this->model->DetailDatahc(array("h.hc_id"=>160));
		$this->session->unset_userdata('post_data');
		$this->session->unset_userdata('post_data');
		$whr="e.e_delete=0 AND e.e_id IN (SELECT t_e_id FROM tbl_timesheet)";
		$data["empallData"]=$this->hr->employee_details($whr);
		$data['clientData']=$this->model->sortingWheredata('*','tbl_prj_clients',$where='NULL','clnt_name ASC');
		$data['projData']=$this->model->sortingWheredata('*','tbl_prj_projects',$where='NULL','prj_nm ASC');
		$data["view"]="report/timesheet/timebook_project";
		$this->load->view("layout",$data);
	}
	public function timebook_project_report_search($pg=''){
	//echo "<pre>"; print_r($_POST); echo "</pre>"; 
	$session_data=$this->session->userdata('loginData');
	if(isset($session_data) AND $session_data!=""){
	$data['post_data']=$_POST;
	$e_id = $this->input->post('e_id');
	$month = $this->input->post('month');
	$year = $this->input->post('year');
	$clnt_id = $this->input->post('clnt_id');
	$prj_id = $this->input->post('prj_id');
	$email_format=0;
	if($pg=='email'){
		$email_format = $this->input->post("email_format");
	  	$email_to = $this->input->post("email_to");
	  	$email_sub = $this->input->post("email_sub");
	  	$email_desc = $this->input->post("email_desc");
	}
	$pg_type='';
	if(($pg=='excel' || $pg=='csv') || ($pg=='email' AND ($email_format ==3 || $email_format ==4))){
		$pg_type='sheet';
	}

	$where='';
	$where.="td.td_type='Billable' AND t.t_year='$year'";
	$whrs=[];
	$whrs['td.td_type']='Billable';
	$whrs['t.t_year']="$year";
	$rpt_file_name  = "";
	$rpt_file_name .="Billable_Timesheet"; $srcArr=[];
	
	if($e_id!="" AND $e_id!="All"){ $srcArr[]='E';
		$where.=" AND t.t_e_id='$e_id'";
		$empData=$this->model->LimitWheredata('CONCAT(e_first_name," ",e_last_name) AS e_name','tbl_employee',array('e_id'=>$e_id),'e_name ASC',1);
		$rpt_file_name .="_".$empData[0]['e_name'];
		$whrs['t.t_e_id']="$e_id";
	} 
	if($prj_id!="" AND $prj_id!="All"){ $srcArr[]='P';
		$projData=$this->model->sortingWheredata('prj_nm','tbl_prj_projects',array('prj_id'=>$prj_id),'prj_nm ASC');
		$prj_nm =$projData[0]['prj_nm'];
		$rpt_file_name.="_".str_replace(" ","_",str_replace("/","_",$prj_nm));
		$whrs['pa.prj_id']="$prj_id";
	}
	if($clnt_id!="" AND $clnt_id!="All"){ $srcArr[]='C';
		$clientData=$this->model->LimitWheredata('clnt_name','tbl_prj_clients',array('clnt_id'=>$clnt_id),'clnt_name ASC',1);
		$clnt_nm =explode(' ',trim($clientData[0]['clnt_name']));
		$rpt_file_name.="(".$clnt_nm[0].")";
		$where.=" AND c.clnt_id='$clnt_id'";
		$whrs['c.clnt_id']="$clnt_id";
	}
	if($pg_type=='sheet'){
	$file_name = $rpt_file_name; 
	$folder_name = date("Y");
	if (!file_exists(FCPATH . "assets/report_excel/".$folder_name)) {
	$pdfFilePath1 = mkdir(FCPATH . "assets/report_excel/".$folder_name, 0755, true);
	}
	$path_excel =  'assets/report_excel/'.$folder_name.'/';
	$attchmt_path = $path_excel;
	require 'vendor/autoload.php';
	$spreadsheet = new Spreadsheet();
	$sheet = $spreadsheet->getActiveSheet();
	}
	//---- REPORT HEADING ---
	$rpt_head =""; $head_line='';
	if(in_array('E', $srcArr)){ $rpt_head .= 'Employee : '.$empData[0]['e_name']; $head_line=' | ';}
	if(in_array('C', $srcArr)){ $rpt_head .= "$head_line Client : ".$clientData[0]['clnt_name']; 
	$head_line=' | ';}
	if(in_array('P', $srcArr)){ $rpt_head .= "$head_line Project : $prj_nm"; $head_line=' | '; }
	if($year!=""){ $rpt_head .= "$head_line Year : $year";}
	if($pg_type=='sheet'){
		$sheet->setCellValue('A1', 'Time Booked Report');
		$sheet->setCellValue('A2', $rpt_head);
	}
	$rpt_head = '<span style="font-size:18px;">Time Booked Report</span> <br/>'.$rpt_head;
	//----------------------
	$clientData=$this->ts->projtime_fun($where,'c.clnt_id');
	
	$tmData=$this->ts->projtime_fun($whrs,'t.t_e_id,td.td_client');
	//echo "<pre>"; print_r($tmData); echo "</pre>";die;
	foreach($tmData AS $i=>$k){
		$e_name = $k['employee_id']." - ".$k['e_name'];
		$t_month = $k['t_month'];
		$clnt_name = $k['clnt_name'];
		$prj_nm = $k['prj_nm'];
		$where_arr = array( 
			't_e_id'=> $k['e_id'],
			't_year'=> $k['t_year'],
			'td_client'=> $k['td_client'],
		);
		$reportData[$clnt_name][$prj_nm][$e_name]=$where_arr;
	}
	
	$month_array=array('january'=>'JAN', 'february'=>'FEB', 'march'=>'MAR', 'april'=>'APR', 'may'=>'MAY', 'june'=>'JUN', 'july'=>'JUL', 'august'=>'AUG', 'september'=>'SEP', 'october'=>'OCT', 'november'=>'NOV', 'december'=>'DEC', 'quarter_1'=>'Q1', 'quarter_2'=>'Q2', 'quarter_3'=>'Q3', 'quarter_4'=>'Q4', 'first_half'=>'1st', 'second_half'=>'2nd', 'yearly'=>'yearly');
	$month_list=''; $td_list=''; $col_cnt=array('quarter'=>0,'half'=>0,'month'=>0,'year'=>0);
	if(!isset($month)){ 
		$month = array_keys($month_array); // if not select any month in droup down -> display all month list
	}
	//--- MONTH TABLE HEADER DISPLAY ----
	$month_head_arr=[];
	foreach ($month as $month_nm) {
		$month_nms=$month_array["$month_nm"];
		if($month_nm!='yearly'){ $month_list.="<th>$month_nms</th>"; $month_head_arr[]=$month_nms; }
		$td_list.="<td class='class_$month_nm'></td>";
		//--- SELECTED MONTH COUNT FOR COLSPAN ---
		if($month_nm=='quarter_1' || $month_nm=='quarter_2' || $month_nm=='quarter_3' || $month_nm=='quarter_4'){
			$col_cnt['quarter']+=1; 
		}elseif($month_nm=='first_half' || $month_nm=='second_half'){
            $col_cnt['half']+=1;
		}elseif($month_nm=='yearly'){
			$col_cnt['year']+=1;
		}else{
			$col_cnt['month']+=1;
		}
	}
	//--- END: MONTH TABLE HEADER DISPLAY ----
	$colspan = '3';
	if(count($srcArr)==1){ $colspan = '2'; }
	if(count($srcArr)==2){ $colspan = '1'; }
	if(count($srcArr)==3){ $colspan = '0'; }
	$colspan = $colspan+(count($month));
	
	$result = '';
	$result .= "<style>
	.table-sm{border: 1px solid #848484; font-size:12px;}
	tbody tr td, tbody tr th, .table-sm tr th{
	padding: 0px 5px !important;
	font-size: 12px !important;
	border-top: 1px solid #848484;
	border-right: 1px solid #848484;
	}
	tbody tr .bt-none{border-top: none !important; }
	.class_quarter_1,.class_quarter_2,.class_quarter_3,.class_quarter_4{ background:#fbbfc5;}
	.class_first_half,.class_second_half{ background:#dafdab;}
	</style>";
	if($pg=='email'){ 
	$result .= "<div style='max-width: 900px;overflow: scroll;'><table border='1' style='font-size:12px;'  id='timebook_tbl' class='table-sm' cellspacing='0' >";
	}else{
	$result .= "<table  id='timebook_tbl' class='table-sm' cellspacing='0' >";
	}
	$result .= "<thead>
	<tr style='background-color: #90c2f9;'>
	<th colspan='$colspan' style='text-align:center;'>$rpt_head  </th>
	</tr>
	<tr style='background-color: #d2e7ff;'>";
	if($pg_type=='sheet'){
		$array_cell=array('A','B','C','D','E','F','G','H','I','J','K','L','M','N','O','P','Q','R','S','T','U','V','W','X','Y','Z');
		$sheet->getColumnDimension('A')->setAutoSize(true);
		$sheet->getColumnDimension('B')->setAutoSize(true);
		//echo $array_cell[$colspan];
		$head_1_Cell="A1:".$array_cell[$colspan-1]."1";
		$spreadsheet->setActiveSheetIndex(0)->mergeCells($head_1_Cell);
		$spreadsheet->getActiveSheet()->getStyle($head_1_Cell)->getFill()->setFillType(\PhpOffice\PhpSpreadsheet\Style\Fill::FILL_SOLID)->getStartColor()->setARGB('90C2F9');
		$spreadsheet->getActiveSheet()->getStyle($head_1_Cell)->getFont()->setBold(true);
		$spreadsheet->getActiveSheet()->getStyle($head_1_Cell)->getFont()->setSize(16);
		$sheet->getStyle('A1')->getAlignment()->setHorizontal('center');	
		$spreadsheet->getActiveSheet()->getRowDimension(1)->setRowHeight(24); // CELL HEIGHT	
		//------
		$head_1_Cell="A2:".$array_cell[$colspan-1]."2";
		$spreadsheet->setActiveSheetIndex(0)->mergeCells($head_1_Cell);
		$spreadsheet->getActiveSheet()->getStyle($head_1_Cell)->getFill()->setFillType(\PhpOffice\PhpSpreadsheet\Style\Fill::FILL_SOLID)->getStartColor()->setARGB('90C2F9');
		$spreadsheet->getActiveSheet()->getStyle($head_1_Cell)->getFont()->setBold(true);$spreadsheet->getActiveSheet()->getStyle($head_1_Cell)->getFont()->setSize(11);
		$sheet->getStyle('A2')->getAlignment()->setHorizontal('center');	
		$spreadsheet->getActiveSheet()->getStyle("A3:".$array_cell[$colspan-1]."3")->getFont()->setBold(true);
		$spreadsheet->getActiveSheet()->getStyle("A4:".$array_cell[$colspan-1]."4")->getFont()->setBold(true);
		$spreadsheet->getActiveSheet()->getStyle("A3:".$array_cell[$colspan-1]."3")->getFill()->setFillType(\PhpOffice\PhpSpreadsheet\Style\Fill::FILL_SOLID)->getStartColor()->setARGB('D2E7FF');
		$spreadsheet->getActiveSheet()->getStyle("A4:".$array_cell[$colspan-1]."4")->getFill()->setFillType(\PhpOffice\PhpSpreadsheet\Style\Fill::FILL_SOLID)->getStartColor()->setARGB('D2E7FF');
		$spreadsheet->getActiveSheet()->getStyle("A3:".$array_cell[$colspan-1]."3")->getBorders()->applyFromArray( [ 'allBorders' => [ 'borderStyle' => PhpOffice\PhpSpreadsheet\Style\Border::BORDER_THIN, 'color' => [ 'rgb' => 'a8bcd6' ] ] ] );
		$spreadsheet->getActiveSheet()->getStyle("A4:".$array_cell[$colspan-1]."4")->getBorders()->applyFromArray( [ 'allBorders' => [ 'borderStyle' => PhpOffice\PhpSpreadsheet\Style\Border::BORDER_THIN, 'color' => [ 'rgb' => 'a8bcd6' ] ] ] );
		$sheet->getStyle("A3:".$array_cell[$colspan-1]."3")->getAlignment()->setHorizontal('center');	
		$sheet->getStyle("A4:".$array_cell[$colspan-1]."4")->getAlignment()->setHorizontal('center');	
	}
	
	$cell_no=0;
	if(!in_array('C', $srcArr)){
		$result .="<th rowspan='2' style='max-width:200px; min-width:200px;'>Client</th>";
		if($pg_type=='sheet'){
		$sheet->setCellValue($array_cell[$cell_no]."3", 'Client'); 
		$spreadsheet->setActiveSheetIndex(0)->mergeCells($array_cell[$cell_no]."3:".$array_cell[$cell_no]."4");
		$cell_no++;
		}
	}
	if(!in_array('P', $srcArr)){
		$result .="<th rowspan='2' style='max-width:200px; min-width:200px;'>Project</th>";
		$tbl_head_arr[]='Project';
		if($pg_type=='sheet'){
		$sheet->setCellValue($array_cell[$cell_no]."3", 'Project'); 
		$spreadsheet->setActiveSheetIndex(0)->mergeCells($array_cell[$cell_no]."3:".$array_cell[$cell_no]."4");
		$cell_no++;
		}
	}
	if(!in_array('E', $srcArr)){
		$result .="<th rowspan='2' style='max-width:200px; min-width:200px;'>Employee</th>";
		$tbl_head_arr[]='Employee';
		if($pg_type=='sheet'){
		$sheet->setCellValue($array_cell[$cell_no]."3", 'Employee'); 
		$spreadsheet->setActiveSheetIndex(0)->mergeCells($array_cell[$cell_no]."3:".$array_cell[$cell_no]."4");
		$cell_no++;
		}
	}
	$last_cell=$cell_no;
	foreach ($month as $month_nm) {
		if($pg_type=='sheet'){ if($month_nm!='yearly'){ 
		$sheet->setCellValue($array_cell[$last_cell]."4", $month_array["$month_nm"]);  $last_cell++; 
		} }
	}
	
	if($col_cnt['month']>0){
		$result.="<th colspan='".$col_cnt['month']."'>Monthly</th>";
		if($pg_type=='sheet'){
		$sheet->setCellValue($array_cell[$cell_no]."3", 'Monthly');  
		$cols=$cell_no+$col_cnt['month']-1;
		$spreadsheet->setActiveSheetIndex(0)->mergeCells($array_cell[$cell_no]."3:".$array_cell[$cols]."3");
		$cell_no=$cols+1;
		}
	}
	if($col_cnt['quarter']>0){
		$result.="<th colspan='".$col_cnt['quarter']."'>Quarterly</th>";
		if($pg_type=='sheet'){
		$sheet->setCellValue($array_cell[$cell_no]."3", 'Quarterly');  
		$cols=$cell_no+$col_cnt['quarter']-1;
		$spreadsheet->setActiveSheetIndex(0)->mergeCells($array_cell[$cell_no]."3:".$array_cell[$cols]."3");
		$cell_no=$cols+1;
		}
	}
	if($col_cnt['half']>0){
		$result.="<th colspan='".$col_cnt['half']."'>Half Yearly</th>";
		if($pg_type=='sheet'){
		$sheet->setCellValue($array_cell[$cell_no]."3", 'Half Yearly');  
		$cols=$cell_no+$col_cnt['half']-1;
		$spreadsheet->setActiveSheetIndex(0)->mergeCells($array_cell[$cell_no]."3:".$array_cell[$cols]."3");
		$cell_no=$cols+1;
		}
	}
	if($col_cnt['year']>0){
		$result.="<th rowspan='2'>Yearly</th>";
		if($pg_type=='sheet'){
		$sheet->setCellValue($array_cell[$cell_no]."3", 'Yearly');  
		$spreadsheet->setActiveSheetIndex(0)->mergeCells($array_cell[$cell_no]."3:".$array_cell[$cell_no]."4");
		$cell_no++;
		}
	}
	$result.="</tr>";
	$result.="</tr>
	<tr style='background-color: #d2e7ff;'>$month_list</tr>
	</thead><tbody>
	";
	if(Count($tmData) <= 0){
		$result =  '<div class="text-danger text-center font-600">No data available.</div>';
	}else{
		$n=0; $sum1=0;  $row=4; 
		foreach($reportData as $client=>$arr1){ $n++;
			$tr_c=''; $c_arr=[]; $clm=0;
			if(!in_array('C', $srcArr)){$row++;
			 	$tr_c="<td class='bt-none'></td>";
				$result .="<tr style=' border-top:2px solid #ada8a8;'><td class='hd_brd' style='max-width:200px; min-width:200px;'>$client</td>";
				if($pg_type=='sheet'){ $sheet->setCellValue($array_cell[$clm].$row, $client); }
				$clm++;
				if(count($srcArr)==0){ $result .="<td></td><td></td>"; }
				if(count($srcArr)==1){ $result .="<td></td>"; } 
				if(count($srcArr)==2){ $result .=""; }
				if(in_array('P', $srcArr) AND in_array('E', $srcArr)){
					$result .="";
				}else{
					$result .="$td_list</tr>";
				}
			}else{ $clm=0; }
			$sum2=0;
			foreach($arr1 as $prj=>$arr2){ 
				$tr_m='';
				if(!in_array('P', $srcArr)){ $row++; 
				if(count($srcArr)>=2){ $clm=0; }else{  if($tr_c!=""){$clm=1;} } 
				$tr_m="<td class='bt-none'></td>";
				$result .="<tr>$tr_c<td class='hd_brd hd2' style='max-width:200px; min-width:200px;'>$prj</td> ";
				if($pg_type=='sheet'){ $sheet->setCellValue($array_cell[$clm].$row, $prj); } 
				$clm++;
				if(count($srcArr)==1){
					if(in_array('C', $srcArr)){
					//$result .="<td class='hd2'></td><td class='hd2'></td>";
					}else{
					$result .="";	
					}
				}
				if(in_array('P', $srcArr)){
					$result .="";
				}else{
					if((in_array('E', $srcArr)) || (in_array('E', $srcArr) AND in_array('C', $srcArr))){
						$result .="";
					}else{
						$result .="<td class='hd2'></td>$td_list</tr>";
					}
				}
				
				}else{ $clm=0;}
				$sum3=0; $m_td=[];
				foreach($arr2 as $emp=>$arr3){ 
				if($pg_type=='sheet'){
				if(!in_array('E', $srcArr) ){ $row++; 
				if(count($srcArr)==2){ $clm=0; }else{ $clm=1; } 
				$sheet->setCellValue($array_cell[$clm].$row, $emp);  
				$clm++;
				} }
					$tmData=$this->model->sortingWheredata('*','view_project_book_working_hrs',$arr3);
					$month_clm=''; if(count($srcArr)==3){$row++; }
					foreach ($month as $fd => $val) { 
					$month_clm .="<td class='class_$val'>".$tmData[0]["$val"]."</td>";
					$m_td[]=$tmData[0]["$val"];
					if($pg_type=='sheet'){ $sheet->setCellValue($array_cell[$clm].$row, $tmData[0]["$val"]); $clm++; }
					}

					$tr_e='';

					if(!in_array('E', $srcArr) ){ 
					$tr_e="<td class='bt-none'></td>";
					$result .="<tr>$tr_c $tr_m<td class='hd_brd hd3' style='max-width:200px; min-width:200px;' >$emp</td>$month_clm</tr>"; $clm=0;
					//$array_excel[]=array_filter(array_merge(array($tr_c, $tr_m),$emp,$m_td));
					
					}
					
				} // $arr2
				if((!in_array('P', $srcArr) AND in_array('E', $srcArr)) || (!in_array('P', $srcArr) AND in_array('E', $srcArr) AND in_array('C', $srcArr))){
					$result .="$month_clm</tr>"; $clm=0;
					//$array_excel[]=$m_td;
				}

				
					

			} // $arr1
			if(in_array('P', $srcArr) AND in_array('E', $srcArr)){
					$result .="$month_clm</tr>"; $clm=0;
				}
			
		} // $reportData
	}
		


	$result .= "</tbody></table>";
	if($pg=='email'){ 
	$result .= "</div>";
	}
	
	//echo "<pre>"; print_r($array_excel); echo "</pre>"; 
	//--------
	if($pg=="search"){
		 	 
		echo $result;
	} 
	
	if($pg=='email'){
		
	  	if($email_format ==1){	 
   			$email_msg=$email_desc."<br/>".$result; 
   			//$this->model->emailSendFormat($email_to, $email_sub, $email_msg);
   		} 
		
	}

	if($pg=='pdf' || ($pg=='email' AND $email_format ==2)){
		//echo $result;
		include_once APPPATH . '/third_party/vendor/autoload.php';
		$pdf = new \Mpdf\Mpdf();
		$pdf->AddPage('L','', '', '', '', 5,5,5,5,5,5);
		$pdf->WriteHTML($result);
		$folder_name = date("Y");
		if (!file_exists(FCPATH . "assets/report_pdf/".$folder_name)) {
		$pdfFilePath1 = mkdir(FCPATH . "assets/report_pdf/".$folder_name, 0755, true);
		}
		$PDFname=$rpt_file_name.date("_d_m_Y_h_i_s").".pdf";
		$path_pdf =  'assets/report_pdf/'.$folder_name.'/';
		$pdf->Output(FCPATH.$path_pdf.$PDFname,'F');
		if($pg=='email'){
			$attchmt_file = $PDFname;
			$attchmt_path = $path_pdf;
			$this->model->emailSendFormat($email_to, $email_sub, $email_desc,$regard='NULL',$topmenu='not',$from="NULL",$cc=array(),$attchmt_file,$attchmt_path);
		}else{
			echo ''.base_url().$path_pdf.$PDFname; 
		}  
	}
	if(($pg=='excel' || $pg=='csv') || ($pg=='email' AND ($email_format ==3 || $email_format ==4))){
		
		$savefilepath='';	
		if($pg=='excel' || $email_format ==3){
		//$attchmt_file = "HRMS.xlsx";
		$attchmt_file = "$file_name".date("_d_m_Y_h_i_s").".xlsx";
		$writer = new Xlsx($spreadsheet);
		$writer->save($path_excel.$attchmt_file);
		$savefilepath= base_url().$path_excel.$attchmt_file;
		}
		//----- CSV CODE -------
		if($pg =='csv' ||  $email_format ==4){
		$attchmt_file = "$file_name".date("_d_m_Y_h_i_s").".csv";
		$writer = new \PhpOffice\PhpSpreadsheet\Writer\Csv($spreadsheet);
		$writer->save($path_excel.$attchmt_file);
		$savefilepath= base_url().$path_excel.$attchmt_file;
		}
		if($pg=='email'){
			$this->model->emailSendFormat($email_to, $email_sub, $email_desc,$regard='NULL',$topmenu='not',$from="NULL",$cc=array(),$attchmt_file,$path_excel);
			
		}else{
			echo $savefilepath; 
		}
		  
			
	}
	
	

	}else{
		echo "<h4 class='text-danger font-18 text-center mt-5'>Your Session has been expired. Click here to login again.<br/>
		<a href='".base_url()."welcome/login' class='btn btn-sm btn-primary mt-2'> Login </a>
		</h4>";
	}

	}
	
	//------ CLIENT WISE REPORT -----------
	public function client_wise_time_report(){
		$whr="e.e_delete=0 AND e.e_id IN (SELECT t_e_id FROM tbl_timesheet)";
		$data["empallData"]=$this->hr->employee_details($whr);
		$data['timsheetData']=$this->ts->timesheet_report_search();
		$data['projData']=$this->model->sortingWheredata('*','tbl_prj_projects',$where='NULL','prj_nm ASC');
		$data['clientData']=$this->model->sortingWheredata('*','tbl_prj_clients',$where='NULL','clnt_name ASC');
		$data["view"]="report/timesheet/client_wise_time_report";
		$this->load->view("layout",$data); 
	}
	
    function timesheet_report_list_client(){
	$session_data=$this->session->userdata('loginData');
		  
	if(isset($session_data) AND $session_data!=""){
		$data['post_data']=$_POST;
		$clnt_id = $this->input->post('clnt_id');
		$e_id = $this->input->post('e_id');
		$month = $this->input->post('month');
		$year = $this->input->post('year');
		$prj_id = $this->input->post('prj_id');
		$rpt_file_name  = "";
		$rpt_file_name .="Timesheet";
		if($month!="" AND $month!="All"){
			$rpt_file_name .="_".date('M-Y',strtotime("01-$month-$year"));
		}
		if($e_id!=""){
			$empData=$this->model->LimitWheredata('CONCAT(e_first_name," ",e_last_name) AS e_name','tbl_employee',array('e_id'=>$e_id),'e_name ASC',1);
			$rpt_file_name .="_".$empData[0]['e_name'];
		}
		if($prj_id!=""){
			$projData=$this->model->sortingWheredata('prj_nm','tbl_prj_projects',array('prj_id'=>$prj_id),'prj_nm ASC');
			$prj_nm =$projData[0]['prj_nm'];
			$rpt_file_name.="_".str_replace(" ","_",str_replace("/","_",$prj_nm));
		}

		if($clnt_id!=""){
			$clientData=$this->model->LimitWheredata('clnt_name','tbl_prj_clients',array('clnt_id'=>$clnt_id),'clnt_name ASC',1);
			$clnt_nm =explode(' ',trim($clientData[0]['clnt_name']));
			$rpt_file_name.="(".$clnt_nm[0].")";
		}

		$this->model->search_session("post_data",array_merge($_POST,array('rpt_file_name'=>$rpt_file_name)));
		
		$this->load->view("report/timesheet/client_wise_time_report_list",$data); 
		}else{
			echo "<h4 class='text-danger font-18 text-center mt-5'>Your Session has been expired. Click here to login again.<br/>
			<a href='".base_url()."welcome/login' class='btn btn-sm btn-primary mt-2'> Login </a>
			</h4>";
		}
    }

    public function download_pdf_client(){
    	$post_data=$this->session->userdata('post_data');
    	$file_name = $post_data['rpt_file_name'];
		$data['post_data']=$post_data;
		include_once APPPATH . '/third_party/vendor/autoload.php';
		$pdf = new \Mpdf\Mpdf();
		$pdf->AddPage('P','', '', '', '', 5,5,5,5,5,5); 
		$html2 = $this->load->view("report/timesheet/client_wise_time_report_pdf",$data, true);
		$pdf->WriteHTML($html2);
		$PDFnames=$file_name.".pdf";
		$pdf->Output("$PDFnames", "D");
		//--- LOG ---
		//$log_txt = "Download File : $PDFnames";
		//$ins_arr=$this->model->history_module('',"download_timesheet|Download PDF","",$log_txt,'tbl_timesheet','Client Wise Timesheet Report','download');
		//$this->model->insertData("tbl_update_history",$ins_arr);
		//--- /.LOG ---
		
	} 
	
	public function Billable_report_search($pg=''){
	//echo "<pre>"; print_r($_POST); echo "</pre>";
	$session_data=$this->session->userdata('loginData');
	if(isset($session_data) AND $session_data!=""){
	
		$data['post_data']=$_POST;
		$e_id = $this->input->post('e_id');
		$month = $this->input->post('month');
		$year = $this->input->post('year');
		$clnt_id = $this->input->post('clnt_id');
		$prj_id = $this->input->post('prj_id');
		$where='';
		$where.="td.td_type='Billable' AND t.t_year='$year'";
		$rpt_file_name  = "";
		$rpt_file_name .="Billable_Timesheet"; $srcArr =[];
	if($month!="" AND $month!="All"){ $srcArr[]='M';
		$rpt_file_name .="_".date('M-Y',strtotime("01-$month-$year"));
		$where.=" AND t.t_month='$month'";
	}
	if($e_id!="" AND $e_id!="All"){  $srcArr[]='E';
		$where.=" AND t.t_e_id='$e_id'";
		$empData=$this->model->LimitWheredata('CONCAT(e_first_name," ",e_last_name) AS e_name','tbl_employee',array('e_id'=>$e_id),'e_name ASC',1);
		$rpt_file_name .="_".$empData[0]['e_name'];

	}
	if($prj_id!="" AND $prj_id!="All"){ $srcArr[]='P';
		$projData=$this->model->sortingWheredata('prj_nm','tbl_prj_projects',array('prj_id'=>$prj_id),'prj_nm ASC');
		$prj_nm =$projData[0]['prj_nm'];
		$rpt_file_name.="_".str_replace(" ","_",str_replace("/","_",$prj_nm));
		//$whrs['pa.prj_id']="$prj_id";
		$where.=" AND pa.prj_id='$prj_id'";
	}
	
	if($clnt_id!=""){  $srcArr[]='C';
		$clientData=$this->model->LimitWheredata('clnt_name','tbl_prj_clients',array('clnt_id'=>$clnt_id),'clnt_name ASC',1);
		$clnt_nm =explode(' ',trim($clientData[0]['clnt_name']));
		$rpt_file_name.="(".$clnt_nm[0].")";
		$where.=" AND c.clnt_id='$clnt_id'";
	}
	
	$tmData=$this->ts->billable_fun($where);
	//echo "<pre>";print_r($tmData);echo "</pre>";die;
	//echo "month_div:$month_div";
	foreach($tmData AS $i=>$k){
		$e_name = $k['employee_id']." - ".$k['e_name'];
		$t_month = $k['t_month'];
		$clnt_name = $k['clnt_name'];
		$prj_nm = $k['prj_nm'];
		$where_arr = array( 
			't.t_id'=>$k['t_id'], 
			'c.clnt_id'=> $k['clnt_id'],
			'pr.prj_id'=> $k['prj_id'],
			't.t_month'=> $k['t_month'],
		);
		$reportData[$clnt_name][$t_month][$e_name][$prj_nm]=$where_arr;
	}
	//echo "<pre>";print_r($reportData);echo "</pre>";
	$result = ''; $array_excel=[]; $grand_ttl=0;
	if(Count($tmData) <= 0){
		$result =  '<div class="text-danger text-center font-600">No data available.</div>';
	}else{
		$result .= "<style>.table-sm tr .bt-none{border-top: none !important;}
		.hd_brd{border-bottom: 1px solid #abc6dc;}
		.table-sm{ border: 1px solid #abc6dc; }
		.table-sm td, .table-sm th {
		padding: 0px 5px;
		font-size: 12px;
		border-top: 1px solid #abc6dc;
		border-left: 1px solid #abc6dc;
		border-right: 1px solid #abc6dc;
		}
		.text-blue{color: #003aaf !important;}
		.table-sm td, .table-sm th {padding: 2px 5px;font-size: 12px;}
		.table-sm .th_head th {background: #cee0f5;}
		
		.hd2{ background:#dfe4e8;}
		/*.hd3{ background:#b9bfc5;}
		.hd4{ background:#e0e1e2;}*/
		</style>
		<input type='hidden' name='rpt_file_name' value='$rpt_file_name'/>";
		$width="";
		if($pg=='pdf' || ($pg=='email' AND $email_format ==2)){
			$width="width:100%";
		}
		if($pg =='email'){
		$result .= "<table id='example' class='table-sm'  style='$width' border='1'   cellspacing='0' >";
		}else{
		$result .= "<table id='example' class='table-sm'  style='$width'  cellspacing='0' >";	
		}
		
		
		$clm="<th class='bt-none'></th>";
		$tbl_head=''; $tbl_head_arr=[];
		$tbl_head .='<tr class="th_head" style="background: #ebf0f7;">';
		$cell_arr=[];
		if(!in_array('C', $srcArr)){
			$tbl_head .='<th>Client</th>';
			$tbl_head_arr[]='Client';
			
		}
		if(!in_array('M', $srcArr)){
			$tbl_head .='<th>Month</th>';
			$tbl_head_arr[]='Month';	
		}
		if(!in_array('E', $srcArr)){
			$tbl_head .='<th>Employee</th>';
			$tbl_head_arr[]='Employee';	
		}
		if(!in_array('P', $srcArr)){
			$tbl_head .='<th style="min-width:150px">Project Name</th>';
			$tbl_head_arr[]='Project Name';	
		}
		
		

		
	
		$rpt_head=""; $head_line="";
		if(in_array('E', $srcArr)){
			$rpt_head .= ' Employee : '.$empData[0]['e_name'];
			$head_line=" | ";
			
		}
		if(in_array('C', $srcArr)){
			$rpt_head .= "$head_line Client : ".$clientData[0]['clnt_name'];
			$head_line=" | ";
		}
		if(in_array('P', $srcArr)){
			$rpt_head .= "$head_line Project : $prj_nm";
			$head_line=" | ";
		}
		
		if(in_array('M', $srcArr)){
			$rpt_head .= "$head_line Month-Year : ".date('M-Y',strtotime("01-$month-$year"));
		}else{
			$rpt_head .= "$head_line Year : $year";
		}
		
		
	
		
		$colspan=6;
		if(count($srcArr)==1){
			$colspan=6;
		}
		if(count($srcArr)==2){
			$colspan=5;
		}
		if(count($srcArr)==3){
			$colspan=4;
		}
		if(count($srcArr)==4){
			$colspan=3;
		}
		$tbl_head .='
		<th style="width:85px">Date</th>
		<th>Activity</th>
		<th style="width:80px;white-space: nowrap;">Working Hrs</th>
		</tr>';
		//$tbl_head_arr[]='Project Name';
		$tbl_head_arr[]='Date';
		$tbl_head_arr[]='Activity';
		$tbl_head_arr[]='Working Hrs';
		$tbl_head_arr["bg_color"]='D2E7FF';
		
		$n=0; $sum1=0;
		$result .="<thead><tr style='background-color: #90c2f9;'><th colspan='$colspan' style='font-size: 13px;text-align:center;'> <span style='font-size:18px;'>Billable Timesheet Report</span> <br/> $rpt_head</th></tr>"; 
				$result .= $tbl_head;
				$result .= '</thead>';
				$array_excel['title'][]='Billable Timesheet Report';
				$array_excel['sub_title'][]=$rpt_head;
				$array_excel['tbl_head']=$tbl_head_arr;
		$result .= '<tbody>';		
		foreach($reportData as $client=>$arr1){ $n++;
			/*if($n==1){ // HEADING
				$result .="<thead><tr style='background-color: #90c2f9;'><th colspan='$colspan' style='font-size: 13px;text-align:center;'> <span style='font-size:18px;'>Billable Timesheet Report</span> <br/> $rpt_head</th></tr>"; 
				$result .= $tbl_head;
				$result .= '</thead>';
				$array_excel['title'][]='Billable Timesheet Report';
				$array_excel['sub_title'][]=$rpt_head;
				$array_excel['tbl_head']=$tbl_head_arr;
			}*/
			 $tr_c=''; 
			if(!in_array('C', $srcArr)){ 
			 	$tr_c="<th class='bt-none'></th>";
				$result .="<tr style='background: #FFEEBA;'><th class='hd_brd' style='white-space: nowrap;'>$client</th>";
				 
				if(count($srcArr)==1){
				$result .="<td></td><td></td>";
				$array_excel[]=array($client,"","","","","bg_color"=>'FFEEBA','font'=>'bold'); //,"bg_color"=>"FFEEBA"
				}
				if(count($srcArr)==2){
				$result .="<td></td>";
				$array_excel[]=array($client,"","","","bg_color"=>'FFEEBA','font'=>'bold'); //,"bg_color"=>"FFEEBA"
				}
				if(count($srcArr)==3){
				$result .="";
				$array_excel[]=array($client,"","",'font'=>'bold'); //,"bg_color"=>"FFEEBA"
				}
				$result .="<td></td><td></td><td></td></tr>";
				
			}
			$sum2=0;
			foreach($arr1 as $months=>$arr2){ 
				$tr_m=''; 
				if(!in_array('M', $srcArr)){
				$tr_m="<th class='bt-none'></th>"; 
				$result .="<tr>$tr_c<th class='hd_brd hd2' style='white-space: nowrap;'>".date('F-Y',strtotime("01-$months-$year"))."</th> ";
				
				$array_excel[]=array_filter(array($tr_c,"month"=>date('F-Y',strtotime("01-$months-$year")),"","","",'font'=>'bold')); //,"bg_color"=>"8798ab"
				
				
				if(count($srcArr)==1){
					if(in_array('C', $srcArr)){
					$result .="<td class='hd2'></td><td class='hd2'></td>";
					//$array_excel[]=array("","");
					}else{
					$result .="<td class='hd2'></td>";	
					//$array_excel[]="";
					}
				}
				if(count($srcArr)==2){
					if(!in_array('P', $srcArr)){
					$result .="<td class='hd2'></td>";	
					}
					if(!in_array('E', $srcArr)){
					$result .="<td class='hd2'></td>";	
					}
					//$array_excel[]="";
				}
				//if(count($srcArr)==3){
					//if(!in_array('P', $srcArr)){
					//$result .="<td class='hd2'></td><td class='hd2'></td>";	
					//}
					//$array_excel[]="";   
				//}
				
				$result .="<td class='hd2'></td><td class='hd2'></td><td class='hd2'></td></tr>";
				//$array_excel[]=array("","","");
				
				
				}
				$sum3=0;
				foreach($arr2 as $emp=>$arr3){ 
					$tr_e='';
					if(!in_array('E', $srcArr)){
					$tr_e="<th class='bt-none'></th>"; 
					$result .="<tr>$tr_c $tr_m<th class='hd_brd hd3' style='white-space: nowrap;'>$emp</th>";
					//if(!in_array('P', $srcArr)){ $result .="<td class='hd3'></td>"; }
					//$result .="<td class='hd3'></td><td class='hd3'></td><td class='hd3'></td><td class='hd3'></td><td class='hd3'></td><td class='hd3'></td>";
					if(in_array('P', $srcArr)){ $result .="<td class='hd3'></td><td class='hd3'></td><td class='hd3'></td></tr>";}
					$array_excel[]=array_filter(array($tr_c, $tr_m,$emp,'font'=>'bold')); //,"bg_color"=>"b9bfc5"
					}
					$sum4=0; $p=0;
					foreach($arr3 as $prj=>$arr4){  $p++;
					$tr_p='';
						if(!in_array('P', $srcArr)){ 
						$tr_p="<th class='bt-none'></th>";
						if(!in_array('E', $srcArr) AND $p==1){
						$result .="<th class='hd_brd hd4' style='white-space: nowrap;'>$prj</th><td class='hd4'></td><td class='hd4'></td><td class='hd4'></td></tr>";
						}else{
						$result .="<tr>$tr_c $tr_m $tr_e<th class='hd_brd hd4' style='white-space: nowrap;'>$prj</th><td class='hd4'></td><td class='hd4'></td><td class='hd4'></td></tr>";
						}
						//$array_excel[]=array($prj);
						$array_excel[]=array_filter(array($tr_c, $tr_m, $tr_e,$prj,'font'=>'bold')); //,"bg_color"=>"e0e1e2"
						}
						//foreach($arr4 as $t=>$arr5){ 
							$arr = [];
							$sum5=0;
							$proj_tmData=$this->ts->tm_data_list($arr4);
							//echo "<pre>";print_r($t);echo "</pre>";
							foreach($proj_tmData AS $k1=>$k){ 
								$tr_cls ='';
								if(in_array($k['td_date'],$arr)){
									$tr_cls ='bt-none';
									$td_cls ='display_none';
									$td_date="";
								}else{
									$td_date=date('d-M-Y',strtotime($k['td_date']));
									//$tr_cls ='border-top: none;';
									$arr[] =$k['td_date'];
								} 
								$result .="<tr>
								$tr_c $tr_m $tr_e $tr_p
								<td class='$tr_cls' style='white-space:nowrap'>$td_date</td>
								
								<td>".htmlspecialchars($k['td_activity'])."</td>
								<td>".$k['td_working_hrs']."</td> 
								</tr>";
								
									
								$array_excel[]=array_merge(array_filter(array($tr_c, $tr_m, $tr_e, $tr_p)),array($td_date,htmlspecialchars($k['td_activity']),$k['td_working_hrs']));
								
								 
								$working_hrs=$k['td_working_hrs'];
								$sum1 +=$working_hrs;
								$sum2 +=$working_hrs;
								$sum3 +=$working_hrs;
								$sum4 +=$working_hrs;
								$sum5 +=$working_hrs;
							} 
							if(count($proj_tmData) > 1 && $sum5!=0){
							$result.= "<tr>$tr_c $tr_m $tr_e $tr_p<th colspan='2' style='text-align:right;'>TOTAL</td><th>$sum5</th></tr>";
							$array_excel[]=array_filter(array($tr_c, $tr_m, $tr_e, $tr_p, "TOTAL", $sum5));
							}
						/*$tr_p='';
						if(!in_array('E', $srcArr)){
						$tr_p='<th></th>';
						$result .="<tr>$tr_c $tr_m $tr_e<th style='white-space: nowrap;'>$prj</th><td colspan='5'></td></tr>";
						}*/
						//} // $arr4
					} // $arr3 
					//$tr_cell=[]; 
					if(count($arr3) > 1 && $sum4!=0 && $sum5 !=$sum4){
					$result.= "<tr class='hd_brd'>$tr_c $tr_m $tr_e $tr_p <th colspan='2' style='text-align:right;'> TOTAL</td><th>$sum4</th></tr>";
					$array_excel[]=array_filter(array($tr_c, $tr_m, $tr_e, $tr_p, "TOTAL", $sum4));
					}
				} // $arr2
				//$tr_cell=[]; 
				/*if(!in_array('M', $srcArr)){
				if(count($arr2) > 1 && $sum3!=0 && $sum4 !=$sum2){ 
					if($tr_c!=""){ $tr_c="<th class='bt-none' style='background:#fff;'></th>";}
				$result.= "<tr class='table-info hd_brd'>$tr_c $tr_m $tr_e $tr_p <th colspan='2' style='text-align:right;'>Monthly TOTAL</td><th>$sum3</th></tr>";
				}
				}*/

			} // $arr1
			
			if(count($arr1) > 1 && $sum2!=0 && $sum3 !=$sum2){
				if(count($reportData) <= 1){ $grand_ttl=1;
				$result.= "<tr style='background-color: #f5c6cb;border-top:1px solid #abc6dc'>$tr_c $tr_m $tr_e $tr_p 
				<th colspan='2' style='text-align:right;'>GRAND TOTAL </td>
				<th>$sum2</th></tr>";
				$array_excel[]=array_filter(array($tr_c, $tr_m, $tr_e, $tr_p, "GRAND TOTAL", $sum2,'bg_color'=>'f5c6cb'));
				}else{  $grand_ttl=2;
				$result.= "<tr class='hd_brd'>$tr_c $tr_m $tr_e $tr_p 
				<th colspan='2' style='text-align:right;'>TOTAL </td>
				<th>$sum2</th></tr>";
				$array_excel[]=array_filter(array($tr_c, $tr_m, $tr_e, $tr_p, "TOTAL", $sum2));
				}
				
				}
			

		} // $reportData
		if((count($reportData) > 1 && $sum1!=0 && $sum1 !=$sum2) || ($grand_ttl==0 && $sum1!=0 && $sum1 !=$sum2)){
		$result.= "<tr style='background-color: #f5c6cb;border-top:1px solid #abc6dc'>$tr_c $tr_m $tr_e $tr_p<th colspan='2' style='text-align:right;'>GRAND TOTAL</td><th>$sum1</th></tr>";
		$array_excel[]=array_filter(array($tr_c, $tr_m, $tr_e, $tr_p, "GRAND TOTAL", $sum1,'bg_color'=>'f5c6cb'));
		}
		$result .= '</tbody>';
		$result .= "</table>";

	} // Count($tmData)
	
	//echo "<pre>"; print_r($array_excel); echo "</pre>"; 
	//--------
	if($pg=="search"){
		 	 
		echo $result;
	} 
	$email_format=0;
	if($pg=='email'){
		$email_format = $this->input->post("email_format");
	  	$email_to = $this->input->post("email_to");
	  	$email_sub = $this->input->post("email_sub");
	  	$email_desc = $this->input->post("email_desc");
		
	  	if($email_format ==1){	 
   			$email_msg=$email_desc."<br/>".$result; 
   			$this->model->emailSendFormat($email_to, $email_sub, $email_msg);
   		} 
		
	}

	if($pg=='pdf' || ($pg=='email' AND $email_format ==2)){
		
		include_once APPPATH . '/third_party/vendor/autoload.php';
		$pdf = new \Mpdf\Mpdf();
		$pdf->AddPage('P','', '', '', '', 5,5,5,5,5,5);
		$pdf->WriteHTML($result);
		$folder_name = date("Y");
		if (!file_exists(FCPATH . "assets/report_pdf/".$folder_name)) {
		$pdfFilePath1 = mkdir(FCPATH . "assets/report_pdf/".$folder_name, 0755, true);
		}
		$PDFname=$rpt_file_name.date("_d_m_Y_h_i_s").".pdf";
		$path_pdf =  'assets/report_pdf/'.$folder_name.'/';
		$pdf->Output(FCPATH.$path_pdf.$PDFname,'F');
		if($pg=='email'){
			$attchmt_file = $PDFname;
			$attchmt_path = $path_pdf;
			$this->model->emailSendFormat($email_to, $email_sub, $email_desc,$regard='NULL',$topmenu='not',$from="NULL",$cc=array(),$attchmt_file,$attchmt_path);
		}else{
			echo ''.base_url().$path_pdf.$PDFname; 
		} 
	}
	if(($pg=='excel' || $pg=='csv') || ($pg=='email' AND ($email_format ==3 || $email_format ==4))){
		$file_name = $rpt_file_name; 
		$folder_name = date("Y");
		if (!file_exists(FCPATH . "assets/report_excel/".$folder_name)) {
		$pdfFilePath1 = mkdir(FCPATH . "assets/report_excel/".$folder_name, 0755, true);
		}
		$path_excel =  'assets/report_excel/'.$folder_name.'/';
		$attchmt_path = $path_excel;
		require 'vendor/autoload.php';
		$spreadsheet = new Spreadsheet();
		$sheet = $spreadsheet->getActiveSheet();
		$row_no=0; $cell_mrg=[];
		$clarr=array('A','B','C','D','E','F','G','H');
		for($cl=0;$cl<=(count($array_excel['tbl_head'])-2);$cl++){
			//echo "<br/>".$clarr[$cl]."--".$cl."==>".$array_excel['tbl_head'][$cl];
			if($array_excel['tbl_head'][$cl]==='Activity'){
				//echo "call";
				$spreadsheet->getActiveSheet()->getStyle($clarr[$cl].'1:'.$clarr[$cl].$spreadsheet->getActiveSheet()->getHighestRow())->getAlignment()->setWrapText(true);
				$spreadsheet->getActiveSheet()->getColumnDimension($clarr[$cl])->setWidth(60);
			}else{
				$sheet->getColumnDimension($clarr[$cl])->setAutoSize(true);
			}
		}
		//die;
		//$sheet->getColumnDimension('B')->setAutoSize(true);
		//$sheet->getColumnDimension('C')->setAutoSize(true);
		//$sheet->getColumnDimension('D')->setAutoSize(true);
		
		
			foreach($array_excel AS $cell_hd=>$arr_cell){
				$row_no++; $cell_no=0;
				$endCell = $this->model->Arr_cell($row_no,(count($array_excel['tbl_head'])-2)); 
				
				//echo "<br/>-----------------------------------------------------------<br/>";
				foreach($arr_cell AS $ex_head=>$cell_val){ 
				$cellName = $this->model->Arr_cell($row_no,$cell_no);
				$cellName_pre = $this->model->Arr_cell($row_no,$cell_no+1);
				//$spreadsheet->getActiveSheet()->getStyle("$cellName")->getBorders()->applyFromArray( [ 'allBorders' => [ 'borderStyle' => PhpOffice\PhpSpreadsheet\Style\Border::BORDER_THIN, 'color' => [ 'rgb' => '808080' ] ] ] );
				//echo "$cellName | $cell_val";
				if($cell_val==='TOTAL' || $cell_val==='GRAND TOTAL'){
					$spreadsheet->getActiveSheet()->getStyle("A$row_no:$endCell")->getFont()->setBold(true);
					$sheet->getStyle("A$row_no:$endCell")->getAlignment()->setHorizontal('right');	
					$spreadsheet->getActiveSheet()->getStyle("$cellName:$endCell")->getBorders()->applyFromArray( [ 'allBorders' => [ 'borderStyle' => PhpOffice\PhpSpreadsheet\Style\Border::BORDER_THIN, 'color' => [ 'rgb' => 'A8BCD6' ] ] ] );
					$spreadsheet->setActiveSheetIndex(0)->mergeCells("$cellName:$cellName_pre");	
					$sheet->getStyle($cellName)->getAlignment()->setHorizontal('right');
					$cell_no++;
					
				}else{
					$sheet->getStyle($cellName)->getAlignment()->setHorizontal('left');
				}
				if($ex_head==='font'){
					if($cell_val==='bold'){
					$spreadsheet->getActiveSheet()->getStyle("A$row_no:$endCell")->getFont()->setBold(true);
					}
				}elseif($ex_head==='bg_color'){
					$spreadsheet->getActiveSheet()->getStyle("A$row_no:$endCell")->getFill()->setFillType(\PhpOffice\PhpSpreadsheet\Style\Fill::FILL_SOLID)->getStartColor()->setARGB($cell_val);
					$spreadsheet->getActiveSheet()->getStyle("A$row_no:$endCell")->getFont()->setBold(true);
					$spreadsheet->getActiveSheet()->getStyle("A$row_no:$endCell")->getBorders()->applyFromArray( [ 'allBorders' => [ 'borderStyle' => PhpOffice\PhpSpreadsheet\Style\Border::BORDER_THIN, 'color' => [ 'rgb' => 'A8BCD6' ] ] ] );
				}else{
					if($cell_val!=""){ 
						if($ex_head==='month'){ 
						$spreadsheet->getActiveSheet()->getStyle("$cellName:$endCell")->getFill()->setFillType(\PhpOffice\PhpSpreadsheet\Style\Fill::FILL_SOLID)->getStartColor()->setARGB('dfe4e8');
						$spreadsheet->getActiveSheet()->getStyle("$cellName:$endCell")->getBorders()->applyFromArray( [ 'allBorders' => [ 'borderStyle' => PhpOffice\PhpSpreadsheet\Style\Border::BORDER_THIN, 'color' => [ 'rgb' => 'A8BCD6' ] ] ] );
						}
						
						if($cell_val==="<th class='bt-none'></th>"){ $cell_val=""; 
						$spreadsheet->getActiveSheet()->getStyle("$cellName")->getBorders()->getRight()->applyFromArray( array( 'borderStyle' => PhpOffice\PhpSpreadsheet\Style\Border::BORDER_THIN, 'color' => array( 'rgb' => 'A8BCD6'))); 
						$spreadsheet->getActiveSheet()->getStyle("$cellName")->getFill()->setFillType(\PhpOffice\PhpSpreadsheet\Style\Fill::FILL_SOLID)->getStartColor()->setARGB("ffffff");
						}elseif($cell_val==="<th class='bt-none ttl'></th>"){ $cell_val=""; 
						
						}else{
							$spreadsheet->getActiveSheet()->getStyle("$cellName:$endCell")->getBorders()->applyFromArray( [ 'allBorders' => [ 'borderStyle' => PhpOffice\PhpSpreadsheet\Style\Border::BORDER_THIN, 'color' => [ 'rgb' => 'A8BCD6' ] ] ] );
						}
						
						
					$sheet->setCellValue($cellName, html_entity_decode($cell_val));
					//$spreadsheet->getActiveSheet()->getStyle("$cellName")->getBorders()->getLeft()->applyFromArray( array( 'borderStyle' => PhpOffice\PhpSpreadsheet\Style\Border::BORDER_THIN, 'color' => array( 'rgb' => '808080'))); 
						//$spreadsheet->getActiveSheet()->getStyle("$cellName")->getBorders()->getRight()->applyFromArray( array( 'borderStyle' => PhpOffice\PhpSpreadsheet\Style\Border::BORDER_THIN, 'color' => array( 'rgb' => '808080'))); 
					//$spreadsheet->getActiveSheet()->getStyle("$cellName")->getBorders()->getTop()->applyFromArray( array( 'borderStyle' => PhpOffice\PhpSpreadsheet\Style\Border::BORDER_THIN, 'color' => array( 'rgb' => '808080')));
					//$spreadsheet->getActiveSheet()->getStyle("$cellName")->getBorders()->getBottom()->applyFromArray( array( 'borderStyle' => PhpOffice\PhpSpreadsheet\Style\Border::BORDER_THIN, 'color' => array( 'rgb' => '808080')));					
					}
				}
				if($cell_hd==="title"){
					$spreadsheet->getActiveSheet()->getStyle("A$row_no:$endCell")->getFill()->setFillType(\PhpOffice\PhpSpreadsheet\Style\Fill::FILL_SOLID)->getStartColor()->setARGB('90C2F9');
					$spreadsheet->setActiveSheetIndex(0)->mergeCells("$cellName:$endCell");	
					$spreadsheet->getActiveSheet()->getStyle("$cellName:$endCell")->getFont()->setBold(true);$spreadsheet->getActiveSheet()->getStyle("$cellName:$endCell")->getFont()->setSize(16);
					$sheet->getStyle($cellName)->getAlignment()->setHorizontal('center');	
					$spreadsheet->getActiveSheet()->getRowDimension(1)->setRowHeight(24); // CELL HEIGHT					
				}
				if($cell_hd==="sub_title"){
					$spreadsheet->getActiveSheet()->getStyle("$cellName:$endCell")->getFill()->setFillType(\PhpOffice\PhpSpreadsheet\Style\Fill::FILL_SOLID)->getStartColor()->setARGB('90C2F9');
					$spreadsheet->setActiveSheetIndex(0)->mergeCells("$cellName:$endCell");	
					$spreadsheet->getActiveSheet()->getStyle("$cellName:$endCell")->getFont()->setBold(true);$spreadsheet->getActiveSheet()->getStyle("$cellName:$endCell")->getFont()->setSize(11);
					$sheet->getStyle($cellName)->getAlignment()->setHorizontal('center');	
					 			
				}
				
				if($cell_hd==="tbl_head"){
					$spreadsheet->getActiveSheet()->getStyle("A$row_no:$endCell")->getBorders()->applyFromArray( [ 'allBorders' => [ 'borderStyle' => PhpOffice\PhpSpreadsheet\Style\Border::BORDER_THIN, 'color' => [ 'rgb' => 'A8BCD6' ] ] ] );  
				}
				
				$cell_no++;				
				} 
					
				//$spreadsheet->getActiveSheet()->getStyle("$endCell")->getBorders()->getRight()->applyFromArray( array( 'borderStyle' => PhpOffice\PhpSpreadsheet\Style\Border::BORDER_THIN, 'color' => array( 'rgb' => '808080'))); 
				
			}
			
			
		$savefilepath='';	
		if($pg=='excel' || $email_format ==3){
		//$attchmt_file = "HRMS.xlsx";
		$attchmt_file = "$file_name".date("_d_m_Y_h_i_s").".xlsx";
		$writer = new Xlsx($spreadsheet);
		$writer->save($path_excel.$attchmt_file);
		$savefilepath= base_url().$path_excel.$attchmt_file;
		}
		//----- CSV CODE -------
		if($pg =='csv' ||  $email_format ==4){
		$attchmt_file = "$file_name".date("_d_m_Y_h_i_s").".csv";
		$writer = new \PhpOffice\PhpSpreadsheet\Writer\Csv($spreadsheet);
		$writer->save($path_excel.$attchmt_file);
		$savefilepath= base_url().$path_excel.$attchmt_file;
		}
		if($pg=='email'){
			$this->model->emailSendFormat($email_to, $email_sub, $email_desc,$regard='NULL',$topmenu='not',$from="NULL",$cc=array(),$attchmt_file,$path_excel);
		}else{
			echo $savefilepath; 
		}
		
			
	}

	}else{
		echo "<h4 class='text-danger font-18 text-center mt-5'>Your Session has been expired. Click here to login again.<br/>
		<a href='".base_url()."welcome/login' class='btn btn-sm btn-primary mt-2'> Login </a>
		</h4>";
	}

	}

	public function employee_projects(){
		$e_id = $this->input->post('e_id');
		$month = $this->input->post('month');
		$prj_id = $this->input->post('prj_id');
		$clnt_id = $this->input->post('clnt_id');
		//echo "<pre>"; print_r($_POST);
		$whr="";
		$whr.="e.e_id = '$e_id'"; 
		//if($prj_id!=""){ $whr.=" AND pr.prj_id=$prj_id"; }
		//if($clnt_id!=""){ $whr.=" AND c.clnt_id $clnt_id"; } 
		$projData=$this->ts->employee_assign_proj($whr);
		echo json_encode($projData); 
	}
	
	//----------------- client report -----
	public function client_report(){
		$data["hcData"]=$this->model->DetailDatahc(array("h.hc_id"=>159));
		$this->session->unset_userdata('post_data');
		$whr="e.e_delete=0 AND e.e_id IN (SELECT t_e_id FROM tbl_timesheet)";
		$data["empallData"]=$this->hr->employee_details($whr);
		$data['clientData']=$this->model->sortingWheredata('*','tbl_prj_clients',$where='NULL','clnt_name ASC');
		$data['projData']=$this->model->sortingWheredata('*','tbl_prj_projects',$where='NULL','prj_nm ASC'); 
		$data["view"]="report/timesheet/client_time_report";
		$this->load->view("layout",$data);
	}
	
	public function client_report_search($pg=''){
	//echo "<pre>"; print_r($_POST); echo "</pre>";
	$session_data=$this->session->userdata('loginData');
	if(isset($session_data) AND $session_data!=""){
	
		$data['post_data']=$_POST;
		$e_id = $this->input->post('e_id');
		$month = $this->input->post('month');
		$year = $this->input->post('year');
		$clnt_id = $this->input->post('clnt_id');
		$prj_id = $this->input->post('prj_id');
		
		$status = $this->input->post('status');
		$whr_pro = [];
		$whr_pro['td.td_type'] = "Billable";
		$whr_pro['t.t_year'] = $year;
		
		$email_format=0;
	if($pg=='email'){
		$email_format = $this->input->post("email_format");
	  	$email_to = $this->input->post("email_to");
	  	$email_sub = $this->input->post("email_sub");
	  	$email_desc = $this->input->post("email_desc");
	}

	 
	 
	 
	
	
		$pg_type='';
		if(($pg=='excel' || $pg=='csv') || ($pg=='email' AND ($email_format ==3 || $email_format ==4))){
		$pg_type='sheet';
		}
		
	
	
	$rpt_file_name  = "";
	$rpt_file_name .="Billable_Timesheet"; $srcArr =[];
	if($month!="" AND $month!="All"){ $srcArr[]='M';
		$whr_pro['t.t_month'] = $month;
		$rpt_file_name .="_".date('M-Y',strtotime("01-$month-$year"));
	}
	if($e_id!="" AND $e_id!="All"){  $srcArr[]='E';
		$whr_pro['t.t_e_id'] = $e_id;
		$empData=$this->model->LimitWheredata('CONCAT(e_first_name," ",e_last_name) AS e_name','tbl_employee',array('e_id'=>$e_id),'e_name ASC',1);
		$rpt_file_name .="_".$empData[0]['e_name'];

	}
	if($prj_id!="" AND $prj_id!="All"){ $srcArr[]='P';
		$whr_pro['pr.prj_id'] = $prj_id;
		$projData=$this->model->sortingWheredata('prj_nm','tbl_prj_projects',array('prj_id'=>$prj_id),'prj_nm ASC');
		$prj_nm =$projData[0]['prj_nm'];
		$rpt_file_name.="_".str_replace(" ","_",str_replace("/","_",$prj_nm));
	}
	
	if($clnt_id!=""){  $srcArr[]='C';
		$whr_pro['pr.clnt_id'] = $clnt_id;
		$clientData=$this->model->LimitWheredata('clnt_name','tbl_prj_clients',array('clnt_id'=>$clnt_id),'clnt_name ASC',1);
		$clnt_nm =explode(' ',trim($clientData[0]['clnt_name']));
		$rpt_file_name.="(".$clnt_nm[0].")";
	}
	if($pg_type=='sheet'){
		$file_name = $rpt_file_name; 
		$folder_name = date("Y");
		if (!file_exists(FCPATH . "assets/report_excel/".$folder_name)) {
		$pdfFilePath1 = mkdir(FCPATH . "assets/report_excel/".$folder_name, 0755, true);
		}
		$path_excel =  'assets/report_excel/'.$folder_name.'/';
		$attchmt_path = $path_excel;
		require 'vendor/autoload.php';
		$spreadsheet = new Spreadsheet();
		$sheet = $spreadsheet->getActiveSheet();
		$sheet->getColumnDimension('A')->setAutoSize(true);
		$sheet->getColumnDimension('B')->setAutoSize(true);
		$sheet->getColumnDimension('C')->setAutoSize(true);
		$spreadsheet->getActiveSheet()->getColumnDimension('D')->setWidth(100);
		$sheet->getColumnDimension('E')->setAutoSize(true);
		
		
		}
	//==== 

	$whr_pro['t.t_status'] = "approved";
	$clientData=$this->ts->tm_project_list_report_client($whr_pro);
	
	//echo "<pre>";print_r($clientData); echo "</pre>"; 

	$reportData=[]; 
	$result ='';
	foreach($clientData AS $i=>$k){
		$clnt_name = $k['clnt_name'];
		$project_code = $k['project_code'];
		$prj_nm = $k['prj_nm'];
		
		$t_month = $k['t_month'];
		$t_e_id = $k['t_e_id'];
		$t_id = $k['t_id'];
		$where_arr = array( 
			't.t_id'=>$t_id, 
			'c.clnt_id'=> $k['clnt_id'],
			'pr.prj_id'=> $k['prj_id'],
			't.t_month'=> $k['t_month'],
		);
		
		$reportData[$clnt_name][$prj_nm][$t_month][]=$where_arr;
	}
	if(Count($clientData) <= 0){
			$result .= '<div class="text-danger text-center font-600">No data available.</div>';
		}else{
			$c=0;
			foreach($reportData as $clnt_name=>$prj_arr){ 
				 $ttl_client = 0; $c++;  
				 
				$result .= '
			
	<style>
	.table tr .bt-none{border-top: none !important; }
		.table {
    margin-bottom: 2px;
    margin-top: 1px;
}

/*.table td, table th { border-color: #36404a !important;} */
.table td, .table th {
    padding: 1px 2px;
    vertical-align: top;
    border-top: 1px solid #838990;
    font-size: 12px;
    border-left: 1px solid #838990;
    border-right: 1px solid #838990;
vertical-align: top !important;
}
.table th, .btn-brd {
   
    border-bottom: 1px solid #838990 !important;
   
}
.table-warning, .table-warning>td, .table-warning>th {
    background-color: #ffeeba;
}
.table-primary, .table-primary>td, .table-primary>th {
    background-color: #b8daff;
}

.text-right{ text-align: right; }
.table-danger, .table-danger>td, .table-danger>th {
    background-color: #f5c6cb;
}
.table-success, .table-success>td, .table-success>th {
    background-color: #c3e6cb;
}
.charge_code{color: #cfd841; font-size: 13px;    margin-left: 1em;}
</style>';

		
				
				if($pg=='email'){ 
				$result .= "<table border='1' style='font-size:12px;' class='table-sm' cellspacing='0' width='100%'>";
				}else{
				$result .= "<table class='table' cellspacing='0' width='100%'>";
				}
				$result .= '<tr><th colspan="5" class="client_head" style="color: #222223;background-color: #ffffff; font-size: 20px;text-align: center;">'.$clnt_name.'</th></tr>';
				if($pg_type=='sheet'){$sheet->setCellValue("A$c", $clnt_name);
				$spreadsheet->getActiveSheet()->getStyle("A$c:E$c")->getFont()->setSize(16);
				$spreadsheet->getActiveSheet()->getStyle("A$c:E$c")->getFont()->setBold(true);
				$spreadsheet->setActiveSheetIndex(0)->mergeCells("A$c:E$c");
				$sheet->getStyle("A$c")->getAlignment()->setHorizontal('center');
				}
				foreach($prj_arr as $prj_nm=>$month_arr){ $c++; $ttl_project= 0; 
				//$prjArr=explode('|',$prj_nm);
				$result .= '<tr class="main_head"><td colspan="5" class="text-center" style="color: #fff;background-color: #36404a;border-top: 1px solid #abc6dc;text-align: center;font-size: 15px;">PROJECT : '.$prj_nm.'</td></tr>';
				if($pg_type=='sheet'){$sheet->setCellValue("A$c",  "PROJECT : $prj_nm");
				$spreadsheet->getActiveSheet()->getStyle("A$c:E$c")->getFill()->setFillType(\PhpOffice\PhpSpreadsheet\Style\Fill::FILL_SOLID)->getStartColor()->setARGB('36404a');
				
				$spreadsheet->setActiveSheetIndex(0)->mergeCells("A$c:E$c");	
				$sheet->getStyle("A$c")->getAlignment()->setHorizontal('center');
				$styleArray = array(
				'font'  => array(
					'bold'  => true,
					'color' => array('rgb' => 'fffdfd'),
					'size'  => 14,
				));

				$spreadsheet->getActiveSheet()->getStyle("A$c")->applyFromArray($styleArray);
				}   
				 
					foreach($month_arr as $t_month=>$tm_arr){ $c++;  
					$result .= " <tr class='month_head'><td  colspan='5' style='width: 80px;vertical-align: top;background-color: #bbc3cc;font-size: 13px;text-align: center;font-weight: 600;'> Month/Year : ".date('F-Y',strtotime("01-$t_month-$year"))."</td></tr>"; 
					if($pg_type=='sheet'){$sheet->setCellValue("A$c", "Month/Year : ".date('F-Y',strtotime("01-$t_month-$year")));
					$spreadsheet->getActiveSheet()->getStyle("A$c:E$c")->getFill()->setFillType(\PhpOffice\PhpSpreadsheet\Style\Fill::FILL_SOLID)->getStartColor()->setARGB('bbc3cc');
					$spreadsheet->getActiveSheet()->getStyle("A$c:E$c")->getFont()->setBold(true);
					$spreadsheet->setActiveSheetIndex(0)->mergeCells("A$c:E$c");
					$sheet->getStyle("A$c")->getAlignment()->setHorizontal('center');
					} 
					 
					//$result .= " <tr ><td class='btn-brd' colspan='5' >";
					//echo "<pre>";print_r($tm_arr); echo "</pre>";
						foreach($tm_arr as $id=>$t_whr){  
						$proj_tmData=$this->ts->tm_data_list($t_whr); 
						$c++;  
						$result .= '<tr class="table-warning">
						<th colspan="5" style="background-color: #ffeeba;text-align:left;">EMPLOYEE : '.$proj_tmData[0]['employee_id']." - ".$proj_tmData[0]['e_name'].'</th>
						</tr>';
						if($pg_type=='sheet'){$sheet->setCellValue("A$c", "EMPLOYEE : ".$proj_tmData[0]['employee_id']." - ".$proj_tmData[0]['e_name']);
						$spreadsheet->getActiveSheet()->getStyle("A$c:E$c")->getFill()->setFillType(\PhpOffice\PhpSpreadsheet\Style\Fill::FILL_SOLID)->getStartColor()->setARGB('ffeeba');
						$spreadsheet->getActiveSheet()->getStyle("A$c:E$c")->getFont()->setBold(true);
						$spreadsheet->setActiveSheetIndex(0)->mergeCells("A$c:E$c");
						
						} 
						$c++; 
						$result .= '<tr class="table-primary">
						<th style="width:70px">Day</th>
						<th style="width:90px">Date</th>
						<th style="width:90px">Project Charge Code</th>
						<th>Activity</th>
						<th style="width:80px;white-space: nowrap;">Working Hrs</th>
						</tr>';
						if($pg_type=='sheet'){$sheet->setCellValue("A$c", "Day");
						$sheet->setCellValue("B$c", "Date");
						$sheet->setCellValue("C$c", "Project Charge Code");
						$sheet->setCellValue("D$c", "Activity");
						$sheet->setCellValue("E$c", "Working Hrs");
						$spreadsheet->getActiveSheet()->getStyle("A$c:E$c")->getFill()->setFillType(\PhpOffice\PhpSpreadsheet\Style\Fill::FILL_SOLID)->getStartColor()->setARGB('b8daff');
						$spreadsheet->getActiveSheet()->getStyle("A$c:E$c")->getFont()->setBold(true);
						
						}
						
						
		 $arr = []; $status_arr1 = []; $prj_name="";
		$ttl_billable = 0; $ttl_nonbillable = 0; $ttl_excess = 0;
		foreach ($proj_tmData as $j => $key) { 
		$c++;  
		$status = $key['td_status'];
		$prj_name = $key['project_name'];
		$status_arr1[] = $status;
	
 
		$day = date('l',strtotime($key['td_date']));
		$tr_cls =''; $td_cls ='';
		
		if(in_array($key['td_date'],$arr)){
			$tr_cls ='bt-none';
			$td_cls ='display_none';
			$td_date="";
			$td_day="";
		}else{
			$arr[] =$key['td_date'];
			$td_date=date('d-M-Y',strtotime($key['td_date']));
			$td_day=$day;
		}   
		 
		$weekoff_css="";
			if($day=="Saturday" || $day=="Sunday"){
				//$weekoff_css="table-active";
			}
		//---- SUM ---
		if($key['td_type']=='Billable'){  $ttl_billable += $key['td_working_hrs']; }
		if($key['td_type']=='Non-Billable'){  $ttl_nonbillable += $key['td_working_hrs']; }
		if($key['td_type']=='Billable' && ($day == 'Sunday' || $day == 'Saturday')){ $ttl_excess += $key['td_working_hrs']; }
		
			$result.='<tr class="'.$weekoff_css.'">';
			$result.= '<td class="'.$tr_cls.'" style="white-space:nowrap">'.$td_day.'</td>';
			$result.= '<td class="'.$tr_cls.'" style="white-space:nowrap">'.$td_date.'</td>';  
			$result.= '<td>'.$key['project_code'].'</td>';
			$result.= '<td>'.htmlspecialchars($key['td_activity']).'</td>';
			$result.= '<td>'.$key['td_working_hrs'].'</td>';
			$result.='</tr>';
		 
			if($pg_type=='sheet'){$sheet->setCellValue("A$c", "$td_day");}
			if($pg_type=='sheet'){$sheet->setCellValue("B$c", "$td_date");}
			if($pg_type=='sheet'){$sheet->setCellValue("C$c", $key['project_code']);}
			if($pg_type=='sheet'){$sheet->setCellValue("D$c", htmlspecialchars($key['td_activity']));}
			if($pg_type=='sheet'){$sheet->setCellValue("E$c", $key['td_working_hrs']);}
			
		 } //END:FOREACH $proj_tmData 
		 $c++;   
		$result .= '<tr style="text-align:right;"><th colspan="4" class="text-right"> Total Hrs Worked :  </th><th class="text-right">'.$ttl_billable;
			$ttl_client+=$ttl_billable; $ttl_project+=$ttl_billable; 
			$result .= '</th></tr>'; 
			if($pg_type=='sheet'){
			$sheet->setCellValue("D$c", "Total Hrs Worked :");
			$sheet->setCellValue("E$c", "$ttl_billable");
			$sheet->getStyle("A$c")->getAlignment()->setHorizontal('right');
			} 
						
						}// END : $tm_arr
						//$result .= "</td></tr>";
					}//END: $month_arr
					$c++; 
					$result .= "<tr class='table-success' style='text-align:right;background-color: #c3e6cb;'><th class='text-right' colspan='4'>Total Project Hrs Worked :</th><th style='width:83px;white-space: nowrap;'  class='text-right'> $ttl_project</th></tr>";
					if($pg_type=='sheet'){
					$sheet->setCellValue("A$c", "Total Hrs Worked :");
					$sheet->setCellValue("E$c", "$ttl_project");
					$spreadsheet->getActiveSheet()->getStyle("A$c:E$c")->getFill()->setFillType(\PhpOffice\PhpSpreadsheet\Style\Fill::FILL_SOLID)->getStartColor()->setARGB('C3E6CB');
					$spreadsheet->getActiveSheet()->getStyle("A$c:E$c")->getFont()->setBold(true);
					$spreadsheet->setActiveSheetIndex(0)->mergeCells("A$c:D$c");
					$sheet->getStyle("A$c")->getAlignment()->setHorizontal('right');
					
					}
					
				}// END: $prj_arr 
				$c++; 
				$result .= "<tr class='table-danger' style='text-align:right;background-color: #f5c6cb;'><th class='text-right' colspan='4'>Grand Total Hrs Worked :</th><th style='width:83px;white-space: nowrap;'  class='text-right'> $ttl_client</th></tr>";
				if($pg_type=='sheet'){
				$sheet->setCellValue("A$c", "Grand Total Hrs Worked :");
				$sheet->setCellValue("E$c", "$ttl_client");
				$spreadsheet->getActiveSheet()->getStyle("A$c:E$c")->getFill()->setFillType(\PhpOffice\PhpSpreadsheet\Style\Fill::FILL_SOLID)->getStartColor()->setARGB('F5C6CB');
				$spreadsheet->getActiveSheet()->getStyle("A$c:E$c")->getFont()->setBold(true);
				$spreadsheet->setActiveSheetIndex(0)->mergeCells("A$c:D$c");
				$sheet->getStyle("A$c")->getAlignment()->setHorizontal('right');
					
				}
				$result .= "</table>";
			
			}//END:$reportData

		} //END: else 
	
	
	//--------
	if($pg=="search"){
		 	 
		echo $result;
	} 
	
	if($pg=='email'){
	  	if($email_format ==1){	 
   			$email_msg=$email_desc."<br/>".$result; 
   			$this->model->emailSendFormat($email_to, $email_sub, $email_msg);
   		} 
		
	}

	if($pg=='pdf' || ($pg=='email' AND $email_format ==2)){
		
		include_once APPPATH . '/third_party/vendor/autoload.php';
		$pdf = new \Mpdf\Mpdf();
		$pdf->AddPage('P','', '', '', '', 5,5,5,5,5,5);
		$pdf->WriteHTML($result);
		$folder_name = date("Y");
		if (!file_exists(FCPATH . "assets/report_pdf/".$folder_name)) {
		$pdfFilePath1 = mkdir(FCPATH . "assets/report_pdf/".$folder_name, 0755, true);
		}
		$PDFname=$rpt_file_name.date("_d_m_Y_h_i_s").".pdf";
		$path_pdf =  'assets/report_pdf/'.$folder_name.'/';
		$pdf->Output(FCPATH.$path_pdf.$PDFname,'F');
		if($pg=='email'){
			$attchmt_file = $PDFname;
			$attchmt_path = $path_pdf;
			$this->model->emailSendFormat($email_to, $email_sub, $email_desc,$regard='NULL',$topmenu='not',$from="NULL",$cc=array(),$attchmt_file,$attchmt_path);
		}else{
			echo ''.base_url().$path_pdf.$PDFname; 
		} 
	}
	if(($pg=='excel' || $pg=='csv') || ($pg=='email' AND ($email_format ==3 || $email_format ==4))){
		$savefilepath='';	
		if($pg=='excel' || $email_format ==3){
		//$attchmt_file = "HRMS.xlsx";
		$attchmt_file = "$file_name".date("_d_m_Y_h_i_s").".xlsx";
		$writer = new Xlsx($spreadsheet);
		$writer->save($path_excel.$attchmt_file);
		$savefilepath= base_url().$path_excel.$attchmt_file;
		}
		//----- CSV CODE -------
		if($pg =='csv' ||  $email_format ==4){
		$attchmt_file = "$file_name".date("_d_m_Y_h_i_s").".csv";
		$writer = new \PhpOffice\PhpSpreadsheet\Writer\Csv($spreadsheet);
		$writer->save($path_excel.$attchmt_file);
		$savefilepath= base_url().$path_excel.$attchmt_file;
		}
		if($pg=='email'){
			$this->model->emailSendFormat($email_to, $email_sub, $email_desc,$regard='NULL',$topmenu='not',$from="NULL",$cc=array(),$attchmt_file,$path_excel);
			
		}else{ 
			echo $savefilepath; 
		}
		
			
	}

	}else{
		echo "<h4 class='text-danger font-18 text-center mt-5'>Your Session has been expired. Click here to login again.<br/>
		<a href='".base_url()."welcome/login' class='btn btn-sm btn-primary mt-2'> Login </a>
		</h4>";
	}

	}
	 
	public function client_project_employee(){
		$prj_id = $this->input->post('prj_id');
		$clnt_id = $this->input->post('clnt_id');
		//echo "<pre>"; print_r($_POST);
		$whr=[];
		if($clnt_id!=""){ $whr["c.clnt_id"]=$clnt_id; }
		if($prj_id!=""){ $whr["pr.prj_id"]=$prj_id; }
		//if($clnt_id!=""){ $whr.=" AND c.clnt_id $clnt_id"; } 
		$projData=$this->ts->employee_project_wise($whr);
		echo json_encode($projData); 
	}
	

}