<?php ob_start();
defined("BASEPATH") OR exit("No direct script access allowed");
class Timesheet extends CI_Controller {
	function __construct(){
		parent:: __construct();
		$this->load->model("alldata","model");
		$this->load->model("hr_model","hr");
		$this->load->model("timesheet_model","ts");
		$this->pms_email = 'timesheet.adm@tamsinfotech.com';
	}
 
	public function index()
	{
		$session_data=$this->session->userdata('loginData');
		if(isset($session_data) AND $session_data!=""){
		$u_e_id=$session_data['e_id'];
		$u_e_type=$session_data['type'];
		
		if($u_e_type == 'employee'){
			
			$emdata=$this->hr->employee_details(array('e.e_id'=> $u_e_id, 'e.e_working_status'=>1,'e.e_delete'=>'0'));
			if(strtolower($emdata[0]['r_name'])=='admin'){
				$where = array('e_working_status'=>1,'e.e_delete'=>'0');
			}else{
				$where = array('e_id'=> $u_e_id, 'e_working_status'=>1,'e.e_delete'=>'0');
			}
		}else{
			$where = array('e_working_status'=>1,'e.e_delete'=>'0');
		}
		} 
		$data["empData"]=$this->model->sortingWheredata("*","view_employee_list",$where,'e_id DESC');	
		$data["view"]="timesheet/timesheet_mgt";
		$this->load->view("layout",$data); 
	}
 
	public function activity(){
		$data["getData"]=$this->model->sortingWheredata("*,(SELECT count(td_id) as cnt from tbl_timesheet_data where td_client = `ta_id` AND td_type='Non-Billable') as cnt","tbl_timesheet_activity","NULL",'ta_type ASC');
		$data["view"]="timesheet/activity_mgt";
		$this->load->view("layout",$data);
	}
 
	//------- DELETE activity -------
	public function delete_activity($ency_id){ 
	    $id = $this->model->decryptdata($ency_id);
	    $where=array("ta_id"=>$id);                
	    $this->model->DeleteData("tbl_timesheet_activity",$where);
  	
    	$this->session->set_flashdata("msg_1", '<div class="alert alert-success alert-dismissible" role="alert">
		<button type="button" class="close" data-dismiss="alert" aria-label="Close">
		<span aria-hidden="true">&times;</span></button>
		<strong>Success!</strong> Data has been deleted successfully. </div>');
        redirect("timesheet/activity");

	} // END: DELETE FUNCTION	
	
	//------- ADD activity -------
	public function add_activity(){   
	
	if($this->input->post("save")=="save"){
		$insertdata=array(
		'ta_name'=>$this->input->post("ta_name"),
		'ta_charge_code'=>$this->input->post("ta_charge_code"),
		'ta_type'=>$this->input->post("ta_type"),
		'ta_working_hrs'=>$this->input->post("ta_working_hrs"),
		'ta_add_on'=>date("Y-m-d H:i:s")
		);

		$this->model->insertData("tbl_timesheet_activity",$insertdata);
		$this->session->set_flashdata("msg_1", '<div class="alert alert-success alert-dismissible" role="alert">
		<button type="button" class="close" data-dismiss="alert" aria-label="Close">
		<span aria-hidden="true">&times;</span></button>
		<strong>Success!</strong> Data has been inserted successfully. 
		</div>');
		redirect("timesheet/activity"); 
	}else{
		$data["catData"]=$this->model->getDatamodel("tbl_timesheet_activity");
		$data["view"]="timesheet/add_activity";
		$this->load->view("timesheet/add_activity",$data);
	} 
	    
	} // END: INSERT FUNCTION
	
	//------- EDIT activity -------
	public function edit_activity($id){
    //$id = $this->model->decryptdata($encrypted_string);
    $where=array("ta_id"=>$id);
    $ta_name=$this->model->sortingWheredata("*","tbl_timesheet_activity",$where,'ta_update_on DESC');
    if($this->input->post("save")=="save"){
		$session_data=$this->session->userdata('loginData');
			$ip = $this->input->ip_address();
			if(isset($session_data) AND $session_data!=""){
			$u_e_id=$session_data['e_id'];
			$u_e_type=$session_data['type'];
			}
			$ins_arr=array(
			'u_e_id' =>$u_e_id,
			'u_e_type'  =>$u_e_type,
			'u_table_name'=>'tbl_timesheet_activity',
			'u_page_name'=>'Timesheet Activity',
			'u_ip_address'=>$ip,
			'u_primary_id'=>$id,
			'u_add_on'=>date('Y-m-d H:i:s'),
			'u_action'=>'edit'
			);
			
		if($ta_name[0]['ta_name'] != $this->input->post("ta_name")){
			$ins_arr1=array(
			'u_field'=>"ta_name|Activity Name",
			'u_old_text'=>$ta_name[0]['ta_name'],
			'u_new_text'=>$this->input->post("ta_name")
			);
			$this->model->insertData("tbl_update_history",array_merge($ins_arr1,$ins_arr));
		}
		if($ta_name[0]['ta_charge_code'] != $this->input->post("ta_charge_code")){
			$ins_arr2=array(
			'u_field'=>"ta_charge_code|Charge Code",
			'u_old_text'=>$ta_name[0]['ta_charge_code'],
			'u_new_text'=>$this->input->post("ta_charge_code")
			);
			$this->model->insertData("tbl_update_history",array_merge($ins_arr2,$ins_arr));
		} 
		if($ta_name[0]['ta_type'] != $this->input->post("ta_type")){
			$ins_arr2=array(
			'u_field'=>"ta_type|Type",
			'u_old_text'=>$ta_name[0]['ta_type'],
			'u_new_text'=>$this->input->post("ta_type")
			);
			$this->model->insertData("tbl_update_history",array_merge($ins_arr2,$ins_arr));
		} 
		
		if($ta_name[0]['ta_working_hrs'] != $this->input->post("ta_working_hrs")){
			$ins_arr2=array(
			'u_field'=>"ta_working_hrs|Working Hrs",
			'u_old_text'=>$ta_name[0]['ta_working_hrs'],
			'u_new_text'=>$this->input->post("ta_working_hrs")
			);
			$this->model->insertData("tbl_update_history",array_merge($ins_arr2,$ins_arr));
		} 
		
        $Updatedata=array(
		'ta_name'=>$this->input->post("ta_name"),
		'ta_charge_code'=>$this->input->post("ta_charge_code"),
		'ta_type'=>$this->input->post("ta_type"),
		'ta_working_hrs'=>$this->input->post("ta_working_hrs")
		);

        $this->model->UpdateData("tbl_timesheet_activity",$Updatedata,$where);
        $this->session->set_flashdata("msg_1",'<div class="alert alert-success alert-dismissible" role="alert">
		<button type="button" class="close" data-dismiss="alert" aria-label="Close">
		<span aria-hidden="true">&times;</span></button>
		<strong>Success!</strong> Data has been updated successfully. 
        </div>'); 
        redirect("timesheet/activity"); 
    }else{
    	$data["getData"]=$this->model->getDatamodel("tbl_timesheet_activity");
    	$data["edit"]=$ta_name;
    	$data["view"]="timesheet/add_activity";
		$this->load->view("timesheet/add_activity",$data);
    } 

  	} // END: EDIT FUNCTION 


  	public function instructions($action=""){
		$data["getDatas"]=$this->model->sortingWheredata("*","tbl_timesheet_activity","NULL",'ta_update_on DESC');
    $id = 1; 
    $where=array("ti_id"=>$id);
    if($action=='delete'){
    	$Updatedata=array(
		'ti_instructions'=>""
		);
 
        $this->model->UpdateData("tbl_timesheet_instructions",$Updatedata,$where);
        $this->session->set_flashdata("msg",'<div class="alert alert-success alert-dismissible" role="alert">
		<button type="button" class="close" data-dismiss="alert" aria-label="Close">
		<span aria-hidden="true">&times;</span></button>
		<strong>Success!</strong> Data has been deleted successfully. 
        </div>'); 
        redirect("timesheet/instructions"); 
    }

    $tidata=$this->model->sortingWheredata("*","tbl_timesheet_instructions",$where,'ti_id DESC');
    if($this->input->post("save")=="save"){
		$session_data=$this->session->userdata('loginData');
			$ip = $this->input->ip_address();
			if(isset($session_data) AND $session_data!=""){
			$u_e_id=$session_data['e_id'];
			$u_e_type=$session_data['type'];
			}
			$ins_arr=array(
			'u_e_id' =>$u_e_id,
			'u_e_type'  =>$u_e_type,
			'u_table_name'=>'tbl_timesheet_instructions',
			'u_page_name'=>'Timesheet Instructions',
			'u_ip_address'=>$ip,
			'u_primary_id'=>$id,
			'u_add_on'=>date('Y-m-d H:i:s'),
			'u_action'=>'edit'
			);
			
		if($tidata[0]['ti_instructions'] != $this->input->post("ti_instructions")){
			$ins_arr1=array(
			'u_field'=>"ti_instructions|Instructions",
			'u_old_text'=>$tidata[0]['ti_instructions'],
			'u_new_text'=>$this->input->post("ti_instructions")
			);
			$this->model->insertData("tbl_update_history",array_merge($ins_arr1,$ins_arr));
		}
		
        $Updatedata=array(
		'ti_instructions'=>$this->input->post("ti_instructions")
		);

        $this->model->UpdateData("tbl_timesheet_instructions",$Updatedata,$where);
        $this->session->set_flashdata("msg",'<div class="alert alert-success alert-dismissible" role="alert">
		<button type="button" class="close" data-dismiss="alert" aria-label="Close">
		<span aria-hidden="true">&times;</span></button>
		<strong>Success!</strong> Data has been save successfully. 
        </div>'); 
        redirect("timesheet/instructions"); 
    }else{
    	$data["getData"]=$this->model->getDatamodel("tbl_timesheet_instructions");
    	$data["view"]="timesheet/instructions";
		$this->load->view("layout",$data);
    } 

  	} // END: EDIT FUNCTION


  	//::::::::::::::::: GEMERATE TIMESHEET ::::::::::::::::::::::::::

  	public function generate_timesheet($page_type="",$enc_t_id="",$pg_status="all",$project="")
	{ 
		//echo "<pre>";print_r($_POST);echo "</pre>";die;
		$mode='add'; 
		$submit_type=$this->input->post('timesheet');
		$data['pg_status']=$pg_status;
		$data['page_type']=$page_type;
		$data['project']=$project;
		
		if($enc_t_id==""){
		$emp_id=$this->input->post('e_id');
		$month = $this->input->post("month");
		$year = $this->input->post("year");
		$whr = array('t_e_id'=>$emp_id,'t_month'=>$month,'t_year'=>$year);
		$ts_Data=$this->model->sortingWheredata("*","tbl_timesheet",$whr,'t_id ASC');
		if(count($ts_Data) > 0){
			$enc_t_id=$this->model->encryptdata($ts_Data[0]['t_id']);
			
			if($ts_Data[0]['t_status']!='reject'  && $ts_Data[0]['t_status']!='save'){
				redirect("timesheet/view_timesheet/$enc_t_id/$page_type");
			}
			redirect("timesheet/$submit_type"."_timesheet/$page_type/$enc_t_id"); 
		}else{ 
		if($submit_type=='view'){ 
		$this->session->set_flashdata("msg",'<div class="alert alert-danger alert-dismissible" role="alert">
		<button type="button" class="close" data-dismiss="alert" aria-label="Close">
		<span aria-hidden="true">&times;</span></button>
		Timesheet Data not found.
        </div>'); 
		redirect("timesheet");  }
		} 
		
		}else{
		$t_id = $this->model->decryptdata($enc_t_id);
		$ts_Data=$this->model->sortingWheredata("*","tbl_timesheet",array('t_id'=>$t_id),'t_id ASC');
		$emp_id= $ts_Data[0]['t_e_id'];
		$month = $ts_Data[0]["t_month"];
		$year = $ts_Data[0]["t_year"]; 
		if($pg_status!='edit'){
		redirect("timesheet/view_timesheet/$enc_t_id/$page_type");
		}
		if($ts_Data[0]['t_status']!='reject'  && $ts_Data[0]['t_status']!='save'){
				//redirect("timesheet/view_timesheet/$enc_t_id");
			} 
			//$where_td = "(td_status != 'P' && td_status != 'A')";
		//$data['tsd_Data']=$this->model->sortingWheredata("*","tbl_timesheet_data",$where_td,'td_id ASC');
		$data['t_id']=$t_id;
		$mode = 'edit';
		 
		}
		
		if($pg_status=='edit'){
		$app_proj_list=$this->ts->timesheet_project_list(array('t.t_id'=>$t_id,'td.td_status'=>'A'));
		$data["app_proj"] = array_column($app_proj_list, 'prj_id');
		}
		

		$data['mode'] = $mode; 
		
		$data["projData"]=$this->ts->prj_asignEmp(array('e.e_id' => $emp_id, 'pr.prj_status'=>1));	
		
		$data["empData"]=$this->ts->employee_details(array('e.e_id' => $emp_id));	
		$data['actData']=$this->model->sortingWheredata("*","tbl_timesheet_activity","NULL",'ta_type DESC');
		//$data["instructionsData"]=$this->model->getDatamodel("tbl_timesheet_instructions");
		$c_id = $data['empData'][0]['c_id'];
		$datas =$this->ts->CelenderData(array('c.c_id'=>$c_id,'h.h_year'=>$year,"MONTH(h.h_date)" => $month));
		$data["holidays"] = array_column($datas, 'h_date');
		$data["holidays_day"] = array_column($datas, 'holiday_name');
		$data["view"]="timesheet/fill";
		$data["month"]=$month;
		$data["year"]=$year;
		$this->load->view("layout",$data);
	}

	//------ SELECT CLIENT -----------
	public function select_type_fun(){
		$app_proj = $this->input->post("app_proj");
		$e_id = $this->input->post("e_id");
		$type = $this->input->post("type");
		$hd_client = $this->input->post("hd_client");
		$date = date('Y-m-d',strtotime($this->input->post("date")));
		$chk_type="";
		$chk_id="";
		if($hd_client!=""){
			$exp=explode('|',$hd_client);
			$chk_type=$exp[0];
			$chk_id=$exp[1];
		}
		$option_txt="<option value=''>Select</option>";
		if($type=="Billable"){  
			$whr="(pa.from_dt <='$date' AND pa.till_dt >='$date') AND e.e_id = '$e_id' AND pr.prj_status = 1";
			$projData=$this->ts->prj_asignEmp($whr);
			foreach ($projData as $k){
				$sel=""; if($chk_type=="Billable"){ if($chk_id==$k['prj_id']){ $sel="selected"; } }
				$option_txt.='<option value="'.$k['prj_id'].'" '.$sel.'>'.$k['project_code'].'</option>';
			 }
		}

		if($type=="Non-Billable"){

			$activityData=$this->model->sortingWheredata("*","tbl_timesheet_activity",array('ta_type'=>'Non-Billable'),'ta_update_on DESC');
			foreach ($activityData as $k){
				$sel=""; if($chk_type=="Non-Billable"){ if($chk_id==$k['ta_id']){ $sel="selected"; } }
				$option_txt.='<option value="'.$k['ta_id'].'" '.$sel.'>'.$k['ta_charge_code'].'</option>';
			 } 
		}
		echo $option_txt;
	}
	
	//------- SAVE TIMESHEET ------------
	public function save_timesheet()
	{
		
		echo "<pre>";
		print_r($_POST);
		echo "</pre>";  //die;
		$session_data=$this->session->userdata('loginData');
		$u_e_id=$session_data['e_id'];
		$u_e_type=$session_data['type'];
		
	
		$project=$this->input->post('project');
		$page_type=$this->input->post('page_type');
		$post_t_id=$this->input->post('t_id');
		$t_prj_id=$this->input->post('t_prj_id');
		$e_id=$this->input->post('e_id');
		$year=$this->input->post('year');
		$month=$this->input->post('month');
		$date=$this->input->post('date');
		$type=$this->input->post('type');
		$client=$this->input->post('client');
		$activity=$this->input->post('activity');
		$working_hrs=$this->input->post('working_hrs');
		$hd_t_id=$this->input->post('hd_t_id');
		
		$insArr = array(
		"t_e_id" => $e_id,
		"t_prj_id" => $t_prj_id,
		"t_year" => $year,
		"t_month" => $month,
		//"t_comments" => $this->input->post('t_comments'),
		"t_add_e_id" => $u_e_id,
		"t_add_e_type" => $u_e_type
		);
 
		if($post_t_id==""){
		$ins =array("t_status" => 'save',"t_add_on" => date('Y-m-d H:i:s'));
		$this->model->insertData("tbl_timesheet",array_merge($insArr,$ins));
		$t_id = $this->db->insert_id();
		}else{
		$this->model->UpdateData("tbl_timesheet",$insArr,array('t_id'=>$post_t_id));	
		$t_id = $post_t_id;
		}
		$enc_t_id=$this->model->encryptdata($t_id);
 
		for ($i=0; $i < count($type) ; $i++) { 
			if($type[$i]!="" AND $client[$i]!=""){
			$mode='add';
			if(isset($hd_t_id[$i])){ if($hd_t_id[$i]!=""){ $mode='edit'; } }
			$insArr2 = array(
			"t_id" => $t_id,
			"td_date" => date('Y-m-d',strtotime($date[$i])),
			"td_type" => $type[$i],
			"td_client" => $client[$i],
			"td_activity" => $activity[$i],
			"td_working_hrs" => $working_hrs[$i],
			"td_status" => 'S'
			);
			
			
				if($mode=='add'){
					//echo "<pre> add ";print_r($insArr2);echo "</pre>";
				$this->model->insertData("tbl_timesheet_data",$insArr2);
				}else{
					//echo "<pre> edit ";print_r($insArr2);echo "</pre>";
				$this->model->UpdateData("tbl_timesheet_data",$insArr2,array('td_id'=>$hd_t_id[$i]));	
				}
			}
			
		} //END:for
		 
		 $this->session->set_flashdata("msg",'<div class="alert alert-success alert-dismissible" role="alert">
			<button type="button" class="close" data-dismiss="alert" aria-label="Close">
			<span aria-hidden="true">&times;</span></button>
			<strong>Success!</strong> Timesheet has been saved successfully. 
			</div>'); 
		redirect("timesheet/view_timesheet/$enc_t_id/$page_type/$project"); 
	} 

	public function delete_timesheet_data(){
		$td_id=$this->input->post('td_id');
		$where=array("td_id"=>$td_id);            
		$this->model->DeleteData("tbl_timesheet_data",$where);
		echo "delete";
	} 
	
	public function view_timesheet($enc_t_id="",$page_type="",$project="")
	{
		$session_data=$this->session->userdata('loginData'); 
		$si_type=strtolower($session_data['type']);
		if($page_type == 'timesheet'){
		$data['page_title']="Timesheet";
		$tm_arr=array('all'=>"80", 'approved'=>"81", 'pending'=>"82", 'my_action'=>"83", 'fill_tm'=>"84",'view'=>"77");
		}elseif($page_type == 'my_timesheet'){
		$data['page_title']="My Timesheet";
		$tm_arr=array('all'=>"86", 'approved'=>"87", 'pending'=>"88", 'my_action'=>"89", 'fill_tm'=>"90",'view'=>"91");
		}elseif($page_type == 'employee_timesheet'){
		$data['page_title']="Employee Timesheet";
			$tm_arr=array('all'=>"97", 'approved'=>"98", 'pending'=>"99", 'my_action'=>"100", 'fill_tm'=>"101",'view'=>"102");
		}
		$data['tm_Arr']=$tm_arr;
		$data['page_type']=$page_type;
		
		
		$data['tm_Arr']= $this->ts->tm_role($page_type,"view");
		$data['enc_t_id']=$enc_t_id;
		$data['project']=$project;
		$t_id = $this->model->decryptdata($enc_t_id);
		if($page_type=="employee_timesheet" AND $project!="Non-Billable"){
			$proid = $this->model->decryptdata($project);
			$where = "(FIND_IN_SET('$proid',td.td_client) > 0) AND t.t_id = $t_id AND td.td_type='Billable'";
		}else{
			$proid = $this->model->decryptdata($project);
			$where = "t.t_id = $t_id";
		}
		//FIND_IN_SET(`prj_id`,'14,13,12,9') > 0
		 
		$data['getData']=$this->ts->timesheet_data($where);
		$prj_id = $data['getData'][0]['t_prj_id'];
		$e_id = $data['getData'][0]['t_e_id']; 
		$c_id = $data['getData'][0]['c_id']; 
		$month = $data['getData'][0]['t_month'];
		$year = $data['getData'][0]['t_year'];
		$t_status = $data['getData'][0]['t_status'];
		$t_week_off = $data['getData'][0]['t_week_off'];
		$t_holiday = $data['getData'][0]['t_holiday'];
		if($t_status=='save'){
		$datas =$this->ts->CelenderData(array('c.c_id'=>$c_id,'h.h_year'=>$year,"MONTH(h.h_date)" => $month));
		 
		$data["holidays"] = array_column($datas, 'h_date');
		$data["holidays_day"] = array_column($datas, 'holiday_name');
		}else{
			$exp_hol = explode('|-|',$t_holiday);
			$hol_Arr = [];
			foreach ($exp_hol as $k) { 
			$exp_hols = explode('|',$k);
			$hol_Arr[] = $exp_hols[0];
			} 
			$data["holidays"] = $hol_Arr;  
			//2019-01-01|NEW YEAR|-|2019-01-14|MAKAR SANKRANTI / PONGAL|-|2019-01-26|REPUBLIC DAY
		} 
	$off1 = explode('|',$t_week_off);
		$offdays = array_merge($off1,$data["holidays"]);
		$imp_off = implode(',',$offdays);
		$whr_pro = "(FIND_IN_SET(pr.prj_id,'$prj_id') > 0) AND pr.prj_status = 1 AND e.e_id = $e_id";
		$data["projData"]=$this->ts->timesheet_project_list($where);
		//array('td.td_type'=> "Billable","t.t_id"=>$t_id);
		$whrb = "(td.td_type= 'Billable' AND t.t_id = $t_id)";		
		$data["projbillCount"]=$this->ts->project_billable_count($whrb);		
		$data["projnonCount"]=$this->ts->project_billable_count(array('td.td_type'=> "Non-Billable","t.t_id"=>$t_id));	
		$data["projcmts"]=$this->ts->timesheet_project_list(array('td.td_type'=> "Billable","t.t_id"=>$t_id,'td.td_status'=>'R'));
		if($si_type == 'employee'){
		$empExist=$this->model->DetailData("tbl_employee",array('e_id'=>$session_data['e_id']));
		$si_e_office_email_id =$empExist[0]['e_office_email_id'];
		$si_e_nm =$empExist[0]['e_first_name']." ".$empExist[0]['e_middle_name']." ".$empExist[0]['e_last_name'];
			if($page_type == 'employee_timesheet'){
				if($project=='Non-Billable'){
				$data['project_id']='Non-Billable';
				$data['post_mgr_data']=$session_data['e_id']."|Non-Billable|$si_e_nm|$si_e_office_email_id|S";
				}else{
				$data['project_id']=$proid;
				$data['post_mgr_data']=$session_data['e_id']."|$proid|$si_e_nm|$si_e_office_email_id|M";
				}
			}else{
			$data['project_id']='All';
			$data['post_mgr_data']=$session_data['e_id']."|All|$si_e_nm|$si_e_office_email_id|E";
			}
		}else{ 
		$data['project_id']='All';
		$data['post_mgr_data']=$session_data['e_id']."|All|Super Admin||SA";
		}
		$data["cmtsData"]=$this->ts->commentsData(array("t.tc_t_id"=>$t_id));	
		$data["view"]="timesheet/view_timesheet";
		$this->load->view("layout",$data); 
	}
	
	public function mgr_timesheet($enc_t_id="",$page_type="")
	{
		if($page_type == 'timesheet'){
		$data['page_title']="Timesheet Management";
		$tm_arr=array('all'=>"80", 'approved'=>"81", 'pending'=>"82", 'my_action'=>"83", 'fill_tm'=>"84",'view'=>"77");
		}elseif($page_type == 'my_timesheet'){
		$data['page_title']="My Timesheet";
		$tm_arr=array('all'=>"86", 'approved'=>"87", 'pending'=>"88", 'my_action'=>"89", 'fill_tm'=>"90",'view'=>"91");
		}elseif($page_type == 'employee_timesheet'){
		$data['page_title']="Employee Timesheet";
			$tm_arr=array('all'=>"97", 'approved'=>"98", 'pending'=>"99", 'my_action'=>"100", 'fill_tm'=>"101",'view'=>"102");
		}
		$data['tm_Arr']=$tm_arr;
		$data['page_type']=$page_type;
		
		
		$data['tm_Arr']= $this->ts->tm_role($page_type,"view");
		$data['enc_t_id']=$enc_t_id;
		$t_id = $this->model->decryptdata($enc_t_id);
		$where=array("t.t_id"=>$t_id);
		//FIND_IN_SET(`prj_id`,'14,13,12,9') > 0
		 
		$data['getData']=$this->ts->timesheet_data($where);
		$prj_id = $data['getData'][0]['t_prj_id'];
		$e_id = $data['getData'][0]['t_e_id']; 
		$c_id = $data['getData'][0]['c_id']; 
		$month = $data['getData'][0]['t_month'];
		$year = $data['getData'][0]['t_year'];
		$t_status = $data['getData'][0]['t_status'];
		$t_week_off = $data['getData'][0]['t_week_off'];
		$t_holiday = $data['getData'][0]['t_holiday'];
		if($t_status=='save'){
		$datas =$this->ts->CelenderData(array('c.c_id'=>$c_id,'h.h_year'=>$year,"MONTH(h.h_date)" => $month));
		 
		$data["holidays"] = array_column($datas, 'h_date');
		$data["holidays_day"] = array_column($datas, 'holiday_name');
		}else{
			$exp_hol = explode('|-|',$t_holiday);
			$hol_Arr = [];
			foreach ($exp_hol as $k) { 
			$exp_hols = explode('|',$k);
			$hol_Arr[] = $exp_hols[0];
			} 
			$data["holidays"] = $hol_Arr;  
			//2019-01-01|NEW YEAR|-|2019-01-14|MAKAR SANKRANTI / PONGAL|-|2019-01-26|REPUBLIC DAY
		} 
	$off1 = explode('|',$t_week_off);
		$offdays = array_merge($off1,$data["holidays"]);
		$imp_off = implode(',',$offdays);
		$whr_pro = "(FIND_IN_SET(pr.prj_id,'$prj_id') > 0) AND pr.prj_status = 1 AND e.e_id = $e_id";
		$data["projData"]=$this->ts->timesheet_project_list($where);
		//array('td.td_type'=> "Billable","t.t_id"=>$t_id);
		$whrb = "(td.td_type= 'Billable' AND t.t_id = $t_id)";		
		$data["projbillCount"]=$this->ts->project_billable_count($whrb);		
		$data["projnonCount"]=$this->ts->project_billable_count(array('td.td_type'=> "Non-Billable","t.t_id"=>$t_id));	
		$data["projcmts"]=$this->ts->timesheet_project_list(array('td.td_type'=> "Billable","t.t_id"=>$t_id,'td.td_status'=>'R'));
		
		
		$data["view"]="timesheet/mgr_timesheet";
		$this->load->view("layout",$data); 
	}
	
	public function manage_status(){
		$t_id = $this->input->post('t_id');
		$enc_t_id=$this->model->encryptdata($t_id);
		$curl = $this->input->post('curl');
		$status = $this->input->post('status');
		$project_id = $this->input->post('project_id');
		//echo "<pre>";print_r($_POST);echo "</pre>";die;
		if($this->input->post('send')=='email'){
			$where=array("t.t_id"=>$t_id);
			$getData=$this->ts->timesheet_data($where);
			$sup_email = $getData[0]["sup_e_office_email_id"];
			$supervisor_name = $getData[0]["supervisor_name"];
			$t_status = $getData[0]['t_status'];
			$month = $getData[0]['t_month'];
			$year = $getData[0]['t_year'];
			$prj_id = $getData[0]['t_prj_id'];
			$e_id = $getData[0]['t_e_id']; 
			$whr_pro = "(FIND_IN_SET(pr.prj_id,'$prj_id') > 0) AND pr.prj_status = 1 AND e.e_id = $e_id";
			$projData=$this->ts->timesheet_project_list(array('td.td_type'=> "Billable","t.t_id"=>$t_id,"td.td_status !="=>'A'));	
			//echo "<pre>";print_r($projData);echo "</pre>"; die;
			 
			//$subject = "Timesheet : ".$getData[0]['employee_id']." - ".$getData[0]['e_name']." [".date('M-Y',strtotime("01-$month-$year"))."]"; 
			if($sup_email!=""){
				$email_link_sup = base_url()."welcome/timesheet/$enc_t_id";
				$subject_sup = "Timesheet : ".$getData[0]['employee_id']." - ".$getData[0]['e_name']." [".date('M-Y',strtotime("01-$month-$year"))."] - ".'"Non-Billable"';
				$msg="
				<p>Dear $supervisor_name,</p>
				<p>Please click below link to approve timesheet of ".$getData[0]['e_name']." for ".date('M-Y',strtotime("01-$month-$year")).".</p>
				<a href='$email_link_sup'>$email_link_sup</a>
				<!--a href='$email_link_sup' style='background: #0f548b;padding: 5px 8px;color: #fff;text-decoration: none;box-shadow: 3px 3px 7px 1px #a9a9a9;'>Approve Timesheet</a-->
				<p>
				Thanks,<br/>
				Admin Team,<br/>
				TAMS Infotech 
				</p>";
				$this->model->emailSendFormat($sup_email, $subject_sup, $msg, 'NULL','NULL',$this->pms_email);
				//$this->model->emailSendFormat('nikita.prajapati@staroneweb.co.in',$subject_sup, $msg, 'NULL','NULL',$this->pms_email);
			}
			
			foreach ($projData as $k) { 
			$project_name = $k['project_name'];
			$m_nm = $k['m_nm'];
			$email = $k['email'];
			$prj_id = $k['prj_id']; 
			$enc_prj_id=$this->model->encryptdata($prj_id);
			$email_link=base_url()."welcome/timesheet/$enc_t_id/$enc_prj_id";
			$subject = "Timesheet : ".$getData[0]['employee_id']." - ".$getData[0]['e_name']." [".date('M-Y',strtotime("01-$month-$year"))."] - ".'"'.$project_name.'"';
			$msg="
			<p>Dear $m_nm,</p>
			<p>Please click below link to approve timesheet of ".$getData[0]['e_name']." for ".date('M-Y',strtotime("01-$month-$year")).".</p>
			<a href='$email_link'>$email_link</a>
			<!--a href='$email_link' style='background: #0f548b;padding: 5px 8px;color: #fff;text-decoration: none;box-shadow: 3px 3px 7px 1px #a9a9a9;'>Approve Timesheet</a-->
			<p>
			Thanks,<br/>
			Admin Team,<br/>
			TAMS Infotech
			</p>";
			$this->model->emailSendFormat($email, $subject, $msg, 'NULL','NULL',$this->pms_email); 
			//$this->model->emailSendFormat('nikita.prajapati@staroneweb.co.in', $subject, $msg, 'NULL');  
			}
			
			if(count($projData) > 0 ){  
			$t_week_off = $this->input->post('t_week_off');
			$t_holiday = $this->input->post('t_holiday');
			if($t_status=='save'){
			$this->model->UpdateData("tbl_timesheet",array('t_status'=>'pending','t_week_off'=>$t_week_off,'t_holiday'=>$t_holiday),array('t_id'=>$t_id));	
			}
			} 
			$this->model->UpdateData("tbl_timesheet_data",array('td_status'=>'P'),array('t_id'=>$t_id,'td_status'=>'S'));
			
			$this->session->set_flashdata("msg",'<div class="alert alert-success alert-dismissible" role="alert">
			<button type="button" class="close" data-dismiss="alert" aria-label="Close">
			<span aria-hidden="true">&times;</span></button>
			<strong>Success!</strong> Timesheet has been submited successfully. 
			</div>'); 
			redirect("$curl");  
		}else{
		$t_status_comments = $this->input->post('t_status_comments');
		$post_mgr_id = $this->input->post('post_mgr_id');
		$post_mgr_data = $this->input->post('post_mgr_data');
		
		if(strtolower($project_id) == 'all'){
			$whr = array('t_id'=>$t_id,'td_status !='=>'A');
			$whr_ts = array("t.t_id"=>$t_id);
		}elseif($project_id == 'Non-Billable'){
			$whr = array('t_id'=>$t_id,'td_type'=>'Non-Billable','td_status !='=>'A');
			$whr_ts = array("t.t_id"=>$t_id);
		}else{
			$whr = array('t_id'=>$t_id, 'td_type'=> 'Billable','td_client' => $project_id,'td_status !='=>'A');
			$t_status_comments = $t_status_comments;
			$whr_ts = array('td.td_type'=> "Billable","t.t_id"=>$t_id,'td.td_client' => $project_id);
		}  
		$projData=$this->ts->timesheet_project_list($whr_ts);
		$month = $projData[0]['t_month'];
			$year = $projData[0]['t_year'];
		//echo "<pre>";print_r($_POST);print_r($whr_ts);echo "</pre>";die; 
		if(strtolower($project_id) == 'all'){
		$mgr_nm ="PMS Team";
		}elseif($project_id == 'Non-Billable'){
		$mgr_nm ="PMS Team";
		}else{
		$mgr_nm =$projData[0]['m_nm'];
		}
		$e_office_email_id = $projData[0]['e_office_email_id'];
		$email_link=base_url()."welcome/view_timesheet/$enc_t_id/my_timesheet";
		if($status=='R'){
		$cmt_status = 'rejected';
		$subject = "Timesheet of ".$projData[0]['e_name']." for ".date('M-Y',strtotime("01-$month-$year"))." - Rejected";
		$msg="
		<p>Dear ".$projData[0]['e_name'].",</p>
		<p>Your timesheet for the month of ".date('M-Y',strtotime("01-$month-$year"))." has been Rejected.</p>
		<p>Please find the reason as mentioned below:</p>
		<p style='color:#9e1b1b'>$t_status_comments</p>
		<a href='$email_link' style='background: #0f548b;padding: 5px 8px;color: #fff;text-decoration: none;box-shadow: 3px 3px 7px 1px #a9a9a9;'> Re-submit </a>
		<p>Thanks, <br/>
		$mgr_nm</p>";   
		} 
		
		if($status=='A'){
		$subject = "Timesheet of ".$projData[0]['e_name']." for ".date('M-Y',strtotime("01-$month-$year"))." - Approved";
		$msg="
		<p>Dear ".$projData[0]['e_name'].",</p>
		<p>Your timesheet for the month of ".date('M-Y',strtotime("01-$month-$year"))." has been Approved.</p>
		<p>Thanks, <br/>
		$mgr_nm</p>"; 

		}
		
		//IF($t_status_comments!=""){
		/*$t_status_comments = "$post_mgr_id|".date('Y-m-d H:i:s')."|$t_status_comments|$status"; 
		$tmData=$this->model->DetailData("tbl_timesheet",array('t_id'=>$t_id));	
		$tm_cmt = $tmData[0]['t_status_comments'];
		if($tm_cmt!=""){ $t_status_comments1=$tm_cmt."|-|".$t_status_comments; }
		$this->model->UpdateData("tbl_timesheet",array('t_status_comments'=>$t_status_comments1),array('t_id'=>$t_id));	*/
		
		if(isset($post_mgr_data)){
			$exp_mgr = explode('|',$post_mgr_data);
		}
		
		$insComm = array(
		'tc_t_id'=>$t_id,
		'tc_proj_id'=>$exp_mgr[1],
		'tc_e_id'=>$exp_mgr[0],
		'tc_e_type'=>$exp_mgr[4],
		'tc_name'=>$exp_mgr[2],
		'tc_email'=>$exp_mgr[3],
		'tc_comment'=>$t_status_comments,
		'tc_status'=>$status,
		'tc_add_on'=> date('Y-m-d H:i:s')
		);
		$this->model->insertData("tbl_timesheet_comments",$insComm);
		
		//}
		$this->model->UpdateData("tbl_timesheet_data",array('td_status'=>$status,'td_status_log'=>date('Y-m-d H:i:s')),$whr); 	
		
		$this->model->emailSendFormat($e_office_email_id, $subject, $msg, 'NULL','NULL',$this->pms_email);
		//$this->model->emailSendFormat('nikita.prajapati@staroneweb.co.in', $subject, $msg, 'NULL');  
		if($status=='A'){
		$app_proj_list=$this->model->groupbyData('td_status','tbl_timesheet_data',array('t_id'=>$t_id),$order='NULL',$group_by='td_status');
		if(count($app_proj_list) == 1){
			if($app_proj_list[0]['td_status']=='A'){
				$this->model->UpdateData("tbl_timesheet",array('t_status'=>'approved'),array('t_id'=>$t_id));
			}
		}
		} 
		 
		$this->session->set_flashdata("msg",'<div class="alert alert-success alert-dismissible" role="alert">
		<button type="button" class="close" data-dismiss="alert" aria-label="Close">
		<span aria-hidden="true">&times;</span></button>
		<strong>Success!</strong> Status has been updated successfully. 
        </div>'); 
		//redirect("$curl");  
		if (strpos($curl, 'welcome') !== false) {
		redirect('http://tamsinfotech.com/');
		}else{ redirect("$curl"); }
		}
	}
	
	public function download_timesheet($enc_t_id){ 
	 
		$t_id = $this->model->decryptdata($enc_t_id);
		$where=array("t.t_id"=>$t_id);
		$data['getData']=$this->ts->timesheet_data($where);
		$prj_id = $data['getData'][0]['t_prj_id'];
		$e_id = $data['getData'][0]['t_e_id']; 
		//$whr_pro = "(FIND_IN_SET(pr.prj_id,'$prj_id') > 0) AND pr.prj_status = 1 AND e.e_id = $e_id";
		$data["projData"]=$this->ts->timesheet_project_list($where);
		
		//$this->load->view('timesheet/download_timesheet', $data, true)
		
		
		$this->load->library('m_pdf');
		$pdf = new Mpdf();
		$pdf->AddPage('L','', '', '', '', 5,5,5,5,5,5); 
		//$this->m_pdf->pdf->SetHeader('{DATE j-m-Y}|{PAGENO}/2|My document');
 
		$cssurl = base_url() . "assets/css/pdf.css";
		$stylesheet = file_get_contents($cssurl);
		$this->m_pdf->pdf->WriteHTML($stylesheet, 1); // The parameter 1 tells that this is css/style only and no
		$html2 = $this->load->view('timesheet/download_timesheet', $data, true);
		$this->m_pdf->pdf->SetMargins(0, 0, 50);
		//$this->m_pdf->pdf->WriteHTML($html2);
		$pdf->WriteHTML($html2);
		//if (!file_exists(FCPATH . "/uploads/quot/$l_id/" . $folder_name)) {
		//  mkdir(FCPATH . "/uploads/quot/$l_id/" . $folder_name, 0755, true);
		// } 
		$date = "01-".$data['getData'][0]['t_month']."-".$data['getData'][0]['t_year'];
		$PDFname="Timesheet-".date('M-Y',strtotime("$date"))."[ ".$data['getData'][0]['employee_id']." - ".$data['getData'][0]['e_name']." ].pdf";
		$pdf->Output("$PDFname", "D");
		// redirect('mak/cust_2/CustomQuatation');
		}
		
		
	//================ TIMESHEET MGT by STATUS ===============
	public function manage_timesheet($page_type="")
	{
	$session_data=$this->session->userdata('loginData');
	if(isset($session_data) AND $session_data!=""){
	$u_e_id=$session_data['e_id'];
	$u_e_type=$session_data['type'];
	$data['tm_Arr']= $this->ts->tm_role($page_type);
	 
	if($u_e_type == 'employee'){
	$emdata=$this->hr->employee_details(array('e.e_id'=> $u_e_id, 'e.e_working_status'=>1,'e.e_delete'=>'0'));
		if($page_type == 'employee_timesheet'){
			$where = array('e.e_supervisor_employee_id'=> $u_e_id, 'e.e_working_status'=>1,'e.e_delete'=>'0');
		}else{
			$where = array('e.e_working_status'=>1,'e.e_delete'=>'0');
		}
			
		 
		/*if(strtolower($emdata[0]['r_name'])=='admin'){
		$where = array('e_working_status'=>1);
		$data['sel_emp'] = 'all';
		}else{
		$where = array('e_id'=> $u_e_id, 'e_working_status'=>1);
		$data['sel_emp'] = 'one';
		}*/
	}else{
	$where = array('e.e_working_status'=>1,'e.e_delete'=>'0');
	$data['sel_emp'] = 'all';
	}
	}else{
		redirect(base_url());
	}  
	$data["empallData"]=$this->hr->employee_details(array('e.e_delete'=>'0'));	
	$data["empData"]=$this->hr->employee_details($where);	
	$data['page_type']=$page_type; 
	//$data["view"]="timesheet/timesheet_mgt_page";
	$data["view"]="timesheet/timesheet_mgt_tab";
	$this->load->view("layout",$data); 
	}
	
	/*public function ajax_timesheet_list(){
		$status = $this->input->post('status');
		$page_type = $this->input->post('page_type');
		$post_data = $_POST;
		$data['tm_Arr']= $this->ts->tm_role($page_type);
		$data['status'] = $status;
		$data['page_type']=$page_type;
		$data['timsheetData'] = $this->ts->timesheet_list_search($post_data);
		$this->load->view("timesheet/ajax_timesheet_list",$data);
	}*/
	
	//----- USER DATA DISPLAY IN TABLE -----
    function timesheet_mgt_ajax_list(){
		$session_data=$this->session->userdata('loginData');
		if(isset($session_data) AND $session_data!=""){
		$this->load->library('Ajax_pagination');
        $conditions = array();
        //calc offset number
        $page = $this->input->post('page');
        if(!$page){
            $offset = 0;
        }else{
            $offset = $page;
        }
        //set conditions for search
        
        $per_page = $this->input->post('per_page');
        $status = $this->input->post('status');
		$page_type = $this->input->post('page_type');
		$post_data = $_POST;
		
		$data['status'] = $status;
		$data['page_type']=$page_type;

        if($page_type=='employee_timesheet'){
		$totalRec=count($this->ts->timesheet_ajax_approver_search_fun($conditions,$post_data));
		}else{
        $totalRec = count($this->ts->timesheet_ajax_search_fun($conditions,$post_data));
		}
        // $totalRec = count($this->ts->timesheet_ajax_search_fun($conditions,$post_data));
		  
       $per_page=50;
        //pagination configuration
        $config['target']      = '#timesheet_aj_data';
        $config['base_url']    = base_url()."timesheet/manage_timesheet/$page_type";
        $config['total_rows']  = $totalRec;
        $config['per_page']    = $per_page;
        $config['link_func']   = 'searchFilter';
        $this->ajax_pagination->initialize($config);
        
        //set start and limit
        $conditions['start'] = $offset;
        $conditions['limit'] = $per_page; 
         
        //get posts data
		if($page_type=='employee_timesheet'){
		$data['timsheetData'] = $this->ts->timesheet_ajax_approver_search_fun($conditions,$post_data);
		}else{
		$data['timsheetData'] = $this->ts->timesheet_ajax_search_fun($conditions,$post_data);
		}
        //$data['timsheetData'] = $this->ts->timesheet_ajax_search_fun($conditions,$post_data);
        $data['ttlData']=$totalRec;
        //load the view
            
        $this->load->view('timesheet/timesheet_mgt_ajax_list', $data, false);
		}else{
		redirect(base_url());
		} 
    }
	


} // END : CONTROLLER CLASS
?>