<?php defined('BASEPATH') OR exit('No direct script access allowed');

class Ext_timesheet extends CI_Controller {

	function __construct(){
		parent:: __construct();
		$this->load->model("alldata","model"); 
		$this->pms_email = 'timesheet.adm@tamsinfotech.com';
		$this->load->model("timesheet_model","ts");
	}
 
	public function timesheet($enc_t_id="",$url_email="")
	{
		$this->load->model("timesheet_model","ts");
		$t_id = $this->model->decryptdata($enc_t_id);
		$url_email = strtolower($url_email);
		$empExist=$this->model->DetailData("tbl_employee",array('LOWER(e_office_email_id)'=>$url_email));
		if(count($empExist) > 0){
			$e_id =$empExist[0]['e_id'];
			$session_data=$this->session->userdata('loginData');
			if(!isset($session_data) AND $session_data==""){
				$this->load->view("login"); 
			}else{ 
				if($session_data['type']=='employee'){ 
					if($e_id!=$session_data['e_id']){
					$this->load->view("login");
					}else{
					redirect("timesheet/view_timesheet/$enc_t_id/employee_timesheet/$url_email");
					}
				}else{
					$this->load->view("login");
				}
			}
		}else{
			$mgrExist=$this->model->DetailData("tbl_manager",array('LOWER(m_email)'=>$url_email));
			if(count($mgrExist) == 0 ){ 
					$data['mgr_reg_email']=$url_email;
					$data['country_code']=$this->model->sortingWheredata('*','tbl_country_code','NULL','country_name ASC');
					$this->load->view("timesheet/ext_mgr/manager_registration",$data);
				}else{
				$session_data=$this->session->userdata('managerSession');
				if(!isset($session_data) AND $session_data==""){
					$this->load->view("timesheet/ext_mgr/manager_login");
				}else{
					if($url_email!=strtolower($session_data['m_email'])){
						$this->load->view("timesheet/ext_mgr/manager_login");
					}else{
						redirect("ext_timesheet/view_timesheet/$enc_t_id/$url_email");
					}
				}
				}
		}
	}
	 
	public function view_timesheet($enc_t_id=""){
		//echo "View Ext $url_email";
		$t_id = $this->model->decryptdata($enc_t_id);
		$session_data=$this->session->userdata('managerSession'); 
		if(!isset($session_data) AND $session_data==""){
					$this->load->view("timesheet/ext_mgr/manager_login");
		}else{
		$url_email = strtolower($session_data['m_email']);
		$data['enc_t_id']=$enc_t_id;
		$data['url_email']=strtolower($url_email);
		$data['page_type']='ext_manager';
		
		$user_type="approver";
		$where = "t.t_id = $t_id AND t.t_unlock=0 AND IF(td.td_type='Billable', LOWER(pa.email),LOWER(sup.e_office_email_id)) = '$url_email'";
		$data['user_type']='manager';	// Store val when user type = supervior
	 
		$data['getData']=$this->ts->tm_data_list($where);
		if(count($data['getData']) <=0){  redirect("welcome/not_found_page/ext_mgr"); }
		$t_holiday = $data['getData'][0]['t_holiday'];
		
			$exp_hol = explode('|-|',$t_holiday);
			$hol_Arr = [];
			foreach ($exp_hol as $k) { 
			$exp_hols = explode('|',$k);
			$hol_Arr[] = $exp_hols[0];
			} 
			$data["holidays"] = $hol_Arr;  
		
			
		
		$this->load->view("timesheet/ext_mgr/view_timesheet",$data); 
		}
	}
	
	public function timesheet_list(){
		
	
		$this->load->view("timesheet/ext_mgr/ext_mgr_timesheet_list");
	}
	
	//----- USER DATA DISPLAY IN TABLE -----
    function ext_mgr_timesheet_ajax_list(){
		$this->load->model("timesheet_model","ts");
		
		$this->load->library('Ajax_pagination');
        $conditions = array();
        //calc offset number
        $page = $this->input->post('page');
        if(!$page){
            $offset = 0;
        }else{
            $offset = $page;
        }
        //set conditions for search
        
        $per_page = $this->input->post('per_page');
        $status = $this->input->post('status');
		$page_type = $this->input->post('page_type');
		$post_data = $_POST;
		
		$data['status'] = $status;
		$data['page_type'] = $page_type;
		

		$totalRec=count($this->ts->timesheet_ajax_search_list($conditions,$post_data));
		$per_page=20;
        //pagination configuration
        $config['target']      = '#timesheet_aj_data';
        $config['base_url']    = base_url()."ext_timesheet/timesheet_list";
        $config['total_rows']  = $totalRec;
        $config['per_page']    = $per_page;
        $config['link_func']   = 'searchFilter';
        $this->ajax_pagination->initialize($config);
        
        //set start and limit
        $conditions['start'] = $offset;
        $conditions['limit'] = $per_page; 
		$data['timsheetData'] = $this->ts->timesheet_ajax_search_list($conditions,$post_data);
		$data['ttlData']=$totalRec;
        $this->load->view('timesheet/ext_mgr/ext_mgr_timesheet_ajax_list', $data, false);
		
    }
	
	public function view_employee_timesheet($enc_t_id="",$page_type=""){
		$t_id = $this->model->decryptdata($enc_t_id);
		$session_data=$this->session->userdata('loginData');
		$tmData=$this->model->DetailData("tbl_timesheet",array('t_id'=>$t_id));	
		$e_id = $tmData[0]['t_e_id'];
			if(!isset($session_data) AND $session_data==""){
				$this->load->view("login");
			}else{ 
			if($session_data['type']=='employee'){
				if($e_id != $session_data['e_id']){
					$this->load->view("login");
				}else{
					redirect("timesheet/view_timesheet/$enc_t_id/$page_type");
				}  
			}else{
				$this->load->view("login");
			}
			}
	}
	
	
	
	
	
	
	
	

}
