<?php 
view_timesheet_data (use in report)
-----------
CREATE view view_timesheet_data AS 
SELECT td.td_id, td.t_id, td.td_date, DAYNAME(td.td_date) AS td_day, td.td_type, td.td_client,
if(td.td_type='Billable', CONCAT(c.clnt_code_pre, `c`.`clnt_code`, pr.prj_chrg_code), ta.ta_charge_code) AS project_code, 
if(td.td_type='Billable', `pr`.`prj_nm`, ta.ta_name) AS project_name, 
c.clnt_id,
c.clnt_name,
td.td_activity, 
td.td_working_hrs, 
(CASE 
   WHEN td.td_status='A' THEN 'approved'
   WHEN td.td_status='P' THEN 'pending'
   WHEN td.td_status='R' THEN 'rejected'
   WHEN td.td_status='S' THEN 'save'
   ELSE td.td_status
END) AS td_status,
td.td_comments
FROM `tbl_timesheet` AS `t`
LEFT JOIN `tbl_employee` as `e` ON `e`.`e_id` = `t`.`t_e_id`
LEFT JOIN `tbl_designation` as `d` ON `d`.`d_id` = `e`.`e_designation`
LEFT JOIN `tbl_employee` as `sup` ON `sup`.`e_id` = `e`.`e_supervisor_employee_id`
LEFT JOIN `tbl_leave_group` as `lg` ON `e`.`e_l_group_id` = `lg`.`lg_id`
LEFT JOIN `tbl_timesheet_data` as `td` ON `td`.`t_id` = `t`.`t_id`
LEFT JOIN `tbl_timesheet_activity` as `ta` ON `ta`.`ta_id` = `td`.`td_client` AND `td`.`td_type`="Non-Billable"
LEFT JOIN `tbl_prj_projects` as `pr` ON `pr`.`prj_id` = `td`.`td_client` AND `td`.`td_type`="Billable"
LEFT JOIN `tbl_prj_clients` as `c` ON `c`.`clnt_id` = `pr`.`clnt_id`
ORDER BY td.t_id, `td`.`td_date` ASC


view_pgs_form (use in report)
-------------------------------

CREATE VIEW view_pgs_form AS 
/*SELECT
`pf_id`,pf_pfa_id,`pf_e_id`,`pf_pa_id`,
CONCAT(e.e_employee_id_pre,e.e_employee_id) AS employee_id,
CONCAT(e.e_first_name," ",e.e_middle_name," ",e.e_last_name) AS e_name,
`pf_obj_phase_end_date`,  
`pf_mid_yr_phase_end_date`, 
`pf_yr_end_phase_end_date`, 
`pf_rating`,
`pf_phase`,
`pf_submit_obj`,
`pf_agree_obj`,
`pf_obj_status`,
`pf_submit_mid_employee`,
`pf_submit_mid_manager`,
`pf_mid_status`,
`pf_submit_end_employee`,
`pf_submit_end_manager`,
`pf_end_status`,
(
    SELECT
    SUM(SUBSTRING_INDEX(SUBSTRING_INDEX(p1.pf_rating, '|-|', numbers.n), '|-|', -1)) AS pf_rating
    FROM
    numbers left join tbl_pgs_form AS p1
    on  (CHAR_LENGTH(REPLACE(p1.pf_rating, '|-|', ''))>=numbers.n)
    WHERE 
    SUBSTRING_INDEX(SUBSTRING_INDEX(p1.pf_rating, '|-|', numbers.n), '|-|', -1) !="" AND p.pf_id = p1.pf_id

) AS pf_total_rating
FROM tbl_pgs_form AS p
left join tbl_employee AS e ON e.e_id = p.pf_e_id*/


----
SELECT
`pf_id`,pf_pfa_id,`pf_e_id`,`pf_pa_id`,
CONCAT(e.e_employee_id_pre,e.e_employee_id) AS employee_id,
CONCAT(e.e_first_name," ",e.e_middle_name," ",e.e_last_name) AS e_name,
`pf_obj_phase_end_date`,  
`pf_mid_yr_phase_end_date`, 
`pf_yr_end_phase_end_date`, 
`pf_rating`,
`pf_phase`,
`pf_submit_obj`,
`pf_agree_obj`,
`pf_obj_status`,
`pf_submit_mid_employee`,
`pf_submit_mid_manager`,
`pf_mid_status`,
`pf_submit_end_employee`,
`pf_submit_end_manager`,
`pf_end_status`,
FORMAT(
    (SELECT
    (SUM(SUBSTRING_INDEX(SUBSTRING_INDEX(p1.pf_rating, '|-|', numbers.n), '|-|', -1))/(CHAR_LENGTH(REPLACE(p1.pf_rating, '|-|', ',')) -
CHAR_LENGTH(REPLACE(REPLACE(p1.pf_rating, '|-|', ','), ',', '')) + 1))AS pf_rating
    FROM
    numbers left join tbl_pgs_form AS p1
    on  ((CHAR_LENGTH(REPLACE(p1.pf_rating, '|-|', ',')) -
CHAR_LENGTH(REPLACE(REPLACE(p1.pf_rating, '|-|', ','), ',', '')) + 1)>=numbers.n)
    WHERE 
    SUBSTRING_INDEX(SUBSTRING_INDEX(p1.pf_rating, '|-|', numbers.n), '|-|', -1) !="" AND p.pf_id = p1.pf_id),2

) AS pf_total_rating
FROM tbl_pgs_form AS p
left join tbl_employee AS e ON e.e_id = p.pf_e_id 


================================================

CREATE View view_project_book_working_hrs AS
SELECT t.t_e_id,td.`td_client`,

(SELECT SUM(td1.`td_working_hrs`)
FROM `tbl_timesheet` AS `t1`
LEFT JOIN `tbl_timesheet_data` as `td1` ON `td1`.`t_id` = `t1`.`t_id`
WHERE t1.t_e_id=t.t_e_id AND `td1`.`td_type` = 'Billable' AND `t1`.`t_year` = '2019'  AND MONTH(td1.`td_date`)=1 AND td1.td_client=td.td_client
) AS JAN,
(SELECT SUM(td1.`td_working_hrs`)
FROM `tbl_timesheet` AS `t1`
LEFT JOIN `tbl_timesheet_data` as `td1` ON `td1`.`t_id` = `t1`.`t_id`
WHERE t1.t_e_id=t.t_e_id AND `td1`.`td_type` = 'Billable' AND `t1`.`t_year` = '2019'  AND MONTH(td1.`td_date`)=2 AND td1.td_client=td.td_client
) AS FEB,
(SELECT SUM(td1.`td_working_hrs`)
FROM `tbl_timesheet` AS `t1`
LEFT JOIN `tbl_timesheet_data` as `td1` ON `td1`.`t_id` = `t1`.`t_id`
WHERE t1.t_e_id=t.t_e_id AND `td1`.`td_type` = 'Billable' AND `t1`.`t_year` = '2019'  AND MONTH(td1.`td_date`)=3 AND td1.td_client=td.td_client
) AS MAR,
(SELECT SUM(td1.`td_working_hrs`)
FROM `tbl_timesheet` AS `t1`
LEFT JOIN `tbl_timesheet_data` as `td1` ON `td1`.`t_id` = `t1`.`t_id`
WHERE t1.t_e_id=t.t_e_id AND `td1`.`td_type` = 'Billable' AND `t1`.`t_year` = '2019'  AND MONTH(td1.`td_date`)=4 AND td1.td_client=td.td_client
) AS APR,
(SELECT SUM(td1.`td_working_hrs`)
FROM `tbl_timesheet` AS `t1`
LEFT JOIN `tbl_timesheet_data` as `td1` ON `td1`.`t_id` = `t1`.`t_id`
WHERE t1.t_e_id=t.t_e_id AND `td1`.`td_type` = 'Billable' AND `t1`.`t_year` = '2019'  AND MONTH(td1.`td_date`)=5 AND td1.td_client=td.td_client
) AS MAY,
(SELECT SUM(td1.`td_working_hrs`)
FROM `tbl_timesheet` AS `t1`
LEFT JOIN `tbl_timesheet_data` as `td1` ON `td1`.`t_id` = `t1`.`t_id`
WHERE t1.t_e_id=t.t_e_id AND `td1`.`td_type` = 'Billable' AND `t1`.`t_year` = '2019'  AND MONTH(td1.`td_date`)=6 AND td1.td_client=td.td_client
) AS JUN,
(SELECT SUM(td1.`td_working_hrs`)
FROM `tbl_timesheet` AS `t1`
LEFT JOIN `tbl_timesheet_data` as `td1` ON `td1`.`t_id` = `t1`.`t_id`
WHERE t1.t_e_id=t.t_e_id AND `td1`.`td_type` = 'Billable' AND `t1`.`t_year` = '2019'  AND MONTH(td1.`td_date`)=7 AND td1.td_client=td.td_client
) AS JUL,
(SELECT SUM(td1.`td_working_hrs`)
FROM `tbl_timesheet` AS `t1`
LEFT JOIN `tbl_timesheet_data` as `td1` ON `td1`.`t_id` = `t1`.`t_id`
WHERE t1.t_e_id=t.t_e_id AND `td1`.`td_type` = 'Billable' AND `t1`.`t_year` = '2019'  AND MONTH(td1.`td_date`)=8 AND td1.td_client=td.td_client
) AS AUG,
(SELECT SUM(td1.`td_working_hrs`)
FROM `tbl_timesheet` AS `t1`
LEFT JOIN `tbl_timesheet_data` as `td1` ON `td1`.`t_id` = `t1`.`t_id`
WHERE t1.t_e_id=t.t_e_id AND `td1`.`td_type` = 'Billable' AND `t1`.`t_year` = '2019'  AND MONTH(td1.`td_date`)=9 AND td1.td_client=td.td_client
) AS SEP,
(SELECT SUM(td1.`td_working_hrs`)
FROM `tbl_timesheet` AS `t1`
LEFT JOIN `tbl_timesheet_data` as `td1` ON `td1`.`t_id` = `t1`.`t_id`
WHERE t1.t_e_id=t.t_e_id AND `td1`.`td_type` = 'Billable' AND `t1`.`t_year` = '2019'  AND MONTH(td1.`td_date`)=10 AND td1.td_client=td.td_client
) AS OCT,
(SELECT SUM(td1.`td_working_hrs`)
FROM `tbl_timesheet` AS `t1`
LEFT JOIN `tbl_timesheet_data` as `td1` ON `td1`.`t_id` = `t1`.`t_id`
WHERE t1.t_e_id=t.t_e_id AND `td1`.`td_type` = 'Billable' AND `t1`.`t_year` = '2019'  AND MONTH(td1.`td_date`)=11 AND td1.td_client=td.td_client
) AS NOV,
(SELECT SUM(td1.`td_working_hrs`)
FROM `tbl_timesheet` AS `t1`
LEFT JOIN `tbl_timesheet_data` as `td1` ON `td1`.`t_id` = `t1`.`t_id`
WHERE t1.t_e_id=t.t_e_id AND `td1`.`td_type` = 'Billable' AND `t1`.`t_year` = '2019'  AND MONTH(td1.`td_date`)=12 AND td1.td_client=td.td_client
) AS DECm,
(SELECT SUM(td1.`td_working_hrs`)
FROM `tbl_timesheet` AS `t1`
LEFT JOIN `tbl_timesheet_data` as `td1` ON `td1`.`t_id` = `t1`.`t_id`
WHERE t1.t_e_id=t.t_e_id AND `td1`.`td_type` = 'Billable' AND `t1`.`t_year` = '2019'  AND QUARTER(td1.`td_date`)=1 AND td1.td_client=td.td_client
) AS Q1,
(SELECT SUM(td1.`td_working_hrs`)
FROM `tbl_timesheet` AS `t1`
LEFT JOIN `tbl_timesheet_data` as `td1` ON `td1`.`t_id` = `t1`.`t_id`
WHERE t1.t_e_id=t.t_e_id AND `td1`.`td_type` = 'Billable' AND `t1`.`t_year` = '2019'  AND QUARTER(td1.`td_date`)=2 AND td1.td_client=td.td_client
) AS Q2,
(SELECT SUM(td1.`td_working_hrs`)
FROM `tbl_timesheet` AS `t1`
LEFT JOIN `tbl_timesheet_data` as `td1` ON `td1`.`t_id` = `t1`.`t_id`
WHERE t1.t_e_id=t.t_e_id AND `td1`.`td_type` = 'Billable' AND `t1`.`t_year` = '2019'  AND QUARTER(td1.`td_date`)=3 AND td1.td_client=td.td_client
) AS Q3,
(SELECT SUM(td1.`td_working_hrs`)
FROM `tbl_timesheet` AS `t1`
LEFT JOIN `tbl_timesheet_data` as `td1` ON `td1`.`t_id` = `t1`.`t_id`
WHERE t1.t_e_id=t.t_e_id AND `td1`.`td_type` = 'Billable' AND `t1`.`t_year` = '2019'  AND QUARTER(td1.`td_date`)=4 AND td1.td_client=td.td_client
) AS Q4,
(SELECT SUM(td1.`td_working_hrs`)
FROM `tbl_timesheet` AS `t1`
LEFT JOIN `tbl_timesheet_data` as `td1` ON `td1`.`t_id` = `t1`.`t_id`
WHERE t1.t_e_id=t.t_e_id AND `td1`.`td_type` = 'Billable' AND `t1`.`t_year` = '2019'  AND (td1.`td_date` BETWEEN  CONCAT(`t1`.`t_year`,'-01-01') AND CONCAT(`t1`.`t_year`,'-06-30')) AND td1.td_client=td.td_client
) AS first_half,
(SELECT SUM(td1.`td_working_hrs`)
FROM `tbl_timesheet` AS `t1`
LEFT JOIN `tbl_timesheet_data` as `td1` ON `td1`.`t_id` = `t1`.`t_id`
WHERE t1.t_e_id=t.t_e_id AND `td1`.`td_type` = 'Billable' AND `t1`.`t_year` = '2019'  AND (td1.`td_date` BETWEEN  CONCAT(`t1`.`t_year`,'-07-01') AND CONCAT(`t1`.`t_year`,'-12-31')) AND td1.td_client=td.td_client
) AS second_half,
(SELECT SUM(td1.`td_working_hrs`)
FROM `tbl_timesheet` AS `t1`
LEFT JOIN `tbl_timesheet_data` as `td1` ON `td1`.`t_id` = `t1`.`t_id`
WHERE t1.t_e_id=t.t_e_id AND `td1`.`td_type` = 'Billable' AND `t1`.`t_year` = '2019'  AND YEAR(td1.`td_date`)=2019 AND td1.td_client=td.td_client
) AS yearly

FROM `tbl_timesheet` AS `t`
LEFT JOIN `tbl_timesheet_data` as `td` ON `td`.`t_id` = `t`.`t_id`
WHERE `td`.`td_type` = 'Billable' AND `t`.`t_year` = '2019' 
GROUP By t.t_e_id,`td_client`

//==================================

SELECT `t`.`t_year`,t.t_e_id,td.`td_client`,

(SELECT SUM(td1.`td_working_hrs`)
FROM `tbl_timesheet` AS `t1`
LEFT JOIN `tbl_timesheet_data` as `td1` ON `td1`.`t_id` = `t1`.`t_id`
WHERE t1.t_e_id=t.t_e_id AND `td1`.`td_type` = 'Billable' AND `t1`.`t_year` = `t`.`t_year`  AND MONTH(td1.`td_date`)=1 AND td1.td_client=td.td_client
) AS JAN,
(SELECT SUM(td1.`td_working_hrs`)
FROM `tbl_timesheet` AS `t1`
LEFT JOIN `tbl_timesheet_data` as `td1` ON `td1`.`t_id` = `t1`.`t_id`
WHERE t1.t_e_id=t.t_e_id AND `td1`.`td_type` = 'Billable' AND `t1`.`t_year` = `t`.`t_year`  AND MONTH(td1.`td_date`)=2 AND td1.td_client=td.td_client
) AS FEB,
(SELECT SUM(td1.`td_working_hrs`)
FROM `tbl_timesheet` AS `t1`
LEFT JOIN `tbl_timesheet_data` as `td1` ON `td1`.`t_id` = `t1`.`t_id`
WHERE t1.t_e_id=t.t_e_id AND `td1`.`td_type` = 'Billable' AND `t1`.`t_year` = `t`.`t_year`  AND MONTH(td1.`td_date`)=3 AND td1.td_client=td.td_client
) AS MAR,
(SELECT SUM(td1.`td_working_hrs`)
FROM `tbl_timesheet` AS `t1`
LEFT JOIN `tbl_timesheet_data` as `td1` ON `td1`.`t_id` = `t1`.`t_id`
WHERE t1.t_e_id=t.t_e_id AND `td1`.`td_type` = 'Billable' AND `t1`.`t_year` = `t`.`t_year`  AND MONTH(td1.`td_date`)=4 AND td1.td_client=td.td_client
) AS APR,
(SELECT SUM(td1.`td_working_hrs`)
FROM `tbl_timesheet` AS `t1`
LEFT JOIN `tbl_timesheet_data` as `td1` ON `td1`.`t_id` = `t1`.`t_id`
WHERE t1.t_e_id=t.t_e_id AND `td1`.`td_type` = 'Billable' AND `t1`.`t_year` = `t`.`t_year`  AND MONTH(td1.`td_date`)=5 AND td1.td_client=td.td_client
) AS MAY,
(SELECT SUM(td1.`td_working_hrs`)
FROM `tbl_timesheet` AS `t1`
LEFT JOIN `tbl_timesheet_data` as `td1` ON `td1`.`t_id` = `t1`.`t_id`
WHERE t1.t_e_id=t.t_e_id AND `td1`.`td_type` = 'Billable' AND `t1`.`t_year` = `t`.`t_year`  AND MONTH(td1.`td_date`)=6 AND td1.td_client=td.td_client
) AS JUN,
(SELECT SUM(td1.`td_working_hrs`)
FROM `tbl_timesheet` AS `t1`
LEFT JOIN `tbl_timesheet_data` as `td1` ON `td1`.`t_id` = `t1`.`t_id`
WHERE t1.t_e_id=t.t_e_id AND `td1`.`td_type` = 'Billable' AND `t1`.`t_year` = `t`.`t_year`  AND MONTH(td1.`td_date`)=7 AND td1.td_client=td.td_client
) AS JUL,
(SELECT SUM(td1.`td_working_hrs`)
FROM `tbl_timesheet` AS `t1`
LEFT JOIN `tbl_timesheet_data` as `td1` ON `td1`.`t_id` = `t1`.`t_id`
WHERE t1.t_e_id=t.t_e_id AND `td1`.`td_type` = 'Billable' AND `t1`.`t_year` = `t`.`t_year`  AND MONTH(td1.`td_date`)=8 AND td1.td_client=td.td_client
) AS AUG,
(SELECT SUM(td1.`td_working_hrs`)
FROM `tbl_timesheet` AS `t1`
LEFT JOIN `tbl_timesheet_data` as `td1` ON `td1`.`t_id` = `t1`.`t_id`
WHERE t1.t_e_id=t.t_e_id AND `td1`.`td_type` = 'Billable' AND `t1`.`t_year` = `t`.`t_year`  AND MONTH(td1.`td_date`)=9 AND td1.td_client=td.td_client
) AS SEP,
(SELECT SUM(td1.`td_working_hrs`)
FROM `tbl_timesheet` AS `t1`
LEFT JOIN `tbl_timesheet_data` as `td1` ON `td1`.`t_id` = `t1`.`t_id`
WHERE t1.t_e_id=t.t_e_id AND `td1`.`td_type` = 'Billable' AND `t1`.`t_year` = `t`.`t_year`  AND MONTH(td1.`td_date`)=10 AND td1.td_client=td.td_client
) AS OCT,
(SELECT SUM(td1.`td_working_hrs`)
FROM `tbl_timesheet` AS `t1`
LEFT JOIN `tbl_timesheet_data` as `td1` ON `td1`.`t_id` = `t1`.`t_id`
WHERE t1.t_e_id=t.t_e_id AND `td1`.`td_type` = 'Billable' AND `t1`.`t_year` = `t`.`t_year`  AND MONTH(td1.`td_date`)=11 AND td1.td_client=td.td_client
) AS NOV,
(SELECT SUM(td1.`td_working_hrs`)
FROM `tbl_timesheet` AS `t1`
LEFT JOIN `tbl_timesheet_data` as `td1` ON `td1`.`t_id` = `t1`.`t_id`
WHERE t1.t_e_id=t.t_e_id AND `td1`.`td_type` = 'Billable' AND `t1`.`t_year` = `t`.`t_year`  AND MONTH(td1.`td_date`)=12 AND td1.td_client=td.td_client
) AS DECm,
(SELECT SUM(td1.`td_working_hrs`)
FROM `tbl_timesheet` AS `t1`
LEFT JOIN `tbl_timesheet_data` as `td1` ON `td1`.`t_id` = `t1`.`t_id`
WHERE t1.t_e_id=t.t_e_id AND `td1`.`td_type` = 'Billable' AND `t1`.`t_year` = `t`.`t_year`  AND QUARTER(td1.`td_date`)=1 AND td1.td_client=td.td_client
) AS Q1,
(SELECT SUM(td1.`td_working_hrs`)
FROM `tbl_timesheet` AS `t1`
LEFT JOIN `tbl_timesheet_data` as `td1` ON `td1`.`t_id` = `t1`.`t_id`
WHERE t1.t_e_id=t.t_e_id AND `td1`.`td_type` = 'Billable' AND `t1`.`t_year` = `t`.`t_year`  AND QUARTER(td1.`td_date`)=2 AND td1.td_client=td.td_client
) AS Q2,
(SELECT SUM(td1.`td_working_hrs`)
FROM `tbl_timesheet` AS `t1`
LEFT JOIN `tbl_timesheet_data` as `td1` ON `td1`.`t_id` = `t1`.`t_id`
WHERE t1.t_e_id=t.t_e_id AND `td1`.`td_type` = 'Billable' AND `t1`.`t_year` = `t`.`t_year`  AND QUARTER(td1.`td_date`)=3 AND td1.td_client=td.td_client
) AS Q3,
(SELECT SUM(td1.`td_working_hrs`)
FROM `tbl_timesheet` AS `t1`
LEFT JOIN `tbl_timesheet_data` as `td1` ON `td1`.`t_id` = `t1`.`t_id`
WHERE t1.t_e_id=t.t_e_id AND `td1`.`td_type` = 'Billable' AND `t1`.`t_year` = `t`.`t_year`  AND QUARTER(td1.`td_date`)=4 AND td1.td_client=td.td_client
) AS Q4,
(SELECT SUM(td1.`td_working_hrs`)
FROM `tbl_timesheet` AS `t1`
LEFT JOIN `tbl_timesheet_data` as `td1` ON `td1`.`t_id` = `t1`.`t_id`
WHERE t1.t_e_id=t.t_e_id AND `td1`.`td_type` = 'Billable' AND `t1`.`t_year` = `t`.`t_year`  AND (td1.`td_date` BETWEEN  CONCAT(`t1`.`t_year`,'-01-01') AND CONCAT(`t1`.`t_year`,'-06-30')) AND td1.td_client=td.td_client
) AS first_half,
(SELECT SUM(td1.`td_working_hrs`)
FROM `tbl_timesheet` AS `t1`
LEFT JOIN `tbl_timesheet_data` as `td1` ON `td1`.`t_id` = `t1`.`t_id`
WHERE t1.t_e_id=t.t_e_id AND `td1`.`td_type` = 'Billable' AND `t1`.`t_year` = `t`.`t_year`  AND (td1.`td_date` BETWEEN  CONCAT(`t1`.`t_year`,'-07-01') AND CONCAT(`t1`.`t_year`,'-12-31')) AND td1.td_client=td.td_client
) AS second_half,
(SELECT SUM(td1.`td_working_hrs`)
FROM `tbl_timesheet` AS `t1`
LEFT JOIN `tbl_timesheet_data` as `td1` ON `td1`.`t_id` = `t1`.`t_id`
WHERE t1.t_e_id=t.t_e_id AND `td1`.`td_type` = 'Billable' AND `t1`.`t_year` = `t`.`t_year`  AND YEAR(td1.`td_date`)=2019 AND td1.td_client=td.td_client
) AS yearly

FROM `tbl_timesheet` AS `t`
LEFT JOIN `tbl_timesheet_data` as `td` ON `td`.`t_id` = `t`.`t_id`
WHERE `td`.`td_type` = 'Billable'
GROUP By `t`.`t_year`,t.t_e_id,`td_client`

=============================
SELECT `t`.`t_year`,t.t_e_id,td.`td_client`,

(SELECT SUM(td1.`td_working_hrs`)
FROM `tbl_timesheet` AS `t1`
LEFT JOIN `tbl_timesheet_data` as `td1` ON `td1`.`t_id` = `t1`.`t_id`
WHERE t1.t_e_id=t.t_e_id AND `td1`.`td_type` = 'Billable' AND `t1`.`t_year` = `t`.`t_year`  AND MONTH(td1.`td_date`)=1 AND td1.td_client=td.td_client
) AS january,
(SELECT SUM(td1.`td_working_hrs`)
FROM `tbl_timesheet` AS `t1`
LEFT JOIN `tbl_timesheet_data` as `td1` ON `td1`.`t_id` = `t1`.`t_id`
WHERE t1.t_e_id=t.t_e_id AND `td1`.`td_type` = 'Billable' AND `t1`.`t_year` = `t`.`t_year`  AND MONTH(td1.`td_date`)=2 AND td1.td_client=td.td_client
) AS february,
(SELECT SUM(td1.`td_working_hrs`)
FROM `tbl_timesheet` AS `t1`
LEFT JOIN `tbl_timesheet_data` as `td1` ON `td1`.`t_id` = `t1`.`t_id`
WHERE t1.t_e_id=t.t_e_id AND `td1`.`td_type` = 'Billable' AND `t1`.`t_year` = `t`.`t_year`  AND MONTH(td1.`td_date`)=3 AND td1.td_client=td.td_client
) AS march,
(SELECT SUM(td1.`td_working_hrs`)
FROM `tbl_timesheet` AS `t1`
LEFT JOIN `tbl_timesheet_data` as `td1` ON `td1`.`t_id` = `t1`.`t_id`
WHERE t1.t_e_id=t.t_e_id AND `td1`.`td_type` = 'Billable' AND `t1`.`t_year` = `t`.`t_year`  AND MONTH(td1.`td_date`)=4 AND td1.td_client=td.td_client
) AS april,
(SELECT SUM(td1.`td_working_hrs`)
FROM `tbl_timesheet` AS `t1`
LEFT JOIN `tbl_timesheet_data` as `td1` ON `td1`.`t_id` = `t1`.`t_id`
WHERE t1.t_e_id=t.t_e_id AND `td1`.`td_type` = 'Billable' AND `t1`.`t_year` = `t`.`t_year`  AND MONTH(td1.`td_date`)=5 AND td1.td_client=td.td_client
) AS may,
(SELECT SUM(td1.`td_working_hrs`)
FROM `tbl_timesheet` AS `t1`
LEFT JOIN `tbl_timesheet_data` as `td1` ON `td1`.`t_id` = `t1`.`t_id`
WHERE t1.t_e_id=t.t_e_id AND `td1`.`td_type` = 'Billable' AND `t1`.`t_year` = `t`.`t_year`  AND MONTH(td1.`td_date`)=6 AND td1.td_client=td.td_client
) AS june,
(SELECT SUM(td1.`td_working_hrs`)
FROM `tbl_timesheet` AS `t1`
LEFT JOIN `tbl_timesheet_data` as `td1` ON `td1`.`t_id` = `t1`.`t_id`
WHERE t1.t_e_id=t.t_e_id AND `td1`.`td_type` = 'Billable' AND `t1`.`t_year` = `t`.`t_year`  AND MONTH(td1.`td_date`)=7 AND td1.td_client=td.td_client
) AS july,
(SELECT SUM(td1.`td_working_hrs`)
FROM `tbl_timesheet` AS `t1`
LEFT JOIN `tbl_timesheet_data` as `td1` ON `td1`.`t_id` = `t1`.`t_id`
WHERE t1.t_e_id=t.t_e_id AND `td1`.`td_type` = 'Billable' AND `t1`.`t_year` = `t`.`t_year`  AND MONTH(td1.`td_date`)=8 AND td1.td_client=td.td_client
) AS august,
(SELECT SUM(td1.`td_working_hrs`)
FROM `tbl_timesheet` AS `t1`
LEFT JOIN `tbl_timesheet_data` as `td1` ON `td1`.`t_id` = `t1`.`t_id`
WHERE t1.t_e_id=t.t_e_id AND `td1`.`td_type` = 'Billable' AND `t1`.`t_year` = `t`.`t_year`  AND MONTH(td1.`td_date`)=9 AND td1.td_client=td.td_client
) AS september,
(SELECT SUM(td1.`td_working_hrs`)
FROM `tbl_timesheet` AS `t1`
LEFT JOIN `tbl_timesheet_data` as `td1` ON `td1`.`t_id` = `t1`.`t_id`
WHERE t1.t_e_id=t.t_e_id AND `td1`.`td_type` = 'Billable' AND `t1`.`t_year` = `t`.`t_year`  AND MONTH(td1.`td_date`)=10 AND td1.td_client=td.td_client
) AS october,
(SELECT SUM(td1.`td_working_hrs`)
FROM `tbl_timesheet` AS `t1`
LEFT JOIN `tbl_timesheet_data` as `td1` ON `td1`.`t_id` = `t1`.`t_id`
WHERE t1.t_e_id=t.t_e_id AND `td1`.`td_type` = 'Billable' AND `t1`.`t_year` = `t`.`t_year`  AND MONTH(td1.`td_date`)=11 AND td1.td_client=td.td_client
) AS november,
(SELECT SUM(td1.`td_working_hrs`)
FROM `tbl_timesheet` AS `t1`
LEFT JOIN `tbl_timesheet_data` as `td1` ON `td1`.`t_id` = `t1`.`t_id`
WHERE t1.t_e_id=t.t_e_id AND `td1`.`td_type` = 'Billable' AND `t1`.`t_year` = `t`.`t_year`  AND MONTH(td1.`td_date`)=12 AND td1.td_client=td.td_client
) AS december,
(SELECT SUM(td1.`td_working_hrs`)
FROM `tbl_timesheet` AS `t1`
LEFT JOIN `tbl_timesheet_data` as `td1` ON `td1`.`t_id` = `t1`.`t_id`
WHERE t1.t_e_id=t.t_e_id AND `td1`.`td_type` = 'Billable' AND `t1`.`t_year` = `t`.`t_year`  AND QUARTER(td1.`td_date`)=1 AND td1.td_client=td.td_client
) AS quarter_1,
(SELECT SUM(td1.`td_working_hrs`)
FROM `tbl_timesheet` AS `t1`
LEFT JOIN `tbl_timesheet_data` as `td1` ON `td1`.`t_id` = `t1`.`t_id`
WHERE t1.t_e_id=t.t_e_id AND `td1`.`td_type` = 'Billable' AND `t1`.`t_year` = `t`.`t_year`  AND QUARTER(td1.`td_date`)=2 AND td1.td_client=td.td_client
) AS quarter_2,
(SELECT SUM(td1.`td_working_hrs`)
FROM `tbl_timesheet` AS `t1`
LEFT JOIN `tbl_timesheet_data` as `td1` ON `td1`.`t_id` = `t1`.`t_id`
WHERE t1.t_e_id=t.t_e_id AND `td1`.`td_type` = 'Billable' AND `t1`.`t_year` = `t`.`t_year`  AND QUARTER(td1.`td_date`)=3 AND td1.td_client=td.td_client
) AS quarter_3,
(SELECT SUM(td1.`td_working_hrs`)
FROM `tbl_timesheet` AS `t1`
LEFT JOIN `tbl_timesheet_data` as `td1` ON `td1`.`t_id` = `t1`.`t_id`
WHERE t1.t_e_id=t.t_e_id AND `td1`.`td_type` = 'Billable' AND `t1`.`t_year` = `t`.`t_year`  AND QUARTER(td1.`td_date`)=4 AND td1.td_client=td.td_client
) AS quarter_4,
(SELECT SUM(td1.`td_working_hrs`)
FROM `tbl_timesheet` AS `t1`
LEFT JOIN `tbl_timesheet_data` as `td1` ON `td1`.`t_id` = `t1`.`t_id`
WHERE t1.t_e_id=t.t_e_id AND `td1`.`td_type` = 'Billable' AND `t1`.`t_year` = `t`.`t_year`  AND (td1.`td_date` BETWEEN  CONCAT(`t1`.`t_year`,'-01-01') AND CONCAT(`t1`.`t_year`,'-06-30')) AND td1.td_client=td.td_client
) AS first_half,
(SELECT SUM(td1.`td_working_hrs`)
FROM `tbl_timesheet` AS `t1`
LEFT JOIN `tbl_timesheet_data` as `td1` ON `td1`.`t_id` = `t1`.`t_id`
WHERE t1.t_e_id=t.t_e_id AND `td1`.`td_type` = 'Billable' AND `t1`.`t_year` = `t`.`t_year`  AND (td1.`td_date` BETWEEN  CONCAT(`t1`.`t_year`,'-07-01') AND CONCAT(`t1`.`t_year`,'-12-31')) AND td1.td_client=td.td_client
) AS second_half,
(SELECT SUM(td1.`td_working_hrs`)
FROM `tbl_timesheet` AS `t1`
LEFT JOIN `tbl_timesheet_data` as `td1` ON `td1`.`t_id` = `t1`.`t_id`
WHERE t1.t_e_id=t.t_e_id AND `td1`.`td_type` = 'Billable' AND `t1`.`t_year` = `t`.`t_year`  AND YEAR(td1.`td_date`)=2019 AND td1.td_client=td.td_client
) AS yearly

FROM `tbl_timesheet` AS `t`
LEFT JOIN `tbl_timesheet_data` as `td` ON `td`.`t_id` = `t`.`t_id`
WHERE `td`.`td_type` = 'Billable'
GROUP By `t`.`t_year`,t.t_e_id,`td_client`