<?php ob_start();
defined("BASEPATH") OR exit("No direct script access allowed");
class Timesheet extends CI_Controller {
	function __construct(){
		parent:: __construct();
		$this->load->model("alldata","model");
		$this->load->model("hr_model","hr");
		$this->load->model("timesheet_model","ts");
		$this->pms_email = 'timesheet.adm@tamsinfotech.com';
	}
 
	public function index()
	{
		echo "Not Found"; 
	}
 
	public function activity(){
		$data["getData"]=$this->model->sortingWheredata("*,(SELECT count(td_id) as cnt from tbl_timesheet_data where td_client = `ta_id` AND td_type='Non-Billable') as cnt","tbl_timesheet_activity","NULL",'ta_type ASC');
		$data["view"]="timesheet/activity/activity_mgt";
		$this->load->view("layout",$data);
	}
 
	//------- DELETE activity -------
	public function delete_activity($ency_id){ 
	    $id = $this->model->decryptdata($ency_id);
	    $where=array("ta_id"=>$id);           
		$data=$this->model->DetailData("tbl_timesheet_activity",$where);		
	    $this->model->DeleteData("tbl_timesheet_activity",$where);
		
		$old='ta_type|Type|'.$data[0]['ta_type'].'|-|ta_name|Activity Name|'.$data[0]['ta_name'].'|-|ta_charge_code|Charge Code|'.$data[0]['ta_charge_code'].'|-|ta_working_hrs|Working Hrs|'.$data[0]['ta_working_hrs'];
		$ins_arr=$this->model->history_module($id,"delete_charge_code|Delete Charge Code",$old,"",'tbl_timesheet_activity','Charge Code Management','delete');
		$this->model->insertData("tbl_update_history",$ins_arr);
		$id = $this->db->insert_id();
		$old='ta_type|Type|'.$this->input->post('ta_type').'|-|ta_name|Activity Name|'.$this->input->post('ta_name').'|-|ta_charge_code|Charge Code|'.$this->input->post('ta_charge_code').'|-|ta_working_hrs|Working Hrs|'.$this->input->post('ta_working_hrs');
		$ins_arr=$this->model->history_module($id,"add_charge_code|Add Charge Code",$old,"",'tbl_timesheet_activity','Charge Code Management','add');
		$this->model->insertData("tbl_update_history",$ins_arr);
		
    	$this->session->set_flashdata("msg_1", '<div class="alert alert-success alert-dismissible" role="alert">
		<button type="button" class="close" data-dismiss="alert" aria-label="Close">
		<span aria-hidden="true">&times;</span></button>
		<strong>Success!</strong> Data has been deleted successfully. </div>');
        redirect("timesheet/activity");

	} // END: DELETE FUNCTION	
	
	//------- ADD activity -------
	public function add_activity(){   
	
	if($this->input->post("save")=="save"){
		$insertdata=array(
		'ta_name'=>$this->input->post("ta_name"),
		'ta_charge_code'=>$this->input->post("ta_charge_code"),
		'ta_type'=>$this->input->post("ta_type"),
		'ta_working_hrs'=>$this->input->post("ta_working_hrs"),
		'ta_add_on'=>date("Y-m-d H:i:s")
		);

		$this->model->insertData("tbl_timesheet_activity",$insertdata);
		$this->session->set_flashdata("msg_1", '<div class="alert alert-success alert-dismissible" role="alert">
		<button type="button" class="close" data-dismiss="alert" aria-label="Close">
		<span aria-hidden="true">&times;</span></button>
		<strong>Success!</strong> Data has been inserted successfully. 
		</div>');
		redirect("timesheet/activity"); 
	}else{
		$data["catData"]=$this->model->getDatamodel("tbl_timesheet_activity");
		//$data["view"]="timesheet/add_activity";
		$this->load->view("timesheet/activity/add_activity",$data);
	} 
	    
	} // END: INSERT FUNCTION
	
	//------- EDIT activity -------
	public function edit_activity($id){
    //$id = $this->model->decryptdata($encrypted_string);
    $where=array("ta_id"=>$id);
    $ta_name=$this->model->sortingWheredata("*","tbl_timesheet_activity",$where,'ta_update_on DESC');
    if($this->input->post("save")=="save"){
		$session_data=$this->session->userdata('loginData');
			$ip = $this->input->ip_address();
			if(isset($session_data) AND $session_data!=""){
			$u_e_id=$session_data['e_id'];
			$u_e_type=$session_data['type'];
			}
			$ins_arr=array(
			'u_e_id' =>$u_e_id,
			'u_e_type'  =>$u_e_type,
			'u_table_name'=>'tbl_timesheet_activity',
			'u_page_name'=>'Charge Code Management',
			'u_ip_address'=>$ip,
			'u_primary_id'=>$id,
			'u_add_on'=>date('Y-m-d H:i:s'),
			'u_action'=>'edit'
			);
			
		if($ta_name[0]['ta_name'] != $this->input->post("ta_name")){
			$ins_arr1=array(
			'u_field'=>"ta_name|Activity Name",
			'u_old_text'=>$ta_name[0]['ta_name'],
			'u_new_text'=>$this->input->post("ta_name")
			);
			$this->model->insertData("tbl_update_history",array_merge($ins_arr1,$ins_arr));
		}
		if($ta_name[0]['ta_charge_code'] != $this->input->post("ta_charge_code")){
			$ins_arr2=array(
			'u_field'=>"ta_charge_code|Charge Code",
			'u_old_text'=>$ta_name[0]['ta_charge_code'],
			'u_new_text'=>$this->input->post("ta_charge_code")
			);
			$this->model->insertData("tbl_update_history",array_merge($ins_arr2,$ins_arr));
		} 
		if($ta_name[0]['ta_type'] != $this->input->post("ta_type")){
			$ins_arr2=array(
			'u_field'=>"ta_type|Type",
			'u_old_text'=>$ta_name[0]['ta_type'],
			'u_new_text'=>$this->input->post("ta_type")
			);
			$this->model->insertData("tbl_update_history",array_merge($ins_arr2,$ins_arr));
		} 
		
		if($ta_name[0]['ta_working_hrs'] != $this->input->post("ta_working_hrs")){
			$ins_arr2=array(
			'u_field'=>"ta_working_hrs|Working Hrs",
			'u_old_text'=>$ta_name[0]['ta_working_hrs'],
			'u_new_text'=>$this->input->post("ta_working_hrs")
			);
			$this->model->insertData("tbl_update_history",array_merge($ins_arr2,$ins_arr));
		} 
		
        $Updatedata=array(
		'ta_name'=>$this->input->post("ta_name"),
		'ta_charge_code'=>$this->input->post("ta_charge_code"),
		'ta_type'=>$this->input->post("ta_type"),
		'ta_working_hrs'=>$this->input->post("ta_working_hrs")
		);

        $this->model->UpdateData("tbl_timesheet_activity",$Updatedata,$where);
        $this->session->set_flashdata("msg_1",'<div class="alert alert-success alert-dismissible" role="alert">
		<button type="button" class="close" data-dismiss="alert" aria-label="Close">
		<span aria-hidden="true">&times;</span></button>
		<strong>Success!</strong> Data has been updated successfully. 
        </div>'); 
        redirect("timesheet/activity"); 
    }else{
    	$data["getData"]=$this->model->getDatamodel("tbl_timesheet_activity");
    	$data["edit"]=$ta_name;
    	//$data["view"]="timesheet/add_activity";
		$this->load->view("timesheet/activity/add_activity",$data);
    } 

  	} // END: EDIT FUNCTION 

	//----- CHECK TIMESHEET EXIST -----
	public function check_timesheet_exist(){
	$emp_id=$this->input->post('e_id');
		$month = $this->input->post("month");
		$year = $this->input->post("year");
		$whr = array('t_e_id'=>$emp_id,'t_month'=>$month,'t_year'=>$year);
		$ts_Data=$this->model->sortingWheredata("*","tbl_timesheet",$whr,'t_id ASC');
		
		if(count($ts_Data) > 0){
			echo "Exist";
		}
	}
	
  	//::::::::::::::::: GEMERATE TIMESHEET ::::::::::::::::::::::::::

  	public function generate_timesheet($page_type="",$enc_t_id="",$pg_status="all",$project="")
	{ 
		//echo "<pre>";print_r($_POST);echo "</pre>";
		
		$mode='add'; 
		$submit_type=$this->input->post('timesheet');
		$data['pg_status']=$pg_status;
		$data['page_type']=$page_type;
		$data['project']=$project;
		$page_per='new';
		
		if($enc_t_id==""){
		$emp_id=$this->input->post('e_id');
		$month = $this->input->post("month");
		$year = $this->input->post("year");
		$whr = array('t_e_id'=>$emp_id,'t_month'=>$month,'t_year'=>$year);
		$ts_Data=$this->model->sortingWheredata("*","tbl_timesheet",$whr,'t_id ASC');
	
		if(count($ts_Data) > 0){
			$enc_t_id=$this->model->encryptdata($ts_Data[0]['t_id']);
			$page_per = $ts_Data[0]['t_status'];
			if($ts_Data[0]['t_status']!='reject'  && $ts_Data[0]['t_status']!='save'){
				redirect("timesheet/view_timesheet/$enc_t_id/$page_type");
			}
			redirect("timesheet/$submit_type"."_timesheet/$page_type/$enc_t_id"); 
		}else{ 
		if($submit_type=='view'){ 
		$this->session->set_flashdata("msg",'<div class="alert alert-danger alert-dismissible" role="alert">
		<button type="button" class="close" data-dismiss="alert" aria-label="Close">
		<span aria-hidden="true">&times;</span></button>
		Timesheet Data not found.
        </div>'); 
		redirect("timesheet");  }
		} 
		
		}else{
		$t_id = $this->model->decryptdata($enc_t_id);
		$ts_Data=$this->model->sortingWheredata("*","tbl_timesheet",array('t_id'=>$t_id),'t_id ASC');
		$emp_id= $ts_Data[0]['t_e_id'];
		$month = $ts_Data[0]["t_month"];
		$year = $ts_Data[0]["t_year"]; 
		$page_per = $ts_Data[0]['t_status'];
		if($pg_status!='edit'){
		redirect("timesheet/view_timesheet/$enc_t_id/$page_type");
		}
		if($ts_Data[0]['t_status']!='reject'  && $ts_Data[0]['t_status']!='save'){
				//redirect("timesheet/view_timesheet/$enc_t_id");
			} 
			//$where_td = "(td_status != 'P' && td_status != 'A')";
		//$data['tsd_Data']=$this->model->sortingWheredata("*","tbl_timesheet_data",$where_td,'td_id ASC');
		$data['t_id']=$t_id;
		$mode = 'edit';
		 
		}
		
		if($pg_status=='edit'){
		$app_proj_list=$this->ts->timesheet_project_list(array('t.t_id'=>$t_id,'td.td_status'=>'A'));
		$data["app_proj"] = array_column($app_proj_list, 'prj_id');
		}
		

		$data['mode'] = $mode; 
		$data['page_per'] = $page_per; 
		
		$data["projData"]=$this->ts->prj_asignEmp(array('e.e_id' => $emp_id, 'pr.prj_status'=>1));	
		
		$data["empData"]=$this->ts->employee_details(array('e.e_id' => $emp_id));
		if(count($data["empData"]) <= 0){ redirect('welcome/not_found_page'); }		
		$data['actData']=$this->model->sortingWheredata("*","tbl_timesheet_activity","NULL",'ta_type DESC');
		//$data["instructionsData"]=$this->model->getDatamodel("tbl_timesheet_instructions");
		$c_id = $data['empData'][0]['c_id'];
		$datas =$this->ts->CelenderData(array('c.c_id'=>$c_id,'h.h_year'=>$year,"MONTH(h.h_date)" => $month));
		$data["holidays"] = array_column($datas, 'h_date');
		$data["holidays_day"] = array_column($datas, 'holiday_name');
		$data["holidays_name"] = array_column($datas, 'h_name');
		$data["view"]="timesheet/timesheet/fill";
		$data["month"]=$month;
		$data["year"]=$year;
		//----
		$activityData=$this->model->sortingWheredata("*","tbl_timesheet_activity",array('ta_type'=>'Non-Billable'),'ta_update_on DESC');
			$option_txt='';
			$option_txt.='<option value="">Select</option>';
			foreach ($activityData as $k){
				$sel="";  if('weekly off'==strtolower($k['ta_name'])){ $sel="selected"; } 
				$option_txt.='<option value="'.$k['ta_id'].'" '.$sel.'>'.$k['ta_charge_code'].'</option>';
			 } 
		$data['nonbill_act']=$option_txt;
		//------
		$this->load->view("layout",$data);
	}
 
	//------ SELECT CLIENT -----------
	public function select_type_fun(){
		$app_proj = $this->input->post("app_proj");
		$e_id = $this->input->post("e_id");
		$type = $this->input->post("type");
		$hd_client = $this->input->post("hd_client");
		$date = date('Y-m-d',strtotime($this->input->post("date")));
		$chk_type="";
		$chk_id="";
		if($hd_client!=""){
			$exp=explode('|',$hd_client);
			$chk_type=$exp[0];
			$chk_id=$exp[1];
		}
		$option_txt="<option value=''>Select</option>";
		if($type=="Billable"){  
			$whr="(pa.from_dt <='$date' AND pa.till_dt >='$date') AND e.e_id = '$e_id' AND pr.prj_status = 1";
			$projData=$this->ts->prj_asignEmp($whr);
			foreach ($projData as $k){
				$sel=""; if($chk_type=="Billable"){ if($chk_id==$k['prj_id']){ $sel="selected"; } }
				$option_txt.='<option value="'.$k['prj_id'].'" '.$sel.'>'.$k['project_code'].'</option>';
			 }
		}

		if($type=="Non-Billable"){

			$activityData=$this->model->sortingWheredata("*","tbl_timesheet_activity",array('ta_type'=>'Non-Billable'),'ta_update_on DESC');
			foreach ($activityData as $k){
				$sel=""; if($chk_type=="Non-Billable"){ if($chk_id==$k['ta_id']){ $sel="selected"; } }
				$option_txt.='<option value="'.$k['ta_id'].'" '.$sel.'>'.$k['ta_charge_code'].'</option>';
			 } 
		}
		echo $option_txt;
	}
	
	//------- SAVE TIMESHEET ------------
	public function save_timesheet()
	{
		
		echo "<pre>";
		print_r($_POST);
		echo "</pre>";  //die;
		$session_data=$this->session->userdata('loginData');
		$u_e_id=$session_data['e_id'];
		$u_e_type=$session_data['type'];
	
		$project=$this->input->post('project');
		$page_type=$this->input->post('page_type');
		$post_t_id=$this->input->post('t_id');
		$t_prj_id=$this->input->post('t_prj_id');
		$e_id=$this->input->post('e_id');
		$year=$this->input->post('year');
		$month=$this->input->post('month');
		$date=$this->input->post('date');
		$type=$this->input->post('type');
		$client=$this->input->post('client');
		$activity=$this->input->post('activity');
		$working_hrs=$this->input->post('working_hrs');
		$hd_t_id=$this->input->post('hd_t_id');
		
		$unq_type = array_unique($type);
		if(count($unq_type) <= 1 && $unq_type[0]==''){
			$this->session->set_flashdata("msg",'<div class="alert alert-danger alert-dismissible" role="alert">
			<button type="button" class="close" data-dismiss="alert" aria-label="Close">
			<span aria-hidden="true">&times;</span></button>
			<strong>Fail : </strong> Please select correct timesheet data. 
			</div>'); 
		redirect("timesheet/manage_timesheet/$page_type");
		}
		
		if(count($type) > 0 ){
			
		$insArr = array(
		"t_e_id" => $e_id,
		"t_prj_id" => $t_prj_id,
		"t_year" => $year,
		"t_month" => $month,
		"t_update_e_id" => $u_e_id."|".$u_e_type
		);
 
		if($post_t_id==""){
			//---- CHK TIMESHEET EXIST ----
			$where=array("t_e_id" => $e_id,"t_year" => $year,"t_month" => $month);
			$tm_exist=$this->model->sortingWheredata("*","tbl_timesheet",$where,'t_id DESC');
			if(count($tm_exist) > 0){
			$enc_t_id=$this->model->encryptdata($tm_exist[0]['t_id']);
			$this->session->set_flashdata("msg",'<div class="alert alert-danger alert-dismissible" role="alert">
			<button type="button" class="close" data-dismiss="alert" aria-label="Close">
			<span aria-hidden="true">&times;</span></button>
			Timesheet has been already exist. Please check again. 
			</div>'); 
			redirect("timesheet/view_timesheet/$enc_t_id/$page_type/$project"); 
			} //---- /. CHK TIMESHEET EXIST ----
			
		$ins =array("t_status" => 'save',"t_add_on" => date('Y-m-d H:i:s'),"t_add_e_id" => $u_e_id, "t_add_e_type" => $u_e_type);
		$this->model->insertData("tbl_timesheet",array_merge($insArr,$ins));
		$t_id = $this->db->insert_id();
		}else{
		$this->model->UpdateData("tbl_timesheet",$insArr,array('t_id'=>$post_t_id));	
		$t_id = $post_t_id;
		}
		$enc_t_id=$this->model->encryptdata($t_id);
 
		for ($i=0; $i < count($type) ; $i++) { 
			if($type[$i]!="" AND $client[$i]!=""){
			$mode='add';
			if(isset($hd_t_id[$i])){ if($hd_t_id[$i]!=""){ $mode='edit'; } }
			$insArr2 = array(
			"t_id" => $t_id,
			"td_date" => date('Y-m-d',strtotime($date[$i])),
			"td_type" => $type[$i],
			"td_client" => $client[$i],
			"td_activity" => $activity[$i],
			"td_working_hrs" => $working_hrs[$i],
			"td_status" => 'S'
			);
			
			
				if($mode=='add'){
					//echo "<pre> add ";print_r($insArr2);echo "</pre>";
				$this->model->insertData("tbl_timesheet_data",$insArr2);
				}else{
					//echo "<pre> edit ";print_r($insArr2);echo "</pre>";
				$this->model->UpdateData("tbl_timesheet_data",$insArr2,array('td_id'=>$hd_t_id[$i]));	
				}
			}
			
		} //END:for
		 
		 $this->session->set_flashdata("msg",'<div class="alert alert-success alert-dismissible" role="alert">
			<button type="button" class="close" data-dismiss="alert" aria-label="Close">
			<span aria-hidden="true">&times;</span></button>
			<strong>Success!</strong> Timesheet has been saved successfully. 
			</div>'); 
		redirect("timesheet/view_timesheet/$enc_t_id/$page_type/$project"); 
		}else{
			$this->session->set_flashdata("msg",'<div class="alert alert-danger alert-dismissible" role="alert">
			<button type="button" class="close" data-dismiss="alert" aria-label="Close">
			<span aria-hidden="true">&times;</span></button>
			<strong>Fail!</strong> Data has been wrong. Please try again. 
			</div>'); 
		redirect("timesheet/manage_timesheet/$page_type");
		}
	} 

	public function delete_timesheet_data(){
		$td_id=$this->input->post('td_id');
		$where=array("td_id"=>$td_id);            
		$this->model->DeleteData("tbl_timesheet_data",$where);
		echo "delete";
	} 
	
	
	
	//================ TIMESHEET MGT by STATUS ===============
	public function manage_timesheet($page_type="")
	{
	$session_data=$this->session->userdata('loginData');
	if(isset($session_data) AND $session_data!=""){
	$u_e_id=$session_data['e_id'];
	$u_e_type=$session_data['type'];
	$data['tm_Arr']= $this->ts->tm_role($page_type);
	 
	if($u_e_type == 'employee'){
	$emdata=$this->hr->employee_details(array('e.e_id'=> $u_e_id, 'e.e_working_status'=>1,'e.e_delete'=>'0'));
	$data['approver_email'] = $emdata[0]['e_office_email_id'];
	$data['e_supervisor'] = $emdata[0]['e_supervisor'];
		if($page_type == 'employee_timesheet'){
			$where = array('e.e_supervisor_employee_id'=> $u_e_id, 'e.e_working_status'=>1,'e.e_delete'=>'0');
		}else{
			$where = array('e.e_working_status'=>1,'e.e_delete'=>'0');
		}
			
		 
		/*if(strtolower($emdata[0]['r_name'])=='admin'){
		$where = array('e_working_status'=>1);
		$data['sel_emp'] = 'all';
		}else{
		$where = array('e_id'=> $u_e_id, 'e_working_status'=>1);
		$data['sel_emp'] = 'one';
		}*/
	}else{
	$data['approver_email']="super admin";
	$where = array('e.e_working_status'=>1,'e.e_delete'=>'0');
	$data['sel_emp'] = 'all';
	}
	}else{
		redirect(base_url());
	}		
	$data["empallData"]=$this->hr->employee_details(array('e.e_delete'=>'0'));	
	$data["empData"]=$this->hr->employee_details($where);	
	$data['page_type']=$page_type; 
	//$data["view"]="timesheet/timesheet_mgt_page";
	$data["view"]="timesheet/timesheet/timesheet_mgt_tab";
	$this->load->view("layout",$data); 
	}
	
	//----- USER DATA DISPLAY IN TABLE -----
    function timesheet_mgt_ajax_list(){
		$page_type = $this->input->post('page_type');
		if($page_type == 'ext_timesheet'){
		$session_data=$this->session->userdata('managerSession');
		}else{
		$session_data=$this->session->userdata('loginData');
		}
	if(isset($session_data) AND $session_data!=""){
		$this->load->library('Ajax_pagination');
        $conditions = array();
        //calc offset number
        $page = $this->input->post('page');
        if(!$page){
            $offset = 0;
        }else{
            $offset = $page;
        }
        //set conditions for search
        
        $per_page = $this->input->post('per_page');
        $status = $this->input->post('status');
		
		$post_data = $_POST;
		
		$data['status'] = $status;
		$data['page_type']=$page_type;
		$totalRec=count($this->ts->timesheet_ajax_search_list($conditions,$post_data));
		
		$per_page=50;
        //pagination configuration
        $config['target']      = '#timesheet_aj_data';
        $config['base_url']    = base_url()."timesheet/manage_timesheet/$page_type";
        $config['total_rows']  = $totalRec;
        $config['per_page']    = $per_page;
        $config['link_func']   = 'searchFilter';
        $this->ajax_pagination->initialize($config);
        
        //set start and limit
        $conditions['start'] = $offset;
        $conditions['limit'] = $per_page; 
        $data['timsheetData'] = $this->ts->timesheet_ajax_search_list($conditions,$post_data);
		$data['ttlData']=$totalRec;
        //load the view
		$msg_not_found = "No data available";
		if($page_type=="employee_timesheet"){
        if(count($data['timsheetData'])==0){
			$e_id_name = trim($this->input->post("e_id_name"));
			if($e_id_name!=""){
			$chk_sp =$this->ts->timesheet_chk_sup($post_data);
			if($chk_sp > 0){
				$msg_not_found="You are not authorised to view data";
			}
			}
		}
		}
		$data['msg_not_found']=$msg_not_found;
            
        $this->load->view('timesheet/timesheet/timesheet_mgt_ajax_list', $data, false);
		}else{
			echo "<h4 class='text-danger font-18 text-center mt-5'>Your Session has been expired. Click here to login again.<br/>
			<a href='".base_url()."welcome/managerLogin' class='btn btn-sm btn-primary mt-2'> Login </a>
			</h4>";
		//redirect(base_url());
		}
    }
	
	
	
	//::::::::::::::: NEW TIMESHEEET :::::::::::::::::::::::
	public function view_timesheet($enc_t_id="",$page_type="",$url_email="")
	{
		$t_id = $this->model->decryptdata($enc_t_id);
		$session_data=$this->session->userdata('loginData'); 
		$si_type=strtolower($session_data['type']);
		$url_email=strtolower($url_email);
		$siData=$this->ts->tm_list(array("t.t_id"=>$t_id));
		$sup_email = $siData[0]['sup_e_office_email_id'];
		$data['page_title']= ucwords(str_replace('_',' ',$page_type));
		$data['page_type']=$page_type;
		$data['tm_Arr']= $this->ts->tm_role($page_type,"view");
		$data['enc_t_id']=$enc_t_id;
		$data['url_email']=$url_email; 

		$user_type="";
		if($page_type=="employee_timesheet" AND $url_email!=""){
			if($sup_email==$url_email){
				$where = "t.t_id = $t_id";
				$user_type="supervisor";
			}else{
				$user_type="approver";
				$where = "t.t_id = $t_id AND IF(td.td_type='Billable', pa.email,sup.e_office_email_id) = '$url_email'";
			}
		}else{
			if($si_type=='super admin'){
			$user_type="super admin";
			}else{
			$user_type="superuser";
			}
			$where = "t.t_id = $t_id";
		}
		$data['user_type']=$user_type;	// Store val when user type = supervior
		

		 
		$data['getData']=$this->ts->tm_data_list($where);
		if(count($data['getData']) <= 0) { redirect('welcome/not_found_page'); }
		$prj_id = $data['getData'][0]['t_prj_id'];
		$e_id = $data['getData'][0]['t_e_id']; 
		$c_id = $data['getData'][0]['c_id']; 
		$month = $data['getData'][0]['t_month'];
		$year = $data['getData'][0]['t_year'];
		$t_status = $data['getData'][0]['t_status'];
		$t_week_off = $data['getData'][0]['t_week_off'];
		$t_holiday = $data['getData'][0]['t_holiday'];
		if($t_status=='save'){
		$datas =$this->ts->CelenderData(array('c.c_id'=>$c_id,'h.h_year'=>$year,"MONTH(h.h_date)" => $month));
		 
		$data["holidays"] = array_column($datas, 'h_date');
		$data["holidays_day"] = array_column($datas, 'holiday_name');
		}else{
			$exp_hol = explode('|-|',$t_holiday);
			$hol_Arr = [];
			foreach ($exp_hol as $k) { 
			$exp_hols = explode('|',$k);
			$hol_Arr[] = $exp_hols[0];
			} 
			$data["holidays"] = $hol_Arr;  
		} 
			
		$data["projnonCount"]=$this->ts->project_billable_count(array('td.td_type'=> "Non-Billable","t.t_id"=>$t_id));	
		
		//---- CHK ROLE & PERMISSION ---
		$chk_per = 'Y';
		if($si_type=='employee'){
			$role_per_arr=$this->model->multi_module_permission();
			if(count($role_per_arr) > 0){
				$view_arr=array_unique(explode(',',$role_per_arr[0]['rp_view']));
				if($page_type == 'timesheet'){ 
				if(!in_array('67', $view_arr) || !in_array('77', $view_arr)){ $chk_per = 'N';  }  
				} 
				if($page_type == 'employee_timesheet'){ 
				if(!in_array('96', $view_arr) || !in_array('102', $view_arr)){ $chk_per = 'N';  }  
				} 
				if($page_type == 'my_timesheet'){ 
				if(!in_array('85', $view_arr) || !in_array('91', $view_arr)){ $chk_per = 'N';  }  
				}
			}			
		}
		//---- END : CHK ROLE & PERMISSION ---
		if($chk_per=='N'){
		$data["view"]="not_permitted";
		}else{
		$data["view"]="timesheet/timesheet/view_timesheet";
		}
		$this->load->view("layout",$data); 
	}
	
	public function manage_timesheet_status(){
		$t_id = $this->input->post('t_id');
		$enc_t_id=$this->model->encryptdata($t_id);
		$curl = $this->input->post('curl');
		$rd_url = $this->input->post('rd_url');
		$td_approver_id = $this->input->post('td_approver_id');
		$td_approver_type = $this->input->post('td_approver_type');
		$td_approver_email = $this->input->post('td_approver_email');
		//echo "<pre>";print_r($_POST);echo "</pre>"; die;
		//-------- TIMESHEET DATA -----
			$where=array("t.t_id"=>$t_id);
			$getData=$this->ts->timesheet_data($where);
			$sup_email = trim($getData[0]["sup_e_office_email_id"]);
			$supervisor_name = $getData[0]["supervisor_name"];
			$t_status = $getData[0]['t_status'];
			$month = $getData[0]['t_month'];
			$year = $getData[0]['t_year'];
			$prj_id = $getData[0]['t_prj_id'];
			$e_id = $getData[0]['t_e_id']; 
			$employee_id = $getData[0]['employee_id']; 
			$e_name = $getData[0]['e_name']; 
			$e_office_email_id = $getData[0]['e_office_email_id']; 
		
		
		if($this->input->post('send')=='email'){
			
			$sup_email_status=1; $tm_send_arr=[];
			$proj_mgr_data=$this->ts->tm_project_mgr_list(array("t.t_id"=>$t_id,"td.td_type"=>"Billable",'td.td_status'=>'S'));
			//echo "<pre>";print_r($proj_mgr_data);echo "</pre>";
			//$subject = "Timesheet : ".$getData[0]['employee_id']." - ".$getData[0]['e_name']." [".date('M-Y',strtotime("01-$month-$year"))."]";  
			$subject = "Timesheet of ".$getData[0]['e_name']." for ".date('M-Y',strtotime("01-$month-$year"));
			foreach ($proj_mgr_data as $k) { 
			$m_nm = $k['m_nm'];
			$email = trim($k['email']); 
			$tm_send_arr[]=$email;
			$no_act_txt="";
			if($sup_email==$email){ $no_act_txt="<p style='color:red'>******* Information Only ** No action required ***** </p>";$sup_email_status=0;}
			$email_link=base_url()."ext_timesheet/timesheet/$enc_t_id/$email";
			echo $msg="
			<p>Dear $m_nm,</p>
			<p>Please click below link to approve timesheet of ".$getData[0]['e_name']." for ".date('M-Y',strtotime("01-$month-$year")).".</p>
			<!--a href='$email_link'>$email_link</a-->
			<a href='$email_link' style='background: #0f548b;padding: 5px 8px;color: #fff;text-decoration: none;box-shadow: 3px 3px 7px 1px #a9a9a9;'>Approve Timesheet</a>
			<p>
			Thanks,<br/>
			Admin Team,<br/>
			TAMS Infotech
			</p>";
			$this->model->emailSendFormat($email, $subject, $msg, 'NULL','NULL',$this->pms_email); 
			//$this->model->emailSendFormat('nikita.prajapati@staroneweb.co.in', $subject, $msg, 'NULL','NULL',$this->pms_email);  
			}
			
			if($sup_email_status==1){
				if($sup_email!=""){
				$tm_send_arr[]=$sup_email;
				$email_link_sup = base_url()."ext_timesheet/timesheet/$enc_t_id/$sup_email";
				$msg="
				<p>Dear $supervisor_name,</p>
				<p>Please click below link to approve timesheet of ".$getData[0]['e_name']." for ".date('M-Y',strtotime("01-$month-$year")).".</p>
				<!--a href='$email_link_sup'>$email_link_sup</a-->
				<a href='$email_link_sup' style='background: #0f548b;padding: 5px 8px;color: #fff;text-decoration: none;box-shadow: 3px 3px 7px 1px #a9a9a9;'>Approve Timesheet</a>
				<p>
				Thanks,<br/>
				Admin Team,<br/>
				TAMS Infotech 
				</p>";
				$this->model->emailSendFormat($sup_email, $subject, $msg, 'NULL','NULL',$this->pms_email);
				//$this->model->emailSendFormat('nikita.prajapati@staroneweb.co.in',$subject, $msg, 'NULL','NULL',$this->pms_email);
				
			}
			}
			 
			if($t_status=='save'){
			$t_week_off = $this->input->post('t_week_off');
			$t_holiday = $this->input->post('t_holiday');
			$this->model->UpdateData("tbl_timesheet",array('t_status'=>'pending','t_week_off'=>$t_week_off,'t_holiday'=>$t_holiday),array('t_id'=>$t_id));	
			}
		
			$this->model->UpdateData("tbl_timesheet_data",array('td_status'=>'P'),array('t_id'=>$t_id,'td_status'=>'S'));
			
			//---- START: log ---
			if($t_status == 'save'){ $log_status_txt = "(Not Submitted Timesheet)";}else{ $log_status_txt = "(Rejected line edit and submit)"; }
			$ins_arr=[]; 
			$send_tm=implode(', ',$tm_send_arr);
			$log_txt = "Timesheet Month/Year : ".date('M-Y',strtotime("01-$month-$year"))."|Send To : $send_tm|$log_status_txt";
			$ins_arr[]=$this->ts->history_module($e_id,"submit_timesheet|Submit Timesheet","","$log_txt",'tbl_timesheet','Timesheet','submit',$td_approver_id,$td_approver_type);
			$this->db->insert_batch("tbl_update_history",$ins_arr);  
			//---- END: log ---
			
			$this->session->set_flashdata("msg",'<div class="alert alert-success alert-dismissible" role="alert">
			<button type="button" class="close" data-dismiss="alert" aria-label="Close">
			<span aria-hidden="true">&times;</span></button>
			<strong>Success!</strong> Timesheet has been submitted successfully. 
			</div>'); 
			redirect("$rd_url");   
		}elseif($this->input->post('send')=='status_submit'){
			$td_status = $this->input->post('td_status');
			$td_comment = $this->input->post('td_comment');
			$redirect_url_mgr = $this->input->post('redirect_url_mgr');
			//echo "<pre>";print_r($_POST);echo "</pre>"; die;
			foreach($td_status AS $i=>$status){
				$cmt_text="";
				if($td_comment[$i]!=""){
				$cmt_text=date('d-M-Y')."|".addslashes($td_comment[$i]);
				$this->db->query("UPDATE tbl_timesheet_data SET td_status='$status',td_status_log='".date('Y-m-d H:i:s')."', td_comments= IF(td_comments='','$cmt_text',(CONCAT(td_comments , '|-|','$cmt_text'))) WHERE t_id=$t_id AND td_id=$i");
				}else{
				$upd_status = array('td_status' => $status,'td_status_log'=>date('Y-m-d H:i:s'));
				$this->model->UpdateData("tbl_timesheet_data",$upd_status,array('t_id'=>$t_id,'td_id'=>$i));
				}
				
			}
			
			
			$success_msg = "submitted";
			if(in_array('A',$td_status) || in_array('R',$td_status)){ 
			$ins_arr=[];
			//---- START: LOG OF TIMEHEET ---
			//---- APPROVE FULL TIMEHEET ----
			$change_log = "N";
			$app_proj_list=$this->model->groupbyData('td_status','tbl_timesheet_data',array('t_id'=>$t_id),$order='NULL',$group_by='td_status');
			if(count($app_proj_list) == 1){
				if($app_proj_list[0]['td_status']=='A'){
					$success_msg = "approved";
					$change_log = "N";
					$this->model->UpdateData("tbl_timesheet",array('t_status'=>'approved'),array('t_id'=>$t_id));
					//--- EMAIL ---
					$subject = "Timesheet of ".$getData[0]['e_name']." for ".date('M-Y',strtotime("01-$month-$year"))." - Approved";
					$msg_app="
					<p>Dear ".$getData[0]['e_name'].",</p>
					<p>Your timesheet for the month of ".date('M-Y',strtotime("01-$month-$year"))." has been approved.</p>
					<p>Thanks, <br/>
					PMS Team</p>";
					$this->model->emailSendFormat($e_office_email_id, $subject, $msg_app, 'NULL','NULL',$this->pms_email);
					//$this->model->emailSendFormat('nikita.prajapati@staroneweb.co.in', $subject, $msg_app, 'NULL','NULL',$this->pms_email); 
					//--- EMAIL ---
					//---- START: log ---
					$st_log_txt = "Month of ".date('M-Y',strtotime("01-$month-$year"))." timesheet  has been approved.";
					$ins_arr[]=$this->ts->history_module($e_id,"approved_timesheet|Approved Timesheet","","$st_log_txt",'tbl_timesheet','Timesheet','Approved',$td_approver_id,$td_approver_type);
					//---- END: log ---
				}else{
					$change_log = "Y";
				}
			}else{
				$change_log = "Y";
			}
			
			if($change_log == "Y"){ $semi_status_tm = '';
				if(in_array('R',$td_status)){ $semi_status_tm = '| Status : Rejected';
				//--- EMAIL ---
					$subject = "Timesheet of ".$getData[0]['e_name']." for ".date('M-Y',strtotime("01-$month-$year"))." - Rejected";
					$email_link=base_url()."ext_timesheet/view_employee_timesheet/$enc_t_id/my_timesheet";
					$msg_app="
					<p>Dear ".$getData[0]['e_name'].",</p>
					<p>Your timesheet for the month of ".date('M-Y',strtotime("01-$month-$year"))." has been rejected.</p>
					<p>Please click below link to view status of timesheet</p>
					<!--a href='$email_link'>$email_link</a-->
					<a href='$email_link' style='background: #0f548b;padding: 5px 8px;color: #fff;text-decoration: none;box-shadow: 3px 3px 7px 1px #a9a9a9;'>View Timesheet</a>
					<p>Thanks, <br/>
					PMS Team</p>";
					$this->model->emailSendFormat($e_office_email_id, $subject, $msg_app, 'NULL','NULL',$this->pms_email);
					//$this->model->emailSendFormat('nikita.prajapati@staroneweb.co.in', $subject, $msg_app, 'NULL','NULL',$this->pms_email); 
					//--- EMAIL ---
				}else{
					$semi_approve = $this->model->DetailData('view_timesheet_approver',array('t_id'=>$t_id,'approver_email'=>$td_approver_email,'sheet_status'=>'approved'));
					if(count($semi_approve) > 0){ $success_msg = "approved"; $semi_status_tm = '| Status : Approved'; }
					
				}
				$log_txt ='';
				$log_txt .= "Month of ".date('M-Y',strtotime("01-$month-$year"))." timesheet status has been changed. $semi_status_tm";
				
				
				$sup_other_data=$this->ts->timesheet_other_proj_status(array('t_id'=>$t_id));
				if($sup_other_data[0]['sup_e_id'] !=$td_approver_id AND $td_approver_type !='super admin'){
				if($sup_other_data[0]['non_sup_proj_status']=='approved'){
					//--- EMAIL ---
					$subject = "Timesheet of ".$getData[0]['e_name']." for ".date('M-Y',strtotime("01-$month-$year"));
					$email_link=base_url()."ext_timesheet/timesheet/$enc_t_id/".$sup_other_data[0]['sup_email'];
					echo $msg_sup="<p>Dear ".$sup_other_data[0]['sup_name'].",</p>
					<p>For Consultant ".$getData[0]['e_name'].", timesheet for the month of ".date('M-Y',strtotime("01-$month-$year"))." has been approved by respective managers, kindly proceed for non-billable time approval.</p>
					<p>Please click below link to approve timesheet.</p>
					<!--a href='$email_link'>$email_link</a-->
					<a href='$email_link' style='background: #0f548b;padding: 5px 8px;color: #fff;text-decoration: none;box-shadow: 3px 3px 7px 1px #a9a9a9;'>Approve Timesheet</a>
					<p>
					Thanks,<br/>
					Admin Team,<br/>
					TAMS Infotech
					</p>";
					$this->model->emailSendFormat($sup_other_data[0]['sup_email'], $subject, $msg_sup, 'NULL','NULL',$this->pms_email);
					//$this->model->emailSendFormat('nikita.prajapati@staroneweb.co.in', $subject, $msg_sup, 'NULL','NULL',$this->pms_email); 
					//--- EMAIL ---
					$log_txt .= "|Send To Supervisor : ".$sup_other_data[0]['sup_email']." (For approving Non-billable charge codes)";
				}
				}
				
				$ins_arr[]=$this->ts->history_module($e_id,"confirm_timesheet|Confirm Timesheet","","$log_txt",'tbl_timesheet','Timesheet','confirm',$td_approver_id,$td_approver_type);
				
			}
			
		
			if(count($ins_arr) > 0) { $this->db->insert_batch("tbl_update_history",$ins_arr); }
			//---- END: LOG OF TIMEHEET ----
			$this->model->UpdateData("tbl_timesheet",array('t_update_on'=>date('Y-m-d H:i:s')),array('t_id'=>$t_id));
			}
			
		
			$this->session->set_flashdata("msg",'<div class="alert alert-success alert-dismissible" role="alert">
			<button type="button" class="close" data-dismiss="alert" aria-label="Close">
			<span aria-hidden="true">&times;</span></button>
			<strong>Success!</strong> Timesheet has been '.$success_msg.' successfully. 
			</div>'); 
			redirect("$rd_url");   
			
		}
		
	}
	
	
	public function download_timesheet($enc_t_id,$url_email=''){ 
		
		$t_id = $this->model->decryptdata($enc_t_id);
		$session_data=$this->session->userdata('loginData'); 
		$u_e_id=$session_data['e_id'];
		$si_type=strtolower($session_data['type']);
		
		$siData=$this->ts->tm_list(array("t.t_id"=>$t_id));
		$sup_email = $siData[0]['sup_e_office_email_id'];

		
		if($url_email!=""){
			if($sup_email==$url_email){
				$where = "t.t_id = $t_id";
				
			}else{
				
				$where = "t.t_id = $t_id AND IF(td.td_type='Billable', pa.email,sup.e_office_email_id) = '$url_email'";
			}
		}else{
		
			$where = "t.t_id = $t_id";
		}
		
		 
		$data['getData']=$this->ts->tm_data_list($where);
		$t_holiday = $data['getData'][0]['t_holiday'];
		$exp_hol = explode('|-|',$t_holiday);
		$hol_Arr = [];
		foreach ($exp_hol as $k) { 
		$exp_hols = explode('|',$k);
		$hol_Arr[] = $exp_hols[0];
		} 
		$data["holidays"] = $hol_Arr; 
		
		$this->load->library('m_pdf');
		$pdf = new Mpdf();
		$pdf->AddPage('L','', '', '', '', 5,5,5,5,5,5); 
		//$this->m_pdf->pdf->SetHeader('{DATE j-m-Y}|{PAGENO}/2|My document');
 
		$cssurl = base_url() . "assets/css/pdf.css";
		$stylesheet = file_get_contents($cssurl);
		$this->m_pdf->pdf->WriteHTML($stylesheet, 1); // The parameter 1 tells that this is css/style only and no
		$html2 = $this->load->view('timesheet/timesheet/download_timesheet', $data, true);
		$this->m_pdf->pdf->SetMargins(0, 0, 50);
		//$this->m_pdf->pdf->WriteHTML($html2);
		$pdf->WriteHTML($html2);
		//if (!file_exists(FCPATH . "/uploads/quot/$l_id/" . $folder_name)) {
		//  mkdir(FCPATH . "/uploads/quot/$l_id/" . $folder_name, 0755, true);
		// } 
		$date = "01-".$data['getData'][0]['t_month']."-".$data['getData'][0]['t_year'];
		$PDFname="Timesheet-".date('M-Y',strtotime("$date"))."[ ".$data['getData'][0]['employee_id']." - ".$data['getData'][0]['e_name']." ].pdf";
		$pdf->Output("$PDFname", "D");
		
		//--- LOG ---
		$log_txt = "Download File : $PDFname";
		$ins_arr=$this->ts->history_module($data['getData'][0]['e_id'],"download_timesheet|Download Timesheet","","$log_txt",'tbl_timesheet','Timesheet','download',$u_e_id,$si_type);
		$this->model->insertData("tbl_update_history",$ins_arr);
		//--- /.LOG ---
		// redirect('mak/cust_2/CustomQuatation');
		}
	
	//::::::::::::: REPORT ::::::::::::::
	public function timesheet_report(){
		$data["empallData"]=$this->hr->employee_details(array('e.e_delete'=>'0'));
		$data['timsheetData']=$this->ts->timesheet_report_search();
		$data['projData']=$this->model->sortingWheredata('*','tbl_prj_projects',$where='NULL','prj_nm ASC');
		$data['clientData']=$this->model->sortingWheredata('*','tbl_prj_clients',$where='NULL','clnt_name ASC');
		$data["view"]="timesheet/report/timesheet_search";
		$this->load->view("layout",$data); 
	}
	//----- USER DATA DISPLAY IN TABLE -----
    function timesheet_report_list(){
	$session_data=$this->session->userdata('loginData');
		
	if(isset($session_data) AND $session_data!=""){
		$this->load->library('Ajax_pagination');
        $conditions = array();
        $page = $this->input->post('page');
        if(!$page){
            $offset = 0;
        }else{
            $offset = $page;
        }
  
        $per_page = $this->input->post('per_page');
        $post_data = $_POST;
		$session_arr =[];
		foreach($post_data as $k=>$v){
			$session_arr[$k] = $v;
		}
		$this->model->search_session("timesheet_report_search",$session_arr);
		
		$totalRec=count($this->ts->timesheet_report_search($conditions,$post_data));
		
		$per_page=50;
        //pagination configuration
        $config['target']      = '#timesheet_aj_data';
        $config['base_url']    = base_url()."timesheet/timesheet_report";
        $config['total_rows']  = $totalRec;
        $config['per_page']    = $per_page;
        $config['link_func']   = 'searchFilter';
        $this->ajax_pagination->initialize($config);
        
        //set start and limit
        $conditions['start'] = $offset;
        $conditions['limit'] = $per_page; 
        $data['timsheetData'] = $this->ts->timesheet_report_search($conditions,$post_data);
		$data['ttlData']=$totalRec;
        //load the view
           
        $this->load->view('timesheet/report/timesheet_report_list', $data, false);
		}else{
			echo "<h4 class='text-danger font-18 text-center mt-5'>Your Session has been expired. Click here to login again.<br/>
			<a href='".base_url()."welcome/managerLogin' class='btn btn-sm btn-primary mt-2'> Login </a>
			</h4>";
		//redirect(base_url());
		}
    }
	
	public function download_report($enc_t_id){
		$session_data=$this->session->userdata('loginData'); 
		if(!isset($session_data) AND $session_data==""){
			redirect(base_url());
		}
		$u_e_id=$session_data['e_id'];
		$si_type=strtolower($session_data['type']);
		$t_id = $this->model->decryptdata($enc_t_id);
		$data['getData']=$this->ts->tm_data_list(array("t.t_id"=>$t_id));
		$t_holiday = $data['getData'][0]['t_holiday'];
		$exp_hol = explode('|-|',$t_holiday);
		$hol_Arr = [];
		foreach ($exp_hol as $k) { 
		$exp_hols = explode('|',$k);
		$hol_Arr[] = $exp_hols[0];
		} 
		$data["holidays"] = $hol_Arr;  
		
		$timesheet_report_search=$this->session->userdata('timesheet_report_search');
		$prj_id = $timesheet_report_search['prj_id'];
		$clnt_id = $timesheet_report_search['clnt_id'];
		$print_type="";
		$whr_pro = [];
		$whr_pro['t.t_id'] = $t_id;
		$whr_pro['td.td_type'] = "Billable";
		if($prj_id=="" AND $clnt_id==""){
			$print_type='full_timesheet';
			//$whr_pro = array("t.t_id"=>$t_id,"td.td_type"=>"Billable","pr.prj_id"=>$prj_id,"pr.clnt_id"=>$clnt_id);
		}else{
			if($prj_id!="") $whr_pro['pr.prj_id'] = $prj_id;
			if($clnt_id!="") $whr_pro['pr.clnt_id'] = $clnt_id;
			$whr_prox = array("t.t_id"=>$t_id,"td.td_type"=>"Billable","pr.prj_id"=>$prj_id,"pr.clnt_id"=>$clnt_id);
		}
		
		$data['print_type'] = $print_type;
		$data['project_list']=$this->ts->tm_project_list($whr_pro);
		//$this->load->view("timesheet/report/download_report",$data); 
		$this->load->library('m_pdf');
		$pdf = new Mpdf();
		$pdf->AddPage('L','', '', '', '', 5,5,5,5,5,5); 
		
		$cssurl = base_url() . "assets/css/pdf.css";
		$stylesheet = file_get_contents($cssurl);
		$this->m_pdf->pdf->WriteHTML($stylesheet, 1); // The parameter 1 tells that this is css/style only and no
		$html2 = $this->load->view('timesheet/report/download_report', $data, true);
		$this->m_pdf->pdf->SetMargins(0, 0, 50);
		$pdf->WriteHTML($html2);
		$date = "01-".$data['getData'][0]['t_month']."-".$data['getData'][0]['t_year'];
		$PDFname="Timesheet-Report-".date('M-Y',strtotime("$date"))."[ ".$data['getData'][0]['employee_id']." - ".$data['getData'][0]['e_name']." ].pdf";
		$pdf->Output("$PDFname", "D");
		//--- LOG ---
		$log_txt = "Download File : $PDFname";
		$ins_arr=$this->ts->history_module($data['getData'][0]['e_id'],"download_timesheet|Download Timesheet","","$log_txt",'tbl_timesheet','Timesheet Report','download',$u_e_id,$si_type);
		$this->model->insertData("tbl_update_history",$ins_arr);
		//--- /.LOG ---
		
	}
	
	//--------- SEND EMAIL TO MANAGER FOR TIMESHEET ---------
	public function send_timesheet_email(){
		$t_id = $this->model->decryptdata($this->input->post('id'));
		$getData=$this->ts->timesheet_data(array("t.t_id"=>$t_id));
		$data['sup_email'] = trim($getData[0]["sup_e_office_email_id"]);
		$data['supervisor_name'] = $getData[0]["supervisor_name"];
		$data['proj_mgr_data']=$this->ts->tm_project_mgr_list(array("t.t_id"=>$t_id,"td.td_type"=>"Billable"));
		$data['t_id']=$this->input->post('id');
		$this->load->view('timesheet/timesheet/send_timesheet_email', $data); 
	} 
	public function send_timesheet_email_ajax(){
		$enc_t_id =$this->input->post('t_id');
		$send_id = explode('|',$this->input->post('send_id'));
		$t_id = $this->model->decryptdata($enc_t_id);
		$where=array("t.t_id"=>$t_id);
			$getData=$this->ts->timesheet_data($where);
			$month = $getData[0]['t_month'];
			$year = $getData[0]['t_year'];
			 
			$subject = "Timesheet of ".$getData[0]['e_name']." for ".date('M-Y',strtotime("01-$month-$year"));
			
			$m_nm = $send_id[0];
			$email = trim($send_id[1]); 
			$tm_send_arr[]=$email;
			$email_link=base_url()."ext_timesheet/timesheet/$enc_t_id/$email";
			$msg=" 
			<p>Dear $m_nm,</p>
			<p>Please click below link to approve timesheet of ".$getData[0]['e_name']." for ".date('M-Y',strtotime("01-$month-$year")).".</p>
			<!--a href='$email_link'>$email_link</a-->
			<a href='$email_link' style='background: #0f548b;padding: 5px 8px;color: #fff;text-decoration: none;box-shadow: 3px 3px 7px 1px #a9a9a9;'>Approve Timesheet</a>
			<p>
			Thanks,<br/>
			Admin Team,<br/>
			TAMS Infotech
			</p>";
			$this->model->emailSendFormat($email, $subject, $msg, 'NULL','NULL',$this->pms_email); 
			//$this->model->emailSendFormat('nikita.prajapati@staroneweb.co.in', $subject, $email.$msg, 'NULL','NULL',$this->pms_email);  
			//--- LOG --
			$session_data=$this->session->userdata('loginData');
			if(isset($session_data) AND $session_data!=""){
			$u_e_id=$session_data['e_id'];
			$u_e_type=$session_data['type'];
			$log_txt = "Timesheet Month/Year : ".date('M-Y',strtotime("01-$month-$year"))."|Send To : $email";
			$ins_arr[]=$this->ts->history_module($getData[0]['e_id'],"send_approver_email|Send Email To Approver","","$log_txt",'tbl_timesheet','Timesheet','send_email',$u_e_id,$u_e_type);
			$this->db->insert_batch("tbl_update_history",$ins_arr); 
			}			
			//--- /.LOG -- 
		echo '<span class="text-success font-500 font-12">Email has been sent Successfully</span>';
		
	} //SEND
	


} // END : CONTROLLER CLASS
?>