<?php



namespace PhpOffice\PhpSpreadsheet\Worksheet;



class MemoryDrawing extends BaseDrawing

{

    // Rendering functions

    const RENDERING_DEFAULT = 'imagepng';

    const RENDERING_PNG = 'imagepng';

    const RENDERING_GIF = 'imagegif';

    const RENDERING_JPEG = 'imagejpeg';



    // MIME types

    const MIMETYPE_DEFAULT = 'image/png';

    const MIMETYPE_PNG = 'image/png';

    const MIMETYPE_GIF = 'image/gif';

    const MIMETYPE_JPEG = 'image/jpeg';



    /**

     * Image resource.

     *

     * @var resource

     */

    private $imageResource;



    /**

     * Rendering function.

     *

     * @var string

     */

    private $renderingFunction;



    /**

     * Mime type.

     *

     * @var string

     */

    private $mimeType;



    /**

     * Unique name.

     *

     * @var string

     */

    private $uniqueName;



    /**

     * Create a new MemoryDrawing.

     */

    public function __construct()

    {

        // Initialise values

        $this->imageResource = null;

        $this->renderingFunction = self::RENDERING_DEFAULT;

        $this->mimeType = self::MIMETYPE_DEFAULT;

        $this->uniqueName = md5(rand(0, 9999) . time() . rand(0, 9999));



        // Initialize parent

        parent::__construct();

    }



    /**

     * Get image resource.

     *

     * @return resource

     */

    public function getImageResource()

    {

        return $this->imageResource;

    }



    /**

     * Set image resource.

     *

     * @param resource $value

     *

     * @return MemoryDrawing

     */

    public function setImageResource($value)

    {

        $this->imageResource = $value;



        if ($this->imageResource !== null) {

            // Get width/height

            $this->width = imagesx($this->imageResource);

            $this->height = imagesy($this->imageResource);

        }



        return $this;

    }



    /**

     * Get rendering function.

     *

     * @return string

     */

    public function getRenderingFunction()

    {

        return $this->renderingFunction;

    }



    /**

     * Set rendering function.

     *

     * @param string $value see self::RENDERING_*

     *

     * @return MemoryDrawing

     */

    public function setRenderingFunction($value)

    {

        $this->renderingFunction = $value;



        return $this;

    }



    /**

     * Get mime type.

     *

     * @return string

     */

    public function getMimeType()

    {

        return $this->mimeType;

    }



    /**

     * Set mime type.

     *

     * @param string $value see self::MIMETYPE_*

     *

     * @return MemoryDrawing

     */

    public function setMimeType($value)

    {

        $this->mimeType = $value;



        return $this;

    }



    /**

     * Get indexed filename (using image index).

     *

     * @return string

     */

    public function getIndexedFilename()

    {

        $extension = strtolower($this->getMimeType());

        $extension = explode('/', $extension);

        $extension = $extension[1];



        return $this->uniqueName . $this->getImageIndex() . '.' . $extension;

    }



    /**

     * Get hash code.

     *

     * @return string Hash code

     */

    public function getHashCode()

    {

        return md5(

            $this->renderingFunction .

            $this->mimeType .

            $this->uniqueName .

            parent::getHashCode() .

            __CLASS__

        );

    }

}

