<?php
ob_start();
defined("BASEPATH") OR exit("No direct script access allowed");
error_reporting(1);
require 'vendor/autoload.php';
use PhpOffice\PhpSpreadsheet\Spreadsheet;
use PhpOffice\PhpSpreadsheet\Writer\Xlsx;
use PhpOffice\PhpSpreadsheet\Style\Fill;
use PhpOffice\PhpSpreadsheet\Style\Border;
class Ex extends CI_Controller {
		
	//--------------------------------- LEAVE HISTORY HR -----------------------------------//
	public function index(){	
	$colors = array(
  "2"=>'00FF00',
  "3"=>'FFA500',
  "5"=>'8B0000',
	);
	print_r($colors);
	$webstats = array(
  array(
    "Domain"=>"robgravelle.com",
    "Status"=>"200 OK", 
    "Speed"=>0.57,
    "Last Backup"=>"2017-10-27",
    "SSL Certificate?"=>"No"
  ),
  array(
    "Domain"=>"buysci-fi.com",
    "Status"=>"301 redirect detected", 
    "Speed"=>1.08,
    "Last Backup"=>"2017-10-27",
    "SSL Certificate?"=>"Yes"
  ),
  array(	
    "Domain"=>"captains-blog.com",
    "Status"=>"500 Server Error!", 
    "Speed"=>0.52,
    "Last Backup"=>"2017-09-27",
    "SSL Certificate?"=>"Yes"
  )
);
 
// Create new Spreadsheet object
$spreadsheet = new Spreadsheet();
$activeSheet = $spreadsheet->getActiveSheet();
$activeSheet->setTitle('Website Stats Page');
$activeSheet->getDefaultStyle()->getFont()->setName('Times New Roman');
$activeSheet->setCellValue('A1', 'Website Stats Page');
$activeSheet->getStyle("A1")->getFont()->setSize(16);
 
//output headers
$activeSheet->fromArray(array_keys($webstats[0]), NULL, 'A3');
$activeSheet->getStyle('A3:E3')->applyFromArray(
   array(
      'fill' => array(
          'type' => Fill::FILL_SOLID,
          'color' => array('rgb' => 'E5E4E2' )
      ),
      'font'  => array(
          'bold'  =>  true
      )
   )
 );
foreach($webstats as $key => $domain) {
  $row = (int)$key+5;
  $activeSheet->setCellValue('B'.$row, $domain['Domain']);
  $activeSheet->getCell('B'.$row)
    ->getHyperlink()
    ->setUrl('http://www.'.$domain['Domain'])
    ->setTooltip('Click here to visit site');
   
  $activeSheet->setCellValue('B'.$row , $domain['Status']);
  $activeSheet->getStyle('B'.$row)->applyFromArray(
    array(
        'fill' => array(
            'type' => Fill::FILL_SOLID,
            'color' => array('rgb' => $colors[$domain['Status'][0]] )
        ),
        'font'  => array(
            'color' =>   array('rgb' => 'FFFFFF')
        )
    )
  );
   
  $activeSheet->setCellValue('C'.$row , $domain['Speed']);
  $activeSheet->setCellValue('D'.$row , $domain['Last Backup']);
  $activeSheet->setCellValue('E'.$row , $domain['SSL Certificate?']); 
}
 
foreach (range('B','E') as $col) {
  $activeSheet->getColumnDimension($col)->setAutoSize(true);  
}
   
$styleArray = array(
    'borders' => array(
        'allborders' => array(
            'style' => Border::BORDER_MEDIUM,
            'color' => array('argb' => '000000'),
        ),
    ),
);
$activeSheet->getStyle('A3:E'.$row)->applyFromArray($styleArray);
 
// Redirect output to a client's web browser (Xlsx)
header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
header('Content-Disposition: attachment;filename="webstats.xlsx"');
header('Cache-Control: max-age=0');
// If you're serving to IE 9, then the following may be needed
header('Cache-Control: max-age=1');
 
// If you're serving to IE over SSL, then the following may be needed
header('Expires: Mon, 26 Jul 1997 05:00:00 GMT'); // Date in the past
header('Last-Modified: ' . gmdate('D, d M Y H:i:s') . ' GMT'); // always modified
header('Cache-Control: cache, must-revalidate'); // HTTP/1.1
header('Pragma: public'); // HTTP/1.0
 
$writer = IOFactory::createWriter($spreadsheet, 'Xlsx');
$writer->save('php://output');
exit;
}
}